/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.PopulationLevelResult;
import uk.ac.ed.inf.pepa.ctmc.SequentialComponent;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.MeasurementData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.State;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.ActivityMultisetVisitor;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.Expander;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.StateSpaceMap;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.TransitionEntry;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.TransitionList;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.Process;

public class CopyOfRecursiveBuilder
implements IStateSpaceBuilder {
    private static Logger logger = Logger.getLogger(CopyOfRecursiveBuilder.class);
    private Stack<Process> stack = new Stack();
    private Model derivable = null;
    private IProgressMonitor monitor = new DoNothingMonitor();

    public CopyOfRecursiveBuilder(Model derivablePepaModel) {
        this.derivable = derivablePepaModel;
        Expander expander = new Expander();
        this.derivable.getSystemEquation().accept(expander);
        this.stack.push(expander.expanded);
    }

    @Override
    public IStateSpace derive(boolean allowPassiveTransitions, IProgressMonitor progressMonitor) throws DerivationException {
        if (progressMonitor != null) {
            this.monitor = progressMonitor;
        }
        StateSpaceMap stateSpace = new StateSpaceMap();
        int log_maxSize = -1;
        this.monitor.beginTask(-1);
        long totalExploration = 0L;
        int totalTransitions = 0;
        int numStates = 0;
        while (!this.stack.isEmpty()) {
            Process process;
            if (this.monitor.isCanceled()) {
                return null;
            }
            this.monitor.worked(1);
            if (log_maxSize < this.stack.size()) {
                log_maxSize = this.stack.size();
            }
            if (stateSpace.containsState(process = this.stack.pop())) continue;
            long tic = System.nanoTime();
            ActivityMultisetVisitor visitor = new ActivityMultisetVisitor();
            process.accept(visitor);
            if (!visitor.isSuccess()) {
                throw visitor.getCause();
            }
            totalExploration += System.nanoTime() - tic;
            TransitionList transitions = visitor.getTransitions();
            totalTransitions += transitions.size();
            ++numStates;
            if (transitions.size() == 0) {
                String message = "Absorption state found for state " + process.prettyPrint();
                throw new DerivationException(message);
            }
            if (transitions.hasPassiveRates() && !allowPassiveTransitions) {
                throw new DerivationException("State " + process.prettyPrint() + " has passive rates in its transition set.");
            }
            stateSpace.put(process, transitions);
            Iterator<TransitionEntry> iter = transitions.iterator();
            while (iter.hasNext()) {
                Process target = iter.next().target;
                if (this.stack.contains(target)) continue;
                this.stack.push(target);
            }
        }
        IStateSpace iStateSpace = this.createStateSpace(stateSpace.getMap());
        this.monitor.done();
        return iStateSpace;
    }

    private IStateSpace createStateSpace(final Map<Process, TransitionList> stateSpace) {
        return new IStateSpace(){
            private ArrayList<Process> processes;
            private Map<Process, TransitionList> map;
            {
                this.processes = new ArrayList(map.keySet());
                this.map = map;
            }

            @Override
            public int size() {
                return stateSpace.size();
            }

            public Process get(int index) {
                return this.processes.get(index);
            }

            public int indexOf(Process process) {
                int index = this.processes.indexOf(process);
                return index;
            }

            public Iterator<TransitionEntry> getTransitionListIterator(Process process) {
                return this.map.get(process).iterator();
            }

            public Iterator<Process> getProcessIterator() {
                return this.map.keySet().iterator();
            }

            public State getInitialState() {
                return null;
            }

            public int getNumberOfSequentialComponents() {
                return 0;
            }

            public String getLabel(State state, int position) {
                return null;
            }

            public Iterator<State> getStateIterator() {
                return null;
            }

            public boolean isUnnamed(State state, int position) {
                return false;
            }

            public State[] getTransitions(State state) {
                return null;
            }

            public void computeSteadyStateDistribution(OptionMap options, IProgressMonitor monitor) throws SolverException {
            }

            public double[] getSolution() {
                return null;
            }

            public double getSolution(State state) {
                return 0.0;
            }

            @Override
            public ThroughputResult[] getThroughput() {
                return null;
            }

            @Override
            public SequentialComponent[] getUtilisation() {
                return null;
            }

            public State getState(int index) {
                return null;
            }

            public int[] getIncomingStateIndices(State state) {
                return null;
            }

            public int[] getOutgoingStateIndices(State state) {
                return null;
            }

            public String[] getAction(State source, State target) {
                return null;
            }

            @Override
            public short getProcessId(String process) {
                return 0;
            }

            public int getNumberOfCopies(State state, short processId) {
                return 0;
            }

            @Override
            public String[] getComponentNames() {
                return null;
            }

            @Override
            public PopulationLevelResult[] getPopulationLevels() {
                return null;
            }

            @Override
            public boolean isSolutionAvailable() {
                return false;
            }

            public double getRate(State source, State target) {
                return 0.0;
            }

            @Override
            public void setSolution(double[] solution) {
            }

            @Override
            public String[] getAction(int source, int target) {
                return null;
            }

            @Override
            public int[] getIncomingStateIndices(int stateIndex) {
                return null;
            }

            @Override
            public String getLabel(int stateIndex, int position) {
                return null;
            }

            @Override
            public int getNumberOfCopies(int stateIndex, short processId) {
                return 0;
            }

            @Override
            public int[] getOutgoingStateIndices(int stateIndex) {
                return null;
            }

            @Override
            public short getProcessId(int stateIndex, int position) {
                return 0;
            }

            @Override
            public double getRate(int source, int target) {
                return 0.0;
            }

            @Override
            public double getSolution(int index) {
                return 0.0;
            }

            @Override
            public boolean isUnnamed(int stateIndex, int position) {
                return false;
            }

            @Override
            public void dispose() {
            }

            public Object getGeneratorMatrix(Class clazz) {
                return null;
            }

            @Override
            public int getMaximumNumberOfSequentialComponents() {
                return 0;
            }

            @Override
            public int getNumberOfSequentialComponents(int stateIndex) {
                return 0;
            }
        };
    }

    private void printStateSpace(Map<Process, TransitionList> stateSpace) {
        logger.debug((Object)"State Space:");
        ArrayList<Process> list = new ArrayList<Process>(stateSpace.keySet());
        for (Process state : list) {
            TransitionList transitions = stateSpace.get(state);
            StringBuffer dest = new StringBuffer();
            dest.append(String.valueOf(list.indexOf(state) + 1) + " " + state.prettyPrint() + " -> { ");
            Iterator<TransitionEntry> trans = transitions.iterator();
            while (trans.hasNext()) {
                Process destinationProcess = trans.next().target;
                dest.append(list.indexOf(destinationProcess) + 1 + " ");
            }
            dest.append("}");
            logger.debug((Object)dest.toString());
        }
    }

    private static void log(Process p, TransitionList transitions) {
        if (logger.isDebugEnabled()) {
            Iterator<TransitionEntry> iter = transitions.iterator();
            while (iter.hasNext()) {
                TransitionEntry entry = iter.next();
                if (entry.activity == null) {
                    logger.debug((Object)"Null activity?!?!?");
                    continue;
                }
                logger.debug((Object)(String.valueOf(p.prettyPrint()) + " -> " + entry.activity.prettyPrint() + " -> " + entry.target.prettyPrint()));
            }
        }
    }

    @Override
    public MeasurementData getMeasurementData() {
        return null;
    }
}

