/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.ctmc.derivation.internal.recursive.TransitionEntry;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.model.Activity;
import uk.ac.ed.inf.pepa.model.PassiveRate;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Rate;
import uk.ac.ed.inf.pepa.model.internal.DoMakePepaProcess;

public class TransitionList {
    private static Logger logger = Logger.getLogger(TransitionList.class);
    private final LinkedList<Activity> keys = new LinkedList();
    private final LinkedList<Process> values = new LinkedList();

    public void addTransition(Action action, Rate rate, Process target) {
        this.keys.add(DoMakePepaProcess.getInstance().createActivity(action, rate));
        this.values.add(target);
    }

    public Iterator<TransitionEntry> iterator() {
        return new Iterator<TransitionEntry>(){
            private int index = 0;
            private boolean canRemove = true;

            @Override
            public boolean hasNext() {
                return this.index < TransitionList.this.keys.size();
            }

            @Override
            public TransitionEntry next() {
                this.canRemove = true;
                TransitionEntry entry = new TransitionEntry((Activity)TransitionList.this.keys.get(this.index), (Process)TransitionList.this.values.get(this.index));
                ++this.index;
                return entry;
            }

            @Override
            public void remove() {
                if (this.index < 1) {
                    throw new UnsupportedOperationException("Transitions cannot be removed");
                }
                if (!this.canRemove) {
                    throw new IllegalStateException("Remove cannot be called twice on the same element!");
                }
                this.canRemove = false;
                TransitionList.this.keys.remove(this.index - 1);
                TransitionList.this.values.remove(this.index - 1);
                --this.index;
            }
        };
    }

    public boolean containsAction(Action action) {
        for (Activity activity : this.keys) {
            if (!action.equals(activity.getAction())) continue;
            return true;
        }
        return false;
    }

    public List<Activity> getActivity(Action action) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (Activity activity : this.keys) {
            if (!action.equals(activity.getAction())) continue;
            activities.add(activity);
        }
        return activities;
    }

    public Process getTarget(Activity activity) {
        Iterator iter = this.keys.iterator();
        Activity current = null;
        int index = 0;
        while (iter.hasNext()) {
            current = (Activity)iter.next();
            if (current == activity) {
                return this.values.get(index);
            }
            ++index;
        }
        throw new NoSuchElementException();
    }

    public void changeTarget(Process oldProcess, Process newProcess) {
        Iterator iter = this.values.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Process current = (Process)iter.next();
            if (current == oldProcess) {
                this.values.set(index, newProcess);
            }
            ++index;
        }
    }

    public int size() {
        return this.keys.size();
    }

    public boolean hasPassiveRates() {
        int i = 0;
        while (i < this.keys.size()) {
            Activity activity = this.keys.get(i);
            if (activity.getRate() instanceof PassiveRate) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

