/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker;

import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;

public class KroneckerDisplayAction {
    private short actionID;
    private double rate;
    private KroneckerDisplayModel model;

    public KroneckerDisplayAction(short actionID, double rate, KroneckerDisplayModel model) {
        this.actionID = actionID;
        this.rate = rate;
        this.model = model;
    }

    public short getID() {
        return this.actionID;
    }

    public double getRate() {
        return this.rate;
    }

    private String printRate() {
        if (this.rate >= 0.0) {
            return String.valueOf(this.rate);
        }
        if (this.rate == -1.0) {
            return "T";
        }
        return String.valueOf(String.valueOf(-this.rate)) + "T";
    }

    public String getLabel(boolean isShort) {
        if (isShort) {
            return this.model.getActionName(this.actionID);
        }
        return "(" + this.model.getActionName(this.actionID) + ", " + this.printRate() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof KroneckerDisplayAction) {
            KroneckerDisplayAction action = (KroneckerDisplayAction)o;
            return this.actionID == action.actionID && this.rate == action.rate;
        }
        return false;
    }
}

