/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker;

import java.util.HashMap;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.IPropertyChangedListener;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;

public class KroneckerDisplayModel {
    private HashMap<Short, KroneckerDisplayState> stateMap;
    private PropertyBank propertyBank;
    private KroneckerDisplayComponent[] components;
    private int numComponents;
    private ISymbolGenerator symbolGenerator;

    public KroneckerDisplayModel(int numComponents, ISymbolGenerator symbolGenerator, PropertyBank propertyBank) {
        this.symbolGenerator = symbolGenerator;
        this.numComponents = numComponents;
        this.components = new KroneckerDisplayComponent[numComponents];
        this.stateMap = new HashMap();
        this.propertyBank = propertyBank;
    }

    public KroneckerDisplayComponent getComponent(int componentID) {
        return this.components[componentID];
    }

    public KroneckerDisplayState getState(short state) {
        KroneckerDisplayState s = this.stateMap.get(state);
        if (s == null) {
            s = new KroneckerDisplayState(state, this);
            this.stateMap.put(state, s);
        }
        return s;
    }

    public void initialiseComponent(int componentID, short initialState, SequentialAbstraction abstraction) {
        this.components[componentID] = new KroneckerDisplayComponent(componentID, this.getState(initialState), this, this.propertyBank, abstraction);
    }

    public String getStateName(short state, boolean isShort) {
        String name = this.symbolGenerator.getProcessLabel(state);
        return isShort ? this.contract(name) : name;
    }

    private String contract(String name) {
        String newString = "";
        boolean inActivity = false;
        boolean inString = false;
        boolean inRate = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '\"') {
                inString = !inString;
                newString = String.valueOf(newString) + c;
            } else if (inString) {
                newString = String.valueOf(newString) + c;
            } else if (c == '(' && !inActivity) {
                inActivity = true;
            } else if (!inActivity) {
                newString = String.valueOf(newString) + c;
            } else if (c == ',') {
                inRate = true;
            } else if (c == ')') {
                inActivity = false;
                inRate = false;
            } else if (!inRate) {
                newString = String.valueOf(newString) + c;
            }
            ++i;
        }
        return newString;
    }

    public String getActionName(short actionID) {
        return this.symbolGenerator.getActionLabel(actionID);
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String[] getAtomicProperties() {
        return this.propertyBank.getAtomicPropertyNames();
    }

    public boolean containsCSLPropertyName(String name) {
        return this.propertyBank.containsCSLPropertyName(name);
    }

    public boolean addCSLProperty(String name, CSLAbstractStateProperty property) {
        return this.propertyBank.addCSLProperty(name, property);
    }

    public void removeCSLProperty(String name) {
        this.propertyBank.removeCSLProperty(name);
    }

    public boolean changeCSLProperty(String oldName, CSLAbstractStateProperty oldProperty, String newName, CSLAbstractStateProperty newProperty) {
        return this.propertyBank.changeCSLProperty(oldName, oldProperty, newName, newProperty);
    }

    public String[] getCSLPropertyNames() {
        return this.propertyBank.getCSLPropertyNames();
    }

    public CSLAbstractStateProperty getCSLProperty(String name) {
        return this.propertyBank.getCSLProperty(name);
    }

    public String getCSLPropertyValue(String name) {
        return this.propertyBank.getCSLPropertyValue(name);
    }

    public void setCSLPropertyValue(String name, String value) {
        this.propertyBank.setCSLPropertyValue(name, value);
    }

    public void addPropertyChangedListener(IPropertyChangedListener propertyChangedListener) {
        this.propertyBank.addPropertyChangedListener(propertyChangedListener);
    }
}

