/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.PropertyDependencyException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AtomicProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;

public class KroneckerDisplayPropertyMap {
    private int componentID;
    private PropertyBank propertyBank;
    private HashMap<String, AtomicProperty> propertyMap;
    private KroneckerDisplayComponent component;
    private SequentialAbstraction abstractStateSpace;
    private SequentialStateSpace concreteStateSpace;

    public KroneckerDisplayPropertyMap(PropertyBank propertyBank, KroneckerDisplayComponent component, SequentialAbstraction stateSpace) {
        this.componentID = component.getComponentID();
        this.propertyBank = propertyBank;
        this.component = component;
        this.abstractStateSpace = stateSpace;
        this.concreteStateSpace = stateSpace.getConcreteStateSpace();
        this.propertyMap = new HashMap();
        propertyBank.register(this);
    }

    public void notifyAddProperty(String name, AtomicProperty property) {
        property.addPropertyMap(this.componentID, this.concreteStateSpace, true);
        this.propertyMap.put(name, property);
    }

    public String addProperty(String name) {
        return this.propertyBank.addAtomicProperty(name);
    }

    public String addProperty() {
        return this.propertyBank.addAtomicProperty();
    }

    public void notifyRemoveProperty(String name) {
        this.propertyMap.remove(name);
    }

    public void removeProperty(String name) throws PropertyDependencyException {
        this.propertyBank.removeAtomicProperty(name);
    }

    public void notifyRenameProperty(String oldName, String newName) {
        AtomicProperty property = this.propertyMap.remove(oldName);
        this.propertyMap.put(newName, property);
    }

    public String renameProperty(String oldName, String newName) {
        return this.propertyBank.renameAtomicProperty(oldName, newName);
    }

    public void setProperty(String name, ArrayList<KroneckerDisplayState> states, boolean isTrue) {
        AtomicProperty property = this.propertyMap.get(name);
        if (property == null) {
            return;
        }
        for (KroneckerDisplayState state : states) {
            int index = this.concreteStateSpace.getIndex(state.getID());
            property.setProperty(this.componentID, index, isTrue);
        }
        this.propertyBank.notifyCSLPropertyValueChanged(name);
    }

    public void setPropertyAll(String name, boolean isTrue) {
        AtomicProperty property = this.propertyMap.get(name);
        if (property == null) {
            return;
        }
        property.setPropertyAll(this.componentID, isTrue);
        this.propertyBank.notifyCSLPropertyValueChanged(name);
    }

    public ArrayList<KroneckerDisplayState> getStates(String name, boolean isTrue) {
        int numStates = this.concreteStateSpace.size();
        AtomicProperty property = this.propertyMap.get(name);
        ArrayList<KroneckerDisplayState> states = new ArrayList<KroneckerDisplayState>(numStates);
        if (property == null) {
            return states;
        }
        int i = 0;
        while (i < numStates) {
            if (property.getProperty(this.componentID, i) == isTrue) {
                states.add(this.component.getModel().getState(this.concreteStateSpace.getState(i)));
            }
            ++i;
        }
        return states;
    }

    public ArrayList<KroneckerDisplayState> getAllStates() {
        ArrayList<KroneckerDisplayState> allStates = new ArrayList<KroneckerDisplayState>(this.concreteStateSpace.size());
        int i = 0;
        while (i < this.concreteStateSpace.size()) {
            allStates.add(this.component.getModel().getState(this.concreteStateSpace.getState(i)));
            ++i;
        }
        return allStates;
    }

    public boolean testProperty(String name, ArrayList<KroneckerDisplayState> states, boolean isTrue) {
        boolean isValid = true;
        AtomicProperty property = this.propertyMap.get(name);
        if (property == null) {
            return false;
        }
        for (KroneckerDisplayState state : states) {
            int index = this.concreteStateSpace.getIndex(state.getID());
            boolean bl = isValid = isValid && property.getProperty(this.componentID, index) == isTrue;
        }
        return isValid;
    }

    public boolean isConsistent(KroneckerDisplayState state) {
        short abstractState = this.abstractStateSpace.getAbstractState(state.getID());
        short[] concreteStates = this.abstractStateSpace.getConcreteStates(abstractState);
        if (concreteStates.length <= 1) {
            return true;
        }
        boolean isConsistent = true;
        for (Map.Entry<String, AtomicProperty> property : this.propertyMap.entrySet()) {
            boolean isPropertyConsistent = true;
            boolean propertyTruth = property.getValue().getProperty(this.componentID, this.concreteStateSpace.getIndex(concreteStates[0]));
            int i = 1;
            while (i < concreteStates.length) {
                if (property.getValue().getProperty(this.componentID, this.concreteStateSpace.getIndex(concreteStates[i])) != propertyTruth) {
                    isPropertyConsistent = false;
                }
                ++i;
            }
            boolean bl = isConsistent = isConsistent && isPropertyConsistent;
        }
        return isConsistent;
    }

    public String[] getProperties() {
        return this.propertyBank.getAtomicPropertyNames();
    }
}

