/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractRateMatrix;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.NextStateInformation;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerActionManager;

public class AbstractKroneckerComponent {
    private SequentialAbstraction abstraction;
    private AbstractRateMatrix[] syncModel;
    private AbstractRateMatrix localModel;

    public AbstractKroneckerComponent(int componentID, SequentialAbstraction abstraction, KroneckerActionManager actionManager, AbstractRateMatrix[] syncModel, AbstractRateMatrix localModel) {
        this.abstraction = abstraction;
        this.syncModel = syncModel;
        this.localModel = localModel;
    }

    public SequentialAbstraction getAbstraction() {
        return this.abstraction;
    }

    public double getSyncLowerRate(int action, short state) {
        return this.syncModel[action].getLowerRate(state);
    }

    public double getSyncUpperRate(int action, short state) {
        return this.syncModel[action].getUpperRate(state);
    }

    public NextStateInformation nextSyncStates(int action, short state) {
        return this.syncModel[action].nextStates(state);
    }

    public double getLocalLowerRate(short state) {
        return this.localModel.getLowerRate(state);
    }

    public double getLocalUpperRate(short state) {
        return this.localModel.getUpperRate(state);
    }

    public NextStateInformation nextLocalStates(short state) {
        return this.localModel.nextStates(state);
    }
}

