/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractKroneckerComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerUtilities;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.NextStateInformation;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.ApparentRateCalculator;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerActionManager;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCTransition;

public class AbstractKroneckerModel {
    private int numComponents;
    private KroneckerActionManager actionManager;
    private AbstractKroneckerComponent[] model;
    private double uniformisationConstant;
    private double maximumExitRate;

    public AbstractKroneckerModel(int numComponents, KroneckerActionManager actionManager, AbstractKroneckerComponent[] model, double uniformisationConstant) {
        this.actionManager = actionManager;
        this.numComponents = numComponents;
        this.model = model;
        this.uniformisationConstant = uniformisationConstant;
        this.maximumExitRate = 0.0;
    }

    public double getUniformisationConstant() {
        return this.uniformisationConstant;
    }

    public void optimiseUniformisationConstant() {
        this.uniformisationConstant = this.maximumExitRate;
    }

    public ArrayList<AbstractCTMCTransition> getTransitionsFrom(AbstractCTMCState state) throws DerivationException {
        AbstractCTMCTransition transition;
        short[] nextState;
        int j;
        short[] stateID = state.getState();
        assert (stateID.length == this.numComponents);
        ArrayList<AbstractCTMCTransition> transitions = new ArrayList<AbstractCTMCTransition>(10);
        int action = 0;
        while (action < this.numSyncActions()) {
            double apparentLower = this.model[0].getSyncLowerRate(action, stateID[0]);
            double apparentUpper = this.model[0].getSyncUpperRate(action, stateID[0]);
            int i = 1;
            while (i < this.numComponents) {
                apparentLower = KroneckerUtilities.rateMin(apparentLower, this.model[i].getSyncLowerRate(action, stateID[i]));
                apparentUpper = KroneckerUtilities.rateMin(apparentUpper, this.model[i].getSyncUpperRate(action, stateID[i]));
                ++i;
            }
            double lowerRate = apparentLower / this.uniformisationConstant;
            double upperRate = apparentUpper / this.uniformisationConstant;
            if (apparentUpper != 0.0) {
                int totalStates = 1;
                int[] numStates = new int[this.numComponents];
                short[][] nextStates = new short[this.numComponents][];
                double[][] nextLowerProb = new double[this.numComponents][];
                double[][] nextUpperProb = new double[this.numComponents][];
                int i2 = 0;
                while (i2 < this.numComponents) {
                    short currentState = stateID[i2];
                    AbstractKroneckerComponent component = this.model[i2];
                    NextStateInformation nextInfo = component.nextSyncStates(action, currentState);
                    nextStates[i2] = nextInfo.getNextStates();
                    nextLowerProb[i2] = nextInfo.getNextLowerProbabilities();
                    nextUpperProb[i2] = nextInfo.getNextUpperProbabilities();
                    numStates[i2] = nextStates[i2].length;
                    totalStates *= nextStates[i2].length;
                    ++i2;
                }
                int[] currentState = new int[this.numComponents];
                j = 0;
                while (j < totalStates) {
                    nextState = new short[this.numComponents];
                    double lowerProb = lowerRate;
                    double upperProb = upperRate;
                    int k = 0;
                    while (k < this.numComponents) {
                        nextState[k] = nextStates[k][currentState[k]];
                        lowerProb *= nextLowerProb[k][currentState[k]];
                        upperProb *= nextUpperProb[k][currentState[k]];
                        ++k;
                    }
                    AbstractCTMCState nextCTMCState = new AbstractCTMCState(nextState);
                    transition = new AbstractCTMCTransition(state, nextCTMCState, (short)action, lowerProb, upperProb);
                    transitions.add(transition);
                    KroneckerUtilities.incrementArray(currentState, numStates);
                    ++j;
                }
            }
            ++action;
        }
        this.fixApparentRates(state, transitions);
        double lowerExitProb = 0.0;
        double upperExitProb = 0.0;
        for (AbstractCTMCTransition t : transitions) {
            lowerExitProb += t.getMinProb();
            upperExitProb += t.getMaxProb();
        }
        int i = 0;
        while (i < this.numComponents) {
            short currentState = stateID[i];
            AbstractKroneckerComponent component = this.model[i];
            NextStateInformation nextInfo = component.nextLocalStates(currentState);
            short[] nextStates = nextInfo.getNextStates();
            double[] nextLowerProb = nextInfo.getNextLowerProbabilities();
            double[] nextUpperProb = nextInfo.getNextUpperProbabilities();
            double lowerRate = component.getLocalLowerRate(currentState) / this.uniformisationConstant;
            double upperRate = component.getLocalUpperRate(currentState) / this.uniformisationConstant;
            if (upperRate != 0.0) {
                j = 0;
                while (j < nextStates.length) {
                    if (nextStates[j] != currentState) {
                        nextState = new short[this.numComponents];
                        int k = 0;
                        while (k < nextState.length) {
                            nextState[k] = k == i ? nextStates[j] : stateID[k];
                            ++k;
                        }
                        assert (!Arrays.equals(nextState, stateID));
                        AbstractCTMCState nextCTMCState = new AbstractCTMCState(nextState);
                        if (upperRate * nextUpperProb[j] > 0.0) {
                            double lowerProb = lowerRate * nextLowerProb[j];
                            double upperProb = upperRate * nextUpperProb[j];
                            transition = new AbstractCTMCTransition(state, nextCTMCState, lowerProb, upperProb);
                            lowerExitProb += lowerProb;
                            upperExitProb += upperProb;
                            transitions.add(transition);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        assert (upperExitProb <= 1.0000001);
        upperExitProb = Math.min(upperExitProb, 1.0);
        this.maximumExitRate = Math.max(this.maximumExitRate, upperExitProb * this.uniformisationConstant);
        if (lowerExitProb < 1.0) {
            AbstractCTMCTransition self_loop = new AbstractCTMCTransition(state, state, 1.0 - upperExitProb, 1.0 - lowerExitProb);
            transitions.add(self_loop);
        }
        return transitions;
    }

    private void fixApparentRates(AbstractCTMCState state, ArrayList<AbstractCTMCTransition> transitions) throws DerivationException {
        short[] startState = state.getState();
        for (Map.Entry<Short, ArrayList<Short>> actions2 : this.actionManager.getExternalActions()) {
            short externalID = actions2.getKey();
            ArrayList<Short> internalIDs = actions2.getValue();
            if (internalIDs.size() == 1) continue;
            double[] upperRates = new double[this.numComponents];
            double[] lowerRates = new double[this.numComponents];
            int i = 0;
            while (i < this.numComponents) {
                upperRates[i] = -1.0;
                lowerRates[i] = -1.0;
                for (short internalID : internalIDs) {
                    lowerRates[i] = Math.max(lowerRates[i], this.model[i].getSyncLowerRate(internalID, startState[i]));
                    upperRates[i] = Math.max(upperRates[i], this.model[i].getSyncUpperRate(internalID, startState[i]));
                }
                ++i;
            }
            ApparentRateCalculator calculator = this.actionManager.getApparentRateCalculator(externalID);
            double lowerApparentRate = calculator.compute(lowerRates) / this.uniformisationConstant;
            double upperApparentRate = calculator.compute(upperRates) / this.uniformisationConstant;
            double totalLowerExitRate = 0.0;
            double totalUpperExitRate = 0.0;
            for (AbstractCTMCTransition t : transitions) {
                if (!internalIDs.contains(t.getActionID())) continue;
                totalLowerExitRate += t.getMinProb();
                totalUpperExitRate += t.getMaxProb();
            }
            if (totalUpperExitRate == 0.0) continue;
            for (AbstractCTMCTransition t : transitions) {
                if (!internalIDs.contains(t.getActionID())) continue;
                double maxProb = t.getMaxProb() * upperApparentRate / totalUpperExitRate;
                t.setMaxProb(maxProb);
                if (totalLowerExitRate == 0.0) continue;
                double minProb = t.getMinProb() * lowerApparentRate / totalLowerExitRate;
                t.setMinProb(minProb);
            }
        }
    }

    public SequentialAbstraction[] getAbstractStateSpace() {
        SequentialAbstraction[] abstractStateSpace = new SequentialAbstraction[this.numComponents];
        int i = 0;
        while (i < this.numComponents) {
            abstractStateSpace[i] = this.model[i].getAbstraction();
            ++i;
        }
        return abstractStateSpace;
    }

    public int numSyncActions() {
        return this.actionManager.getNumSyncActions();
    }
}

