/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.NextStateInformation;

public class AbstractRateMatrix {
    private SparseVector lowerRates;
    private SparseVector upperRates;
    private FlexCompRowMatrix lowerProbMatrix;
    private FlexCompRowMatrix upperProbMatrix;
    private boolean isEmpty;
    private SequentialAbstraction abstraction;

    public AbstractRateMatrix(SequentialAbstraction abstraction, SparseVector lowerRates, SparseVector upperRates, FlexCompRowMatrix lowerProbMatrix, FlexCompRowMatrix upperProbMatrix) {
        int size = abstraction.size();
        assert (size == lowerRates.size());
        assert (size == upperRates.size());
        assert (lowerProbMatrix.isSquare() && size == lowerProbMatrix.numColumns());
        assert (upperProbMatrix.isSquare() && size == upperProbMatrix.numColumns());
        this.abstraction = abstraction;
        this.lowerRates = lowerRates;
        this.upperRates = upperRates;
        this.lowerProbMatrix = lowerProbMatrix;
        this.upperProbMatrix = upperProbMatrix;
        this.isEmpty = false;
    }

    public AbstractRateMatrix(SequentialAbstraction abstraction) {
        this.abstraction = abstraction;
        this.isEmpty = true;
    }

    public double getLowerRate(short state) {
        if (this.isEmpty) {
            return -1.0;
        }
        return this.lowerRates.get((int)state);
    }

    public double getUpperRate(short state) {
        if (this.isEmpty) {
            return -1.0;
        }
        return this.upperRates.get((int)state);
    }

    public NextStateInformation nextStates(short state) {
        NextStateInformation nextStates = new NextStateInformation();
        if (this.isEmpty) {
            nextStates.addState(state, 1.0, 1.0);
        } else {
            SparseVector probDist = this.upperProbMatrix.getRow((int)state);
            for (VectorEntry v : probDist) {
                int index = v.index();
                short nextState = (short)index;
                double lowerProb = this.lowerProbMatrix.get((int)state, index);
                double upperProb = v.get();
                if (!(upperProb > 0.0)) continue;
                nextStates.addState(nextState, lowerProb, upperProb);
            }
        }
        return nextStates;
    }

    public int size() {
        return this.abstraction.size();
    }
}

