/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.MeasurementData;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IStateExplorer;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerStateSpace;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalActionList;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerActionManager;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerApparentRateVisitor;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerImplicitChoiceVisitor;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerSystemEquationVisitor;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.SystemComponentInfo;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;

public class KroneckerBuilder
implements IStateSpaceBuilder {
    private final ISymbolGenerator generator;
    private IStateExplorer explorer;
    private ProcessNode systemEquation;
    private KroneckerActionManager actionManager;

    public KroneckerBuilder(IStateExplorer explorer, ISymbolGenerator generator, ProcessNode systemEquation, int productId, IResourceManager manager) {
        this.explorer = explorer;
        this.generator = generator;
        this.systemEquation = systemEquation;
        this.actionManager = new KroneckerActionManager(generator);
    }

    private ArrayList<Transition> getTransitions(short processId) {
        return this.explorer.getData((short)processId).fFirstStepDerivative;
    }

    private void exploreSystemEquation() throws DerivationException {
        SystemComponentInfo componentInfo = new SystemComponentInfo();
        KroneckerSystemEquationVisitor componentVisitor = new KroneckerSystemEquationVisitor(componentInfo);
        this.systemEquation.accept(componentVisitor);
        if (!componentVisitor.canMakeKronecker()) {
            throw new DerivationException("Cannot construct a Kronecker representation for a model with aggregation or hiding.");
        }
        KroneckerImplicitChoiceVisitor choiceVisitor = new KroneckerImplicitChoiceVisitor(this.generator, this.actionManager, componentInfo);
        this.systemEquation.accept(choiceVisitor);
        this.actionManager.indexActions();
        for (Map.Entry<Short, ArrayList<Short>> action : this.actionManager.getExternalActions()) {
            short actionID = action.getKey();
            KroneckerApparentRateVisitor rateVisitor = new KroneckerApparentRateVisitor(this.systemEquation, actionID, this.generator);
            this.actionManager.addApparentRateCalculator(actionID, rateVisitor.getCalculator());
        }
    }

    private SequentialStateSpace exploreComponent(int component) {
        SequentialStateSpace componentStates = new SequentialStateSpace();
        short[] initialState = this.generator.getInitialState();
        LinkedList<Short> queue = new LinkedList<Short>();
        queue.add(initialState[component]);
        componentStates.addState(initialState[component]);
        while (!queue.isEmpty()) {
            short state = (Short)queue.remove();
            ArrayList<Transition> found = this.getTransitions(state);
            for (Transition t : found) {
                short s = t.fTargetProcess[component];
                if (!componentStates.containsState(s)) {
                    componentStates.addState(s);
                    queue.add(s);
                }
                this.actionManager.addActionType(component, t.fActionId);
            }
        }
        return componentStates;
    }

    @Override
    public IStateSpace derive(boolean allowPassiveRates, IProgressMonitor monitor) throws DerivationException {
        short[] initialState = this.generator.getInitialState();
        int numComponents = initialState.length;
        KroneckerModel model = new KroneckerModel(numComponents, this.actionManager, this.generator);
        SequentialStateSpace[] componentStates = new SequentialStateSpace[numComponents];
        int component = 0;
        while (component < numComponents) {
            componentStates[component] = this.exploreComponent(component);
            ++component;
        }
        this.exploreSystemEquation();
        component = 0;
        while (component < numComponents) {
            model.initialiseComponent(component, initialState[component], componentStates[component]);
            int j = 0;
            while (j < componentStates[component].size()) {
                short state = componentStates[component].getState(j);
                ArrayList<Transition> found = this.getTransitions(state);
                for (Transition t : found) {
                    InternalActionList actions2 = this.actionManager.getActions(component, t.fActionId);
                    for (InternalAction action : actions2) {
                        model.addTransition(action, component, state, t.fTargetProcess[component], t.fRate);
                    }
                }
                ++j;
            }
            ++component;
        }
        model.normaliseRateMatrices();
        return new KroneckerStateSpace(this.generator, model);
    }

    @Override
    public MeasurementData getMeasurementData() {
        return null;
    }
}

