/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialOrder;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractKroneckerComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractRateMatrix;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.RateMatrix;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.StateDistribution;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerActionManager;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.LocalComponentRateContext;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.RateContext;

public class KroneckerComponent {
    private SequentialStateSpace concreteStateSpace;
    private SequentialAbstraction abstractStateSpace;
    private int numSyncActions;
    private int componentID;
    private RateMatrix[] syncModel;
    private RateMatrix localModel;
    private KroneckerActionManager actionManager;

    public KroneckerComponent(int componentID, SequentialStateSpace stateSpace, SequentialAbstraction abstraction, KroneckerActionManager actionManager) {
        this.componentID = componentID;
        this.concreteStateSpace = stateSpace;
        this.abstractStateSpace = abstraction;
        this.actionManager = actionManager;
        this.numSyncActions = actionManager.getNumSyncActions();
        this.syncModel = new RateMatrix[this.numSyncActions];
    }

    private KroneckerComponent(KroneckerComponent copy) {
        this.concreteStateSpace = copy.concreteStateSpace;
        this.abstractStateSpace = copy.abstractStateSpace;
        this.numSyncActions = copy.numSyncActions;
        this.componentID = copy.componentID;
        this.syncModel = new RateMatrix[this.numSyncActions];
        this.localModel = null;
        this.actionManager = copy.actionManager;
    }

    public void initRateMatrices() {
        int i = 0;
        while (i < this.numSyncActions) {
            this.syncModel[i] = new RateMatrix(this.componentID, this.concreteStateSpace);
            ++i;
        }
        this.localModel = new RateMatrix(this.componentID, this.concreteStateSpace);
        this.localModel.disableTransitions();
    }

    public double getMaximumRate() {
        double maxRate = this.localModel.getMaximumRate();
        int i = 0;
        while (i < this.numSyncActions) {
            maxRate += this.syncModel[i].getMaximumRate();
            ++i;
        }
        return maxRate;
    }

    public void normaliseRateMatrices() {
        int i = 0;
        while (i < this.numSyncActions) {
            this.syncModel[i].normalise();
            ++i;
        }
        this.localModel.normalise();
    }

    public void addTransition(InternalAction action, short state1, short state2, double rate) throws DerivationException {
        if (!action.isLocal()) {
            short actionIndex = this.actionManager.getActionID(action);
            this.syncModel[actionIndex].addTransition(state1, state2, action, rate);
        } else {
            this.localModel.addTransition(state1, state2, action, rate);
        }
    }

    public void addRateContext(SequentialAbstraction abstraction, SequentialOrder order, RateContext[] context) {
        int i = 0;
        while (i < this.numSyncActions) {
            this.syncModel[i].addRateContext(abstraction, order, context[i]);
            ++i;
        }
    }

    public void addEmptyRateContext(RateContext[] context) {
        int i = 0;
        while (i < this.numSyncActions) {
            this.syncModel[i].addEmptyRateContext(context[i]);
            ++i;
        }
    }

    public KroneckerComponent getAbstractCopy() {
        KroneckerComponent copy = new KroneckerComponent(this);
        int i = 0;
        while (i < this.numSyncActions) {
            copy.syncModel[i] = this.syncModel[i].getAbstractCopy();
            ++i;
        }
        copy.localModel = this.localModel.getAbstractCopy();
        return copy;
    }

    public KroneckerComponent upperBound(RateContext[] context, SequentialOrder order) {
        return this.boundComponent(context, order, true);
    }

    public KroneckerComponent lowerBound(RateContext[] context, SequentialOrder order) {
        return this.boundComponent(context, order, false);
    }

    private KroneckerComponent boundComponent(RateContext[] context, SequentialOrder order, boolean isUpper) {
        KroneckerComponent bound = new KroneckerComponent(this);
        int i = 0;
        while (i < this.numSyncActions) {
            RateMatrix new_matrix = isUpper ? this.syncModel[i].upperBound(this.abstractStateSpace, context[i].getRateContext(this.componentID), order) : this.syncModel[i].lowerBound(this.abstractStateSpace, context[i].getRateContext(this.componentID), order);
            bound.syncModel[i] = new_matrix.getLumpedMatrix(this.abstractStateSpace);
            ++i;
        }
        LocalComponentRateContext localContext = new LocalComponentRateContext(this.concreteStateSpace.size(), this.localModel.getMaximumRate());
        RateMatrix new_local_matrix = isUpper ? this.localModel.uniformiseRates().upperBound(this.abstractStateSpace, localContext, order) : this.localModel.uniformiseRates().lowerBound(this.abstractStateSpace, localContext, order);
        bound.localModel = new_local_matrix.getLumpedMatrix(this.abstractStateSpace);
        return bound;
    }

    public AbstractKroneckerComponent abstractComponent() {
        AbstractRateMatrix[] abstractSyncModel = new AbstractRateMatrix[this.numSyncActions];
        int i = 0;
        while (i < this.numSyncActions) {
            abstractSyncModel[i] = this.syncModel[i].getAbstractMatrix(this.abstractStateSpace);
            ++i;
        }
        AbstractRateMatrix abstractLocalModel = this.localModel.getAbstractMatrix(this.abstractStateSpace);
        return new AbstractKroneckerComponent(this.componentID, this.abstractStateSpace, this.actionManager, abstractSyncModel, abstractLocalModel);
    }

    private RateMatrix getSyncMatrix(int action) {
        assert (action >= 0 && action < this.numSyncActions);
        return this.syncModel[action];
    }

    private RateMatrix getLocalMatrix() {
        return this.localModel;
    }

    public boolean isPassiveLoop(int action) {
        return this.getSyncMatrix(action).isEmpty();
    }

    public double getSyncRate(int action, short state) {
        return this.getSyncMatrix(action).getRate(state);
    }

    public double getLocalRate(short state) {
        return this.getLocalMatrix().getRate(state);
    }

    public StateDistribution nextSyncStates(int action, short state) {
        return this.getSyncMatrix(action).nextStates(state);
    }

    public StateDistribution nextLocalStates(short state) {
        return this.getLocalMatrix().nextStates(state);
    }

    public StateDistribution prevSyncStates(int action, short state) {
        return this.getSyncMatrix(action).prevStates(state);
    }

    public StateDistribution prevLocalStates(short state) {
        return this.getLocalMatrix().prevStates(state);
    }

    public SequentialAbstraction getAbstraction() {
        return this.abstractStateSpace;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.numSyncActions) {
            s = String.valueOf(s) + "Action " + i + ":\n";
            s = String.valueOf(s) + this.syncModel[i].toString() + "\n";
            ++i;
        }
        s = String.valueOf(s) + "Local Actions:\n" + this.localModel.toString() + "\n";
        return s;
    }
}

