/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import java.util.ArrayList;
import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialOrder;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SimplePartialSequentialOrder;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.ISymbolGenerator;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Transition;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractKroneckerComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractKroneckerModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerUtilities;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.StateDistribution;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.ApparentRateCalculator;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.KroneckerActionManager;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.RateContext;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;

public class KroneckerModel {
    private int numComponents;
    private KroneckerActionManager actionManager;
    private KroneckerComponent[] model;
    private PropertyBank propertyBank;
    private KroneckerDisplayModel displayModel;

    public KroneckerModel(int numComponents, KroneckerActionManager actionManager, ISymbolGenerator generator) {
        this.actionManager = actionManager;
        this.numComponents = numComponents;
        this.model = new KroneckerComponent[numComponents];
        this.propertyBank = new PropertyBank(numComponents);
        this.displayModel = new KroneckerDisplayModel(numComponents, generator, this.propertyBank);
    }

    private KroneckerModel(int numComponents, KroneckerActionManager actionManager, KroneckerComponent[] model, PropertyBank propertyBank, KroneckerDisplayModel displayModel) {
        this.actionManager = actionManager;
        this.numComponents = numComponents;
        this.model = model;
        this.propertyBank = propertyBank;
        this.displayModel = displayModel;
    }

    public void initialiseComponent(int component, short initialState, SequentialStateSpace states) {
        SequentialAbstraction abstraction = new SequentialAbstraction(states);
        this.model[component] = new KroneckerComponent(component, states, abstraction, this.actionManager);
        this.model[component].initRateMatrices();
        this.displayModel.initialiseComponent(component, initialState, abstraction);
    }

    public PropertyBank getPropertyBank() {
        return this.propertyBank;
    }

    public SequentialAbstraction getAbstraction(int component) {
        return this.model[component].getAbstraction();
    }

    public SequentialAbstraction[] getAbstraction() {
        SequentialAbstraction[] abstraction = new SequentialAbstraction[this.numComponents];
        int i = 0;
        while (i < this.numComponents) {
            abstraction[i] = this.model[i].getAbstraction();
            ++i;
        }
        return abstraction;
    }

    public KroneckerModel getUpperBoundingModel(CompositionalProperty property) {
        KroneckerModel upperModel = this.getBound(property, true);
        return upperModel;
    }

    public KroneckerModel getLowerBoundingModel(CompositionalProperty property) {
        KroneckerModel lowerModel = this.getBound(property, false);
        return lowerModel;
    }

    private KroneckerModel getBound(CompositionalProperty property, boolean isUpper) {
        SequentialAbstraction abstraction;
        short[] abstractComponentProperty;
        boolean isAbstract = false;
        int i = 0;
        while (i < this.numComponents) {
            SequentialAbstraction abstraction2 = this.model[i].getAbstraction();
            if (abstraction2.size() != abstraction2.getConcreteStateSpace().size()) {
                isAbstract = true;
            }
            ++i;
        }
        if (!isAbstract) {
            return this;
        }
        KroneckerComponent[] newModel = new KroneckerComponent[this.numComponents];
        RateContext[] context = RateContext.makeNewContext(this.numComponents, this.numSyncActions());
        SequentialOrder[] orders = new SequentialOrder[this.numComponents];
        short[][] abstractProperty = property.getAbstractProperty();
        int i2 = 0;
        while (i2 < this.numComponents) {
            abstractComponentProperty = abstractProperty[i2];
            abstraction = this.model[i2].getAbstraction();
            if (abstractComponentProperty.length == abstraction.size()) {
                this.model[i2].addEmptyRateContext(context);
            } else {
                abstraction.reorderStateSpace(abstractComponentProperty);
                orders[i2] = new SimplePartialSequentialOrder(abstraction, abstractComponentProperty.length);
                this.model[i2].addRateContext(abstraction, orders[i2], context);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numComponents) {
            abstractComponentProperty = abstractProperty[i2];
            abstraction = this.model[i2].getAbstraction();
            newModel[i2] = abstractComponentProperty.length == abstraction.size() ? this.model[i2].getAbstractCopy() : (isUpper ? this.model[i2].upperBound(context, orders[i2]) : this.model[i2].lowerBound(context, orders[i2]));
            ++i2;
        }
        return new KroneckerModel(this.numComponents, this.actionManager, newModel, this.propertyBank, this.displayModel);
    }

    public AbstractKroneckerModel getAbstractModel() {
        AbstractKroneckerComponent[] abstractModel = new AbstractKroneckerComponent[this.numComponents];
        double uniformisationConstant = 0.0;
        int i = 0;
        while (i < this.numComponents) {
            abstractModel[i] = this.model[i].abstractComponent();
            uniformisationConstant += this.model[i].getMaximumRate();
            ++i;
        }
        return new AbstractKroneckerModel(this.numComponents, this.actionManager, abstractModel, uniformisationConstant);
    }

    public void normaliseRateMatrices() {
        int i = 0;
        while (i < this.numComponents) {
            this.model[i].normaliseRateMatrices();
            ++i;
        }
    }

    public void addTransition(InternalAction action, int component, short state1, short state2, double rate) throws DerivationException {
        this.model[component].addTransition(action, state1, state2, rate);
        this.displayModel.getComponent(component).addTransition(action.getID(), state1, state2, rate);
    }

    public KroneckerDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public int numSyncActions() {
        return this.actionManager.getNumSyncActions();
    }

    public int numComponents() {
        return this.numComponents;
    }

    public ArrayList<Transition> getTransitionsFrom(short[] state) throws DerivationException {
        short[] nextState;
        int j;
        assert (state.length == this.numComponents);
        ArrayList<Transition> transitions = new ArrayList<Transition>(10);
        int action = 0;
        while (action < this.numSyncActions()) {
            double apparent = this.model[0].getSyncRate(action, state[0]);
            int totalStates = 1;
            int[] numStates = new int[this.numComponents];
            short[][] nextStates = new short[this.numComponents][];
            double[][] nextProb = new double[this.numComponents][];
            int i = 0;
            while (i < this.numComponents) {
                short currentState = state[i];
                KroneckerComponent component = this.model[i];
                apparent = KroneckerUtilities.rateMin(apparent, component.getSyncRate(action, currentState));
                StateDistribution next = component.nextSyncStates(action, currentState);
                nextStates[i] = next.getStates();
                nextProb[i] = next.getProbabilities();
                numStates[i] = nextStates[i].length;
                totalStates *= nextStates[i].length;
                ++i;
            }
            if (!(apparent <= 0.0)) {
                assert (totalStates == 0 || apparent > 0.0);
                int[] currentState = new int[this.numComponents];
                j = 0;
                while (j < totalStates) {
                    nextState = new short[this.numComponents];
                    double prob = 1.0;
                    int k = 0;
                    while (k < this.numComponents) {
                        nextState[k] = nextStates[k][currentState[k]];
                        prob *= nextProb[k][currentState[k]];
                        ++k;
                    }
                    Transition t = new Transition();
                    t.fActionId = (short)action;
                    t.fRate = apparent * prob;
                    t.fTargetProcess = nextState;
                    transitions.add(t);
                    KroneckerUtilities.incrementArray(currentState, numStates);
                    ++j;
                }
            }
            ++action;
        }
        this.fixApparentRates(state, transitions);
        int i = 0;
        while (i < this.numComponents) {
            short currentState = state[i];
            KroneckerComponent component = this.model[i];
            StateDistribution next = component.nextLocalStates(currentState);
            short[] nextStates = next.getStates();
            double[] nextProb = next.getProbabilities();
            double rate = component.getLocalRate(currentState);
            if (!(rate <= 0.0)) {
                j = 0;
                while (j < nextStates.length) {
                    if (nextStates[j] != currentState) {
                        nextState = new short[this.numComponents];
                        int k = 0;
                        while (k < nextState.length) {
                            nextState[k] = k == i ? nextStates[j] : state[k];
                            ++k;
                        }
                        Transition t = new Transition();
                        t.fActionId = (short)-1;
                        t.fTargetProcess = nextState;
                        t.fRate = rate * nextProb[j];
                        transitions.add(t);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return transitions;
    }

    private void fixApparentRates(short[] startState, ArrayList<Transition> transitions) throws DerivationException {
        for (Map.Entry<Short, ArrayList<Short>> actions2 : this.actionManager.getExternalActions()) {
            short externalID = actions2.getKey();
            ArrayList<Short> internalIDs = actions2.getValue();
            if (internalIDs.size() == 1) continue;
            double[] rates = new double[this.numComponents];
            int i = 0;
            while (i < this.numComponents) {
                rates[i] = -1.0;
                for (short internalID : internalIDs) {
                    if (this.model[i].isPassiveLoop(internalID)) continue;
                    rates[i] = Math.max(rates[i], this.model[i].getSyncRate(internalID, startState[i]));
                }
                ++i;
            }
            ApparentRateCalculator calculator = this.actionManager.getApparentRateCalculator(externalID);
            double apparentRate = calculator.compute(rates);
            double totalExitRate = 0.0;
            for (Transition t : transitions) {
                if (!internalIDs.contains(t.fActionId)) continue;
                totalExitRate += t.fRate;
            }
            if (totalExitRate == 0.0) continue;
            for (Transition t : transitions) {
                if (!internalIDs.contains(t.fActionId)) continue;
                t.fRate *= apparentRate;
                t.fRate /= totalExitRate;
            }
        }
    }

    public ArrayList<Transition> getTransitionsTo(short[] state) {
        short[] prevState;
        assert (state.length == this.numComponents);
        ArrayList<Transition> transitions = new ArrayList<Transition>(10);
        int action = 0;
        while (action < this.numSyncActions()) {
            int totalStates = 1;
            int[] numStates = new int[this.numComponents];
            short[][] prevStates = new short[this.numComponents][];
            double[][] prevProb = new double[this.numComponents][];
            int i = 0;
            while (i < this.numComponents) {
                short currentState = state[i];
                KroneckerComponent component = this.model[i];
                StateDistribution prev = component.prevSyncStates(action, currentState);
                prevStates[i] = prev.getStates();
                prevProb[i] = prev.getProbabilities();
                numStates[i] = prevStates[i].length;
                totalStates *= prevStates[i].length;
                ++i;
            }
            int[] currentState = new int[this.numComponents];
            int i2 = 0;
            while (i2 < totalStates) {
                prevState = new short[this.numComponents];
                double apparent = this.model[i2].getLocalRate(prevStates[0][currentState[0]]);
                double prob = 1.0;
                int k = 0;
                while (k < this.numComponents) {
                    prevState[k] = prevStates[k][currentState[k]];
                    apparent = KroneckerUtilities.rateMin(apparent, this.model[i2].getSyncRate(action, prevState[k]));
                    prob *= prevProb[k][currentState[k]];
                    ++k;
                }
                if (apparent > 0.0) {
                    Transition t = new Transition();
                    t.fActionId = (short)i2;
                    t.fRate = apparent * prob;
                    t.fTargetProcess = prevState;
                    transitions.add(t);
                }
                KroneckerUtilities.incrementArray(currentState, numStates);
                ++i2;
            }
            ++action;
        }
        int i = 0;
        while (i < this.numComponents) {
            short currentState = state[i];
            KroneckerComponent component = this.model[i];
            StateDistribution prev = component.prevLocalStates(currentState);
            short[] prevStates = prev.getStates();
            double[] prevProb = prev.getProbabilities();
            int j = 0;
            while (j < prevStates.length) {
                prevState = new short[this.numComponents];
                int k = 0;
                while (k < prevState.length) {
                    prevState[k] = k == i ? prevStates[j] : state[k];
                    ++k;
                }
                double rate = component.getLocalRate(prevStates[j]);
                if (rate > 0.0) {
                    Transition t = new Transition();
                    t.fActionId = (short)-1;
                    t.fTargetProcess = prevState;
                    t.fRate = rate * prevProb[j];
                    transitions.add(t);
                }
                ++j;
            }
            ++i;
        }
        return transitions;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.numComponents) {
            s = String.valueOf(s) + "Component " + i + ":\n";
            s = String.valueOf(s) + this.model[i].toString() + "\n";
            ++i;
        }
        return s;
    }
}

