/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

import java.util.ArrayList;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialOrder;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractRateMatrix;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.ActionTypes;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.StateDistribution;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.InternalAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.ComponentRateContext;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.RateContext;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds.StochasticBoundsRateWise;

public class RateMatrix {
    private SparseVector rateVector;
    private FlexCompRowMatrix probMatrix;
    private FlexCompRowMatrix revProbMatrix;
    private ActionTypes actions;
    private SequentialStateSpace stateSpace;
    private boolean isAbstracted;
    private boolean isEmpty = true;
    private int componentID;

    public RateMatrix(int componentID, SequentialStateSpace states) {
        this(componentID, states, false);
    }

    public RateMatrix(int componentID, SequentialStateSpace states, ActionTypes actions2, SparseVector rateVector, FlexCompRowMatrix probMatrix) {
        this(componentID, states, actions2, rateVector, probMatrix, false);
    }

    public RateMatrix(int componentID, SequentialStateSpace states, boolean isAbstracted) {
        if (!isAbstracted) {
            states.register(this);
        }
        this.componentID = componentID;
        this.stateSpace = states;
        this.isAbstracted = isAbstracted;
    }

    public RateMatrix(int componentID, SequentialStateSpace stateSpace, ActionTypes actions2, SparseVector rateVector, FlexCompRowMatrix probMatrix, boolean isAbstracted) {
        if (!isAbstracted) {
            stateSpace.register(this);
        }
        this.componentID = componentID;
        this.stateSpace = stateSpace;
        this.rateVector = rateVector;
        this.probMatrix = probMatrix;
        if (!isAbstracted) {
            this.revProbMatrix = (FlexCompRowMatrix)probMatrix.copy().transpose();
        }
        this.actions = actions2;
        this.isAbstracted = isAbstracted;
    }

    public RateMatrix(RateMatrix copy) {
        this.componentID = copy.componentID;
        this.stateSpace = copy.stateSpace;
        if (copy.isAbstracted) {
            this.stateSpace.register(this);
        }
        this.isEmpty = copy.isEmpty;
        this.rateVector = copy.rateVector.copy();
        this.probMatrix = (FlexCompRowMatrix)copy.probMatrix.copy();
        this.revProbMatrix = copy.revProbMatrix == null ? null : (FlexCompRowMatrix)copy.revProbMatrix.copy();
        this.actions = new ActionTypes(copy.actions);
        this.isAbstracted = copy.isAbstracted;
    }

    public void disableTransitions() {
        this.init();
    }

    private void init() {
        this.isEmpty = false;
        this.rateVector = new SparseVector(this.size());
        this.probMatrix = new FlexCompRowMatrix(this.size(), this.size());
        this.revProbMatrix = new FlexCompRowMatrix(this.size(), this.size());
        this.actions = new ActionTypes();
    }

    public double getMaximumRate() {
        if (this.isEmpty) {
            return 0.0;
        }
        double maxRate = 0.0;
        for (VectorEntry r : this.rateVector) {
            maxRate = Math.max(r.get(), maxRate);
        }
        return maxRate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addTransition(short state1, short state2, InternalAction action, double rate) throws DerivationException {
        if (this.isEmpty) {
            this.init();
        }
        int i1 = this.getIndex(state1);
        int i2 = this.getIndex(state2);
        assert (rate != 0.0);
        if (rate < 0.0) {
            if (this.rateVector.get(i1) < 0.0) {
                this.probMatrix.set(i1, i2, -rate);
            } else {
                if (this.rateVector.get(i1) != 0.0) throw new DerivationException("Active and passive transitions from the same state");
                this.rateVector.set(i1, -1.0);
                this.probMatrix.set(i1, i2, -rate);
            }
        } else if (this.rateVector.get(i1) > 0.0) {
            this.probMatrix.set(i1, i2, rate);
        } else {
            if (this.rateVector.get(i1) != 0.0) throw new DerivationException("Active and passive transitions from the same state");
            this.rateVector.set(i1, 1.0);
            this.probMatrix.set(i1, i2, rate);
        }
        this.actions.addActionType((AbstractMatrix)this.probMatrix, i1, i2, action);
    }

    public void normalise() {
        if (this.isEmpty) {
            return;
        }
        int i = 0;
        while (i < this.rateVector.size()) {
            double rate = this.rateVector.get(i);
            SparseVector nextState = this.probMatrix.getRow(i);
            double totalRate = 0.0;
            for (VectorEntry s : nextState) {
                totalRate += s.get();
            }
            if (totalRate != 0.0) {
                assert (rate != 0.0);
                for (VectorEntry s : nextState) {
                    double prob = s.get() / totalRate;
                    s.set(prob);
                    this.revProbMatrix.set(s.index(), i, prob);
                }
                this.rateVector.set(i, rate * totalRate);
            }
            ++i;
        }
    }

    private FlexCompRowMatrix getStochasticProbMatrix() {
        assert (!this.isEmpty);
        FlexCompRowMatrix stochasticProbMatrix = (FlexCompRowMatrix)this.probMatrix.copy();
        int i = 0;
        while (i < this.rateVector.size()) {
            double rate = this.rateVector.get(i);
            SparseVector nextState = stochasticProbMatrix.getRow(i);
            if (rate == 0.0) {
                nextState.zero();
                nextState.set(i, 1.0);
            }
            ++i;
        }
        return stochasticProbMatrix;
    }

    public StateDistribution nextStates(short state) {
        if (this.isEmpty) {
            return StateDistribution.getLoopDistribution(state);
        }
        SparseVector probDist = this.probMatrix.getRow(this.getIndex(state));
        if (this.getRate(state) == 0.0) {
            return new StateDistribution(0);
        }
        int numStates = probDist.getUsed();
        StateDistribution nextStates = new StateDistribution(numStates);
        for (VectorEntry v : probDist) {
            if (!(v.get() > 0.0)) continue;
            nextStates.addEntry(this.getState(v.index()), v.get());
        }
        return nextStates;
    }

    public StateDistribution prevStates(short state) {
        if (this.isEmpty) {
            return new StateDistribution(state);
        }
        SparseVector probDist = this.revProbMatrix.getRow(this.getIndex(state));
        int numStates = probDist.getUsed();
        StateDistribution prevStates = new StateDistribution(numStates);
        for (VectorEntry v : probDist) {
            if (!(v.get() > 0.0)) continue;
            prevStates.addEntry(this.getState(v.index()), v.get());
        }
        return prevStates;
    }

    public ArrayList<InternalAction> actionTypes(short state1, short state2) {
        int i1 = this.getIndex(state1);
        int i2 = this.getIndex(state2);
        return this.actions.getActionTypes(i1, i2);
    }

    public double getRate(short state) {
        if (this.isEmpty) {
            return -1.0;
        }
        return this.rateVector.get(this.getIndex(state));
    }

    public void notifySwap(int index1, int index2) {
        if (this.isEmpty) {
            return;
        }
        double rate1 = this.rateVector.get(index1);
        double rate2 = this.rateVector.get(index2);
        this.rateVector.set(index1, rate2);
        this.rateVector.set(index2, rate1);
        SparseVector row1 = this.probMatrix.getRow(index1);
        SparseVector row2 = this.probMatrix.getRow(index2);
        this.probMatrix.setRow(index1, row2);
        this.probMatrix.setRow(index2, row1);
        int i = 0;
        while (i < this.size()) {
            double prob1 = this.probMatrix.get(i, index1);
            double prob2 = this.probMatrix.get(i, index2);
            this.probMatrix.set(i, index1, prob2);
            this.probMatrix.set(i, index2, prob1);
            ++i;
        }
        SparseVector rev_row1 = this.revProbMatrix.getRow(index1);
        SparseVector rev_row2 = this.revProbMatrix.getRow(index2);
        this.revProbMatrix.setRow(index1, rev_row2);
        this.revProbMatrix.setRow(index2, rev_row1);
        int i2 = 0;
        while (i2 < this.size()) {
            double prob1 = this.revProbMatrix.get(i2, index1);
            double prob2 = this.revProbMatrix.get(i2, index2);
            this.revProbMatrix.set(i2, index1, prob2);
            this.revProbMatrix.set(i2, index2, prob1);
            ++i2;
        }
        this.actions.notifySwap(index1, index2);
    }

    private void doLumping(SequentialAbstraction abstraction, LumperCallBack callBack) {
        AbstractState[] abstractStates = abstraction.getAbstractStateSpace();
        int k = 0;
        while (k < abstractStates.length) {
            AbstractState abstractState1 = abstractStates[k];
            short[] states1 = abstractState1.getConcrete();
            int i = 0;
            while (i < states1.length) {
                int index = this.getConcreteIndex(states1[i]);
                callBack.notifyRate(abstractState1.getID(), this.rateVector.get(index));
                ++i;
            }
            int l = 0;
            while (l < abstractStates.length) {
                AbstractState abstractState2 = abstractStates[l];
                short[] states2 = abstractState2.getConcrete();
                int i2 = 0;
                while (i2 < states1.length) {
                    double prob = 0.0;
                    int j = 0;
                    while (j < states2.length) {
                        prob += this.probMatrix.get(this.getConcreteIndex(states1[i2]), this.getConcreteIndex(states2[j]));
                        ++j;
                    }
                    callBack.notifyProbability(abstractState1.getID(), abstractState2.getID(), prob);
                    ++i2;
                }
                ++l;
            }
            ++k;
        }
    }

    public RateMatrix getLumpedMatrix(SequentialAbstraction abstraction) {
        if (this.isEmpty) {
            return new RateMatrix(this.componentID, this.stateSpace, true);
        }
        int size = abstraction.size();
        final SparseVector lumpedRates = new SparseVector(size);
        final FlexCompRowMatrix lumpedProbMatrix = new FlexCompRowMatrix(size, size);
        LumperCallBack callBack = new LumperCallBack(){

            @Override
            public void notifyProbability(int index1, int index2, double probability) {
                if (lumpedProbMatrix.get(index1, index2) != 0.0 && !$assertionsDisabled && lumpedProbMatrix.get(index1, index2) != probability) {
                    throw new AssertionError();
                }
                lumpedProbMatrix.set(index1, index2, probability);
            }

            @Override
            public void notifyRate(int index, double rate) {
                if (lumpedRates.get(index) != 0.0 && !$assertionsDisabled && lumpedRates.get(index) != rate) {
                    throw new AssertionError();
                }
                lumpedRates.set(index, rate);
            }
        };
        this.doLumping(abstraction, callBack);
        RateMatrix lumpedMatrix = new RateMatrix(this.componentID, this.stateSpace, this.actions, lumpedRates, lumpedProbMatrix, true);
        lumpedMatrix.isEmpty = false;
        return lumpedMatrix;
    }

    public boolean isLumpable(SequentialAbstraction abstraction) {
        if (this.isEmpty) {
            return true;
        }
        LumperCallBack callBack = new LumperCallBack(){
            private int current_index;
            private int current_index1;
            private int current_index2;
            private double current_prob;
            private double current_rate;
            private boolean isLumpable;
            {
                this.current_index = -1;
                this.current_index1 = -1;
                this.current_index2 = -1;
                this.current_prob = 0.0;
                this.current_rate = 0.0;
                this.isLumpable = true;
            }

            @Override
            public void notifyProbability(int index1, int index2, double probability) {
                if (this.current_index1 == index1 && this.current_index2 == index2) {
                    if (this.current_prob != probability) {
                        this.isLumpable = false;
                    }
                } else {
                    this.current_prob = probability;
                }
            }

            @Override
            public void notifyRate(int index, double rate) {
                if (this.current_index == index) {
                    if (this.current_rate != rate) {
                        this.isLumpable = false;
                    }
                } else {
                    this.current_rate = rate;
                }
            }

            @Override
            public boolean isLumpable() {
                return this.isLumpable;
            }
        };
        this.doLumping(abstraction, callBack);
        return callBack.isLumpable();
    }

    public AbstractRateMatrix getAbstractMatrix(SequentialAbstraction abstraction) {
        if (this.isEmpty) {
            return new AbstractRateMatrix(abstraction);
        }
        int size = abstraction.size();
        final SparseVector lowerRates = new SparseVector(size);
        final SparseVector upperRates = new SparseVector(size);
        final SparseVector enabledRates = new SparseVector(size);
        final FlexCompRowMatrix lowerProbMatrix = new FlexCompRowMatrix(size, size);
        final FlexCompRowMatrix upperProbMatrix = new FlexCompRowMatrix(size, size);
        final FlexCompRowMatrix enabledTransitions = new FlexCompRowMatrix(size, size);
        LumperCallBack callBack = new LumperCallBack(){

            @Override
            public void notifyProbability(int index1, int index2, double probability) {
                if (enabledTransitions.get(index1, index2) == 0.0) {
                    lowerProbMatrix.set(index1, index2, probability);
                    upperProbMatrix.set(index1, index2, probability);
                    enabledTransitions.set(index1, index2, 1.0);
                } else {
                    double old_lower = lowerProbMatrix.get(index1, index2);
                    lowerProbMatrix.set(index1, index2, Math.min(old_lower, probability));
                    double old_upper = upperProbMatrix.get(index1, index2);
                    upperProbMatrix.set(index1, index2, Math.max(old_upper, probability));
                }
            }

            @Override
            public void notifyRate(int index, double rate) {
                if (enabledRates.get(index) == 0.0) {
                    lowerRates.set(index, rate);
                    upperRates.set(index, rate);
                    enabledRates.set(index, 1.0);
                } else {
                    double old_lower = lowerRates.get(index);
                    if (old_lower < 0.0 || rate < 0.0) {
                        lowerRates.set(index, Math.max(old_lower, rate));
                    } else {
                        lowerRates.set(index, Math.min(old_lower, rate));
                    }
                    double old_upper = upperRates.get(index);
                    if (old_upper < 0.0 || rate < 0.0) {
                        upperRates.set(index, Math.min(old_upper, rate));
                    } else {
                        upperRates.set(index, Math.max(old_upper, rate));
                    }
                }
            }
        };
        this.doLumping(abstraction, callBack);
        return new AbstractRateMatrix(abstraction, lowerRates, upperRates, lowerProbMatrix, upperProbMatrix);
    }

    public void addRateContext(SequentialAbstraction abstraction, SequentialOrder order, RateContext context) {
        if (this.isEmpty) {
            context.addEmptyComponent(this.componentID, this.actions);
        } else {
            context.addComponent(this.componentID, this.rateVector, this.actions, abstraction, order);
        }
    }

    public void addEmptyRateContext(RateContext context) {
        context.addEmptyComponent(this.componentID, this.actions);
    }

    public RateMatrix getAbstractCopy() {
        return new RateMatrix(this.componentID, this.stateSpace, true);
    }

    public RateMatrix upperBound(SequentialAbstraction abstraction, ComponentRateContext context, SequentialOrder order) {
        if (this.isEmpty) {
            return new RateMatrix(this.componentID, this.stateSpace, true);
        }
        FlexCompRowMatrix upperProb = StochasticBoundsRateWise.upperBoundMatrix((AbstractMatrix)this.getStochasticProbMatrix(), abstraction, context, order);
        RateMatrix upperBound = new RateMatrix(this.componentID, this.stateSpace, this.actions, context.getUpperRateVector(), upperProb, true);
        upperBound.isEmpty = false;
        return upperBound;
    }

    public RateMatrix lowerBound(SequentialAbstraction abstraction, ComponentRateContext context, SequentialOrder order) {
        if (this.isEmpty) {
            return new RateMatrix(this.componentID, this.stateSpace, true);
        }
        FlexCompRowMatrix lowerProb = StochasticBoundsRateWise.lowerBoundMatrix((AbstractMatrix)this.getStochasticProbMatrix(), abstraction, context, order);
        RateMatrix lowerBound = new RateMatrix(this.componentID, this.stateSpace, this.actions, context.getLowerRateVector(), lowerProb, true);
        lowerBound.isEmpty = false;
        return lowerBound;
    }

    private boolean containsPassive() {
        if (this.isEmpty) {
            return true;
        }
        int i = 0;
        while (i < this.size()) {
            if (this.rateVector.get(i) < 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RateMatrix uniformiseRates() {
        if (this.isEmpty) {
            return new RateMatrix(this.componentID, this.stateSpace, false);
        }
        double max_rate = this.getMaximumRate();
        assert (!this.containsPassive());
        if (max_rate > 0.0) {
            FlexCompRowMatrix newProbMatrix = new FlexCompRowMatrix(this.size(), this.size());
            SparseVector newRateVector = new SparseVector(this.size());
            int i = 0;
            while (i < this.size()) {
                double old_rate = this.rateVector.get(i);
                assert (old_rate >= 0.0);
                newRateVector.set(i, max_rate);
                double rate_sum = 0.0;
                int j = 0;
                while (j < this.size()) {
                    double old_prob;
                    if (j != i && (old_prob = this.probMatrix.get(i, j)) > 0.0) {
                        double rate = old_prob * old_rate;
                        rate_sum += rate;
                        newProbMatrix.set(i, j, rate / max_rate);
                    }
                    ++j;
                }
                newProbMatrix.set(i, i, 1.0 - rate_sum / max_rate);
                ++i;
            }
            RateMatrix newMatrix = new RateMatrix(this.componentID, this.stateSpace, this.actions, newRateVector, newProbMatrix, false);
            newMatrix.isEmpty = false;
            return newMatrix;
        }
        if (max_rate == 0.0) {
            return new RateMatrix(this.componentID, this.stateSpace, false);
        }
        assert (false);
        return null;
    }

    public int size() {
        return this.stateSpace.size();
    }

    private int getConcreteIndex(short state) {
        return this.stateSpace.getIndex(state);
    }

    private int getIndex(short state) {
        if (this.isAbstracted) {
            return state;
        }
        return this.stateSpace.getIndex(state);
    }

    private short getState(int index) {
        if (this.isAbstracted) {
            return (short)index;
        }
        return this.stateSpace.getState(index);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public String toString() {
        String s = "================================\n";
        s = String.valueOf(s) + "Rates:\n" + this.rateVector;
        s = String.valueOf(s) + "Probability Matrix:\n" + this.probMatrix + "\n";
        s = String.valueOf(s) + "================================\n";
        return s;
    }

    private static abstract class LumperCallBack {
        private LumperCallBack() {
        }

        public abstract void notifyRate(int var1, double var2);

        public abstract void notifyProbability(int var1, int var2, double var3);

        public boolean isLumpable() {
            return false;
        }
    }
}

