/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal;

public class StateDistribution {
    private short[] states;
    private double[] probabilities;
    private int numUsed;

    public StateDistribution(int numStates) {
        this.states = new short[numStates];
        this.probabilities = new double[numStates];
        this.numUsed = 0;
    }

    public static StateDistribution getLoopDistribution(short loopState) {
        StateDistribution loop = new StateDistribution(1);
        loop.addEntry(loopState, 1.0);
        return loop;
    }

    public void addEntry(short state, double probability) {
        int index = this.numUsed++;
        this.states[index] = state;
        this.probabilities[index] = probability;
    }

    public short[] getStates() {
        if (this.states.length > this.numUsed) {
            short[] newStates = new short[this.numUsed];
            System.arraycopy(this.states, 0, newStates, 0, this.numUsed);
            this.states = newStates;
        }
        return this.states;
    }

    public double[] getProbabilities() {
        if (this.probabilities.length > this.numUsed) {
            double[] newProbabilities = new double[this.numUsed];
            System.arraycopy(this.probabilities, 0, newProbabilities, 0, this.numUsed);
            this.probabilities = newProbabilities;
        }
        return this.probabilities;
    }

    public int size() {
        return this.states.length;
    }
}

