/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions;

import java.util.Arrays;

public class InternalAction {
    private short actionID;
    private boolean[] syncComponents;
    private boolean isLocal;

    public InternalAction(short actionID, int component, int numComponents) {
        this.actionID = actionID;
        this.syncComponents = new boolean[numComponents];
        this.syncComponents[component] = true;
        this.isLocal = true;
    }

    public InternalAction(InternalAction action1, InternalAction action2) {
        int numComponents = action1.syncComponents.length;
        assert (action2.syncComponents.length == numComponents);
        assert (action1.actionID == action2.actionID);
        this.actionID = action1.actionID;
        this.syncComponents = new boolean[numComponents];
        int i = 0;
        while (i < numComponents) {
            this.syncComponents[i] = action1.syncComponents[i] || action2.syncComponents[i];
            ++i;
        }
        this.isLocal = false;
    }

    public boolean[] getSyncComponents() {
        return this.syncComponents;
    }

    public short getID() {
        return this.actionID;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean equals(Object o) {
        if (o instanceof InternalAction) {
            InternalAction action = (InternalAction)o;
            return this.actionID == action.actionID && Arrays.equals(this.syncComponents, action.syncComponents);
        }
        return false;
    }

    public int hashCode() {
        return this.actionID + Arrays.hashCode(this.syncComponents);
    }

    public String toString() {
        return Arrays.toString(this.syncComponents);
    }
}

