/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions;

import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.actions.SystemComponentInfo;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.DefaultVisitor;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class KroneckerSystemEquationVisitor
extends DefaultVisitor {
    private SystemComponentInfo componentInfo;
    private boolean canMakeKronecker = true;

    public KroneckerSystemEquationVisitor(SystemComponentInfo componentInfo) {
        this.componentInfo = componentInfo;
    }

    @Override
    public void visitConstantProcessNode(ConstantProcessNode constant) {
        this.componentInfo.addProcess(constant);
    }

    @Override
    public void visitHidingNode(HidingNode hiding) {
        this.canMakeKronecker = false;
    }

    @Override
    public void visitAggregationNode(AggregationNode aggregation) {
        this.canMakeKronecker = false;
    }

    @Override
    public void visitActionTypeNode(ActionTypeNode actionType) {
    }

    @Override
    public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
        this.canMakeKronecker = false;
    }

    @Override
    public void visitCooperationNode(CooperationNode cooperation) {
        cooperation.getLeft().accept(this);
        cooperation.getRight().accept(this);
        if (!this.canMakeKronecker) {
            return;
        }
        this.componentInfo.addCooperation(cooperation);
    }

    @Override
    public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
        cooperation.getLeft().accept(this);
        cooperation.getRight().accept(this);
        if (!this.canMakeKronecker) {
            return;
        }
        this.componentInfo.addCooperation(cooperation);
    }

    public boolean canMakeKronecker() {
        return this.canMakeKronecker;
    }
}

