/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.kronecker.internal.stochasticbounds;

import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import uk.ac.ed.inf.pepa.ctmc.abstraction.AbstractState;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;

public class StochasticBounds {
    private static final double EPSILON = 1.0E-4;

    private static double matrix_sum(AbstractMatrix M, int row, int start_col, int end_col) {
        double sum = 0.0;
        int j = start_col;
        while (j <= end_col) {
            sum += M.get(row, j);
            ++j;
        }
        return sum;
    }

    private static double upper_bound(AbstractMatrix P, AbstractMatrix R, int i, int j) {
        int n = R.numRows() - 1;
        double prev_sum = StochasticBounds.matrix_sum(R, i - 1, j, n);
        double old_sum = StochasticBounds.matrix_sum(P, i, j, n);
        return Math.max(prev_sum, old_sum);
    }

    private static double lower_bound(AbstractMatrix P, AbstractMatrix R, int i, int j) {
        int n = R.numRows() - 1;
        double next_sum = StochasticBounds.matrix_sum(R, i + 1, j, n);
        double old_sum = StochasticBounds.matrix_sum(P, i, j, n);
        return Math.min(next_sum, old_sum);
    }

    private static void refresh_sum_upper(AbstractMatrix P, AbstractMatrix R, int column) {
        int n = R.numRows();
        int i = 1;
        while (i < n) {
            double current_sum = StochasticBounds.matrix_sum(R, i, column + 1, n);
            double new_prob = Math.max(0.0, StochasticBounds.upper_bound(P, R, i, column) - current_sum);
            if (new_prob == 0.0 && current_sum < 1.0 && (P.get(i, column) > 0.0 || i == column - 1)) {
                new_prob = 1.0E-4 * (1.0 - current_sum);
            }
            R.set(i, column, new_prob);
            ++i;
        }
    }

    private static void refresh_sum_lower(AbstractMatrix P, AbstractMatrix R, int column) {
        int n;
        int i = n = R.numRows();
        while (i >= 0) {
            double current_sum = StochasticBounds.matrix_sum(R, i, column + 1, n);
            double new_prob = Math.max(0.0, StochasticBounds.lower_bound(P, R, i, column) - current_sum);
            if (new_prob == 0.0 && current_sum < 1.0 && (P.get(i, column) > 0.0 || i == column - 1)) {
                new_prob = 1.0E-4 * (1.0 - current_sum);
            }
            R.set(i, column, new_prob);
            --i;
        }
    }

    private static void normalise(AbstractMatrix R, int current_start, int current_end, AbstractState[] partitions) {
        int end_state = 0;
        int y = 0;
        while (y < partitions.length) {
            int start_state = end_state + 1;
            double max_assigned = StochasticBounds.matrix_sum(R, (end_state += partitions[y].size()) - 1, current_start, current_end);
            int i = start_state;
            while (i < end_state - 1) {
                double current_assigned = StochasticBounds.matrix_sum(R, i, current_start + 1, current_end);
                R.set(i, current_start, max_assigned - current_assigned);
                ++i;
            }
            ++y;
        }
    }

    private static DenseMatrix computeUpperBound(AbstractMatrix P, SequentialAbstraction abstraction) {
        assert (P.numColumns() == P.numRows());
        int n = P.numColumns();
        DenseMatrix R = new DenseMatrix(n, n);
        int j = 0;
        while (j < n) {
            R.set(1, j, P.get(1, j));
            ++j;
        }
        int i = 1;
        while (i < n) {
            double new_prob = Math.max(R.get(i - 1, n - 1), P.get(i, n - 1));
            R.set(i, n - 1, new_prob);
            ++i;
        }
        AbstractState[] partitions = abstraction.getAbstractStateSpace();
        int start_state = n;
        int k = partitions.length - 1;
        while (k >= 0) {
            int end_state = start_state;
            start_state -= partitions[k].size();
            int j2 = end_state - 1;
            while (j2 >= start_state) {
                StochasticBounds.refresh_sum_upper(P, (AbstractMatrix)R, j2);
                --j2;
            }
            StochasticBounds.normalise((AbstractMatrix)R, start_state, end_state - 1, partitions);
            --k;
        }
        return R;
    }

    private static DenseMatrix computeLowerBound(AbstractMatrix P, SequentialAbstraction abstraction) {
        assert (P.numColumns() == P.numRows());
        int n = P.numColumns();
        DenseMatrix R = new DenseMatrix(n, n);
        int j = 0;
        while (j < n) {
            R.set(1, j, P.get(1, j));
            ++j;
        }
        int i = 1;
        while (i < n) {
            double new_prob = Math.min(R.get(i - 1, n - 1), P.get(i, n - 1));
            R.set(i, n - 1, new_prob);
            ++i;
        }
        AbstractState[] partitions = abstraction.getAbstractStateSpace();
        int start_state = n;
        int k = partitions.length - 1;
        while (k >= 0) {
            int end_state = start_state;
            start_state -= partitions[k].size();
            int j2 = end_state - 1;
            while (j2 >= start_state) {
                StochasticBounds.refresh_sum_lower(P, (AbstractMatrix)R, j2);
                --j2;
            }
            StochasticBounds.normalise((AbstractMatrix)R, start_state, end_state - 1, partitions);
            --k;
        }
        return R;
    }

    public static DenseMatrix upperBoundMatrix(AbstractMatrix P, SequentialAbstraction abstraction) {
        return StochasticBounds.computeUpperBound(P, abstraction);
    }

    public static DenseMatrix lowerBoundMatrix(AbstractMatrix P, SequentialAbstraction abstraction) {
        return StochasticBounds.computeLowerBound(P, abstraction);
    }
}

