/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAtomicNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;

public abstract class CSLAbstractProperty {
    public boolean isSimple() {
        return true;
    }

    public boolean isProbabilityTest() {
        return false;
    }

    public StringPosition objectAt(int index) {
        StringPosition[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            StringPosition child = children[i];
            if (child.getStart() <= index && index <= child.getEnd()) {
                int start = child.getStart();
                return child.getObject().objectAt(index - start).addOffset(start);
            }
            ++i;
        }
        return new StringPosition(0, this.toString().length(), this);
    }

    public StringPosition indexOf(CSLAbstractProperty property) {
        if (this == property) {
            return new StringPosition(0, this.toString().length(), this);
        }
        StringPosition[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            StringPosition position = children[i].getObject().indexOf(property);
            if (position != null) {
                return position.addOffset(children[i].getStart());
            }
            ++i;
        }
        return null;
    }

    public void getAtomicNodes(ArrayList<CSLAtomicNode> atomicNodes) {
        if (this instanceof CSLAtomicNode) {
            atomicNodes.add((CSLAtomicNode)this);
        } else {
            StringPosition[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].getObject().getAtomicNodes(atomicNodes);
                ++i;
            }
        }
    }

    public abstract boolean containsPlaceHolder();

    public abstract CSLAbstractProperty replace(CSLAbstractProperty var1, CSLAbstractProperty var2);

    public abstract CSLAbstractProperty copy();

    public StringPosition[] getChildren() {
        StringPosition[] children = new StringPosition[]{};
        return children;
    }
}

