/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking;

import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLDouble;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;

public class CSLTimeInterval
extends CSLAbstractProperty {
    private CSLDouble startTime;
    private CSLDouble endTime;
    private boolean isStartBounded;
    private boolean isEndBounded;

    public CSLTimeInterval(CSLDouble startTime, CSLDouble endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.isStartBounded = true;
        this.isEndBounded = true;
    }

    public CSLTimeInterval(CSLDouble time, boolean isStartBound) {
        if (isStartBound) {
            this.startTime = time;
            this.isStartBounded = true;
            this.isEndBounded = false;
        } else {
            this.endTime = time;
            this.isStartBounded = false;
            this.isEndBounded = true;
        }
    }

    public CSLTimeInterval() {
        this.isStartBounded = false;
        this.isEndBounded = false;
    }

    public boolean isStartBounded() {
        return this.isStartBounded;
    }

    public boolean isEndBounded() {
        return this.isEndBounded;
    }

    public CSLDouble getStartTime() {
        return this.startTime;
    }

    public CSLDouble getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean containsPlaceHolder() {
        return false;
    }

    public String toString() {
        if (this.isStartBounded && this.isEndBounded) {
            return "[" + this.startTime.toString() + "," + this.endTime.toString() + "]";
        }
        if (this.isStartBounded) {
            return "[" + this.startTime.toString() + ",-]";
        }
        if (this.isEndBounded) {
            return "[-," + this.endTime.toString() + "]";
        }
        return "";
    }

    @Override
    public CSLTimeInterval copy() {
        CSLTimeInterval newInterval = new CSLTimeInterval(this.startTime, this.endTime);
        newInterval.isEndBounded = this.isEndBounded;
        newInterval.isStartBounded = this.isStartBounded;
        return newInterval;
    }

    @Override
    public StringPosition[] getChildren() {
        if (this.isStartBounded && this.isEndBounded) {
            int start1 = 1;
            int end1 = start1 + this.startTime.toString().length();
            StringPosition position1 = new StringPosition(start1, end1, this.startTime);
            int start2 = end1 + 1;
            int end2 = start2 + this.endTime.toString().length();
            StringPosition position2 = new StringPosition(start2, end2, this.endTime);
            return new StringPosition[]{position1, position2};
        }
        if (this.isStartBounded) {
            int start = 1;
            int end = start + this.startTime.toString().length();
            StringPosition position = new StringPosition(start, end, this.startTime);
            return new StringPosition[]{position};
        }
        if (this.isEndBounded) {
            int start = 3;
            int end = start + this.endTime.toString().length();
            StringPosition position = new StringPosition(start, end, this.endTime);
            return new StringPosition[]{position};
        }
        return new StringPosition[0];
    }

    @Override
    public CSLTimeInterval replace(CSLAbstractProperty object1, CSLAbstractProperty object2) {
        if (object1 == this && object2 instanceof CSLTimeInterval) {
            return (CSLTimeInterval)object2;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof CSLTimeInterval) {
            boolean sameBounds;
            CSLTimeInterval node = (CSLTimeInterval)o;
            boolean bl = sameBounds = this.isStartBounded == node.isStartBounded && this.isEndBounded == node.isEndBounded;
            if (this.isStartBounded) {
                boolean bl2 = sameBounds = sameBounds && this.startTime.equals(node.startTime);
            }
            if (this.isEndBounded) {
                sameBounds = sameBounds && this.endTime.equals(node.endTime);
            }
            return sameBounds;
        }
        return false;
    }

    public int hashCode() {
        return (this.isStartBounded ? 1 + this.startTime.hashCode() : 0) + (this.isEndBounded ? 1 + this.endTime.hashCode() : 0) + 9;
    }
}

