/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.AbstractKroneckerModel;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCTransition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLPropertyManager;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ModelCheckingLog;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PropertyBank;

public class AbstractCTMC
implements Iterable<AbstractCTMCState> {
    private AbstractKroneckerModel model;
    private ArrayList<AbstractCTMCState> states;
    private HashMap<AbstractCTMCState, AbstractCTMCState> stateSpace;
    private boolean isGenerated = false;
    private DerivationException generationError = null;
    private AbstractCTMCState initialState;
    private CSLPropertyManager propertyManager;
    private ModelCheckingLog eventLog;
    private double uniformisationConstant;

    public AbstractCTMC(short[] initialState, AbstractKroneckerModel model, PropertyBank propertyBank, ModelCheckingLog eventLog) {
        this.model = model;
        this.initialState = new AbstractCTMCState(initialState);
        this.propertyManager = new CSLPropertyManager(propertyBank, model.getAbstractStateSpace());
        this.uniformisationConstant = model.getUniformisationConstant();
        this.eventLog = eventLog;
    }

    public CSLPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public double getUniformisationConstant() {
        return this.uniformisationConstant;
    }

    private void optimiseUniformisationConstant() {
        this.model.optimiseUniformisationConstant();
        this.uniformisationConstant = this.model.getUniformisationConstant();
    }

    private AbstractCTMCState addState(AbstractCTMCState state) {
        if (!this.stateSpace.containsKey(state)) {
            this.stateSpace.put(state, state);
            this.states.add(state);
            return null;
        }
        return this.stateSpace.get(state);
    }

    private void initStateSpace() {
        this.states = new ArrayList(1000);
        this.stateSpace = new HashMap(1000);
        this.initialState = new AbstractCTMCState(this.initialState);
        this.isGenerated = false;
    }

    private void generateStateSpace() {
        try {
            this.eventLog.addEntry("Generating abstract CTMC... ");
            this.internalGenerateStateSpace();
            this.optimiseUniformisationConstant();
            this.eventLog.addEntry("Optimising uniformisation constant to " + this.getUniformisationConstant() + "...");
            this.internalGenerateStateSpace();
            this.eventLog.addEntry("Generated abstract CTMC with " + this.stateSpace.size() + " states.");
        }
        catch (DerivationException e) {
            this.eventLog.addEntry("Error while generating abstract CTMC: mixing active and passive activities.");
            this.isGenerated = false;
            this.generationError = e;
        }
    }

    private void internalGenerateStateSpace() throws DerivationException {
        this.initStateSpace();
        AbstractCTMCState state = this.initialState;
        this.addState(state);
        LinkedList<AbstractCTMCState> queue = new LinkedList<AbstractCTMCState>();
        queue.add(state);
        while (!queue.isEmpty()) {
            state = (AbstractCTMCState)queue.remove();
            this.propertyManager.labelAtomicProperties(state);
            ArrayList<AbstractCTMCTransition> found = this.model.getTransitionsFrom(state);
            HashMap<AbstractCTMCState, AbstractCTMCTransition> toStates = new HashMap<AbstractCTMCState, AbstractCTMCTransition>(10);
            for (AbstractCTMCTransition t : found) {
                AbstractCTMCState toState = t.getToState();
                if (toStates.containsKey(toState)) {
                    AbstractCTMCTransition existing_t = (AbstractCTMCTransition)toStates.get(toState);
                    existing_t.addProbability(t.getMinProb(), t.getMaxProb());
                    continue;
                }
                toStates.put(toState, t);
            }
            found = new ArrayList(toStates.values());
            for (AbstractCTMCTransition t : found) {
                t.delimit(found);
            }
            for (AbstractCTMCTransition t : found) {
                AbstractCTMCState foundState = t.getToState();
                AbstractCTMCState existingState = this.addState(foundState);
                if (existingState == null) {
                    queue.add(foundState);
                } else {
                    t.setToState(existingState);
                }
                state.addTransition(t);
            }
        }
        this.isGenerated = true;
    }

    @Override
    public Iterator<AbstractCTMCState> iterator() {
        if (!this.isGenerated && this.generationError == null) {
            this.generateStateSpace();
        }
        if (this.generationError != null) {
            return null;
        }
        return this.states.iterator();
    }

    public AbstractCTMCState getInitialState() {
        return this.initialState;
    }

    public int size() {
        if (!this.isGenerated && this.generationError != null) {
            this.generateStateSpace();
        }
        if (this.generationError != null) {
            return 0;
        }
        return this.states.size();
    }

    public String toString() {
        if (!this.isGenerated && this.generationError != null) {
            this.generateStateSpace();
        }
        if (this.generationError != null) {
            return "";
        }
        String actmcString = "";
        for (AbstractCTMCState state : this.states) {
            actmcString = String.valueOf(actmcString) + state.toStringFull() + "\n";
        }
        return actmcString;
    }
}

