/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCTransition;

public class AbstractCTMCState {
    private int hashCode;
    private short[] state;
    private int propertyTrue;
    private int propertyFalse;
    private double minProbability;
    private double maxProbability;
    private double cache;
    private ArrayList<AbstractCTMCTransition> transitions;

    public AbstractCTMCState(short[] state) {
        this.state = state;
        this.transitions = new ArrayList(10);
        this.hashCode = Arrays.hashCode(state);
    }

    public AbstractCTMCState(AbstractCTMCState state) {
        this(state.state);
    }

    public void addTransition(AbstractCTMCState nextState, double minRate, double maxRate) {
        if (minRate < 0.0 || maxRate <= 0.0) {
            return;
        }
        AbstractCTMCTransition transition = new AbstractCTMCTransition(this, nextState, minRate, maxRate);
        this.transitions.add(transition);
    }

    public void addTransition(AbstractCTMCTransition transition) {
        if (transition.getMinProb() < 0.0 || transition.getMaxProb() <= 0.0) {
            return;
        }
        this.transitions.add(transition);
    }

    public ArrayList<AbstractCTMCTransition> getTransitions() {
        return this.transitions;
    }

    public ArrayList<AbstractCTMCTransition> getSortedTransitions(boolean minimise, boolean use_cache) {
        if (minimise) {
            return this.getSortedTransitionsMin(use_cache);
        }
        return this.getSortedTransitionsMax(use_cache);
    }

    private ArrayList<AbstractCTMCTransition> getSortedTransitionsMax(final boolean use_cache) {
        ArrayList<AbstractCTMCTransition> transitionsToSort = new ArrayList<AbstractCTMCTransition>(this.transitions);
        Collections.sort(transitionsToSort, new Comparator<AbstractCTMCTransition>(){

            @Override
            public int compare(AbstractCTMCTransition t1, AbstractCTMCTransition t2) {
                if (use_cache) {
                    return Double.compare(t2.getToState().cache, t1.getToState().cache);
                }
                return Double.compare(t2.getToState().maxProbability, t1.getToState().maxProbability);
            }
        });
        return transitionsToSort;
    }

    private ArrayList<AbstractCTMCTransition> getSortedTransitionsMin(final boolean use_cache) {
        ArrayList<AbstractCTMCTransition> transitionsToSort = new ArrayList<AbstractCTMCTransition>(this.transitions);
        Collections.sort(transitionsToSort, new Comparator<AbstractCTMCTransition>(){

            @Override
            public int compare(AbstractCTMCTransition t1, AbstractCTMCTransition t2) {
                if (use_cache) {
                    return Double.compare(t1.getToState().cache, t2.getToState().cache);
                }
                return Double.compare(t1.getToState().minProbability, t2.getToState().minProbability);
            }
        });
        return transitionsToSort;
    }

    public short[] getState() {
        return this.state;
    }

    public void setMinProbability(double probability) {
        this.minProbability = probability;
    }

    public void setMaxProbability(double probability) {
        this.maxProbability = probability;
    }

    public void setCache(double probability) {
        this.cache = probability;
    }

    public void resetProbabilities() {
        this.minProbability = 0.0;
        this.maxProbability = 1.0;
    }

    public double getMinProbability() {
        return this.minProbability;
    }

    public double getMaxProbability() {
        return this.maxProbability;
    }

    public double getCache() {
        return this.cache;
    }

    public AbstractBoolean getProperty(int i) {
        boolean isFalse;
        assert (i >= 0 && i < 32);
        int mask = 1 << i;
        boolean isTrue = (mask & this.propertyTrue) == mask;
        boolean bl = isFalse = (mask & this.propertyFalse) == mask;
        if (isTrue) {
            if (isFalse) {
                return AbstractBoolean.MAYBE;
            }
            return AbstractBoolean.TRUE;
        }
        if (isFalse) {
            return AbstractBoolean.FALSE;
        }
        return AbstractBoolean.NOT_SET;
    }

    public void setProperty(int i, boolean isTrue, boolean isFalse) {
        assert (i >= 0 && i < 32);
        int mask = 1 << i;
        if (isTrue) {
            if (isFalse) {
                this.propertyTrue |= mask;
                this.propertyFalse |= mask;
            } else {
                this.propertyTrue |= mask;
                this.propertyFalse &= ~mask;
            }
        } else if (isFalse) {
            this.propertyTrue &= ~mask;
            this.propertyFalse |= mask;
        } else {
            this.propertyTrue &= ~mask;
            this.propertyFalse &= ~mask;
        }
    }

    public void setProperty(int i, AbstractBoolean value) {
        assert (i >= 0 && i < 32);
        int mask = 1 << i;
        switch (value) {
            case MAYBE: {
                this.propertyTrue |= mask;
                this.propertyFalse |= mask;
                break;
            }
            case TRUE: {
                this.propertyTrue |= mask;
                this.propertyFalse &= ~mask;
                break;
            }
            case FALSE: {
                this.propertyTrue &= ~mask;
                this.propertyFalse |= mask;
                break;
            }
            case NOT_SET: {
                this.propertyTrue &= ~mask;
                this.propertyFalse &= ~mask;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public String toString() {
        return Arrays.toString(this.state);
    }

    public String toStringFull() {
        String name = this.toString();
        char[] spaces = new char[name.length()];
        Arrays.fill(spaces, ' ');
        String space = new String(spaces);
        String stateString = String.valueOf(this.toString()) + " :: T=" + Integer.toBinaryString(this.propertyTrue) + "\n" + space + " :: F=" + Integer.toBinaryString(this.propertyFalse) + "\n" + space + " :: Probability = [" + this.minProbability + "," + this.maxProbability + "]";
        for (AbstractCTMCTransition t : this.transitions) {
            stateString = String.valueOf(stateString) + "\n" + space + " " + t.toStringPartial();
        }
        return stateString;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractCTMCState) {
            return Arrays.equals(this.state, ((AbstractCTMCState)o).state);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

