/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;

public class AbstractCTMCTransition {
    private AbstractCTMCState fromState;
    private AbstractCTMCState toState;
    private double minProb;
    private double maxProb;
    private short actionID;

    public AbstractCTMCTransition(AbstractCTMCState fromState, AbstractCTMCState toState, short actionID, double minProb, double maxProb) {
        this.fromState = fromState;
        this.toState = toState;
        this.actionID = actionID;
        this.minProb = minProb;
        this.maxProb = maxProb;
    }

    public AbstractCTMCTransition(AbstractCTMCState fromState, AbstractCTMCState toState, double minProb, double maxProb) {
        this(fromState, toState, -1, minProb, maxProb);
    }

    public AbstractCTMCState getFromState() {
        return this.fromState;
    }

    public AbstractCTMCState getToState() {
        return this.toState;
    }

    public short getActionID() {
        return this.actionID;
    }

    public void setToState(AbstractCTMCState state) {
        this.toState = state;
    }

    public double getMinProb() {
        return this.minProb;
    }

    public void setMinProb(double prob) {
        this.minProb = prob;
    }

    public double getMaxProb() {
        return this.maxProb;
    }

    public void setMaxProb(double prob) {
        this.maxProb = prob;
    }

    public void addProbability(double minProb, double maxProb) {
        this.minProb += minProb;
        this.maxProb += maxProb;
    }

    public void delimit(ArrayList<AbstractCTMCTransition> transitions) {
        double probLower = 0.0;
        double probUpper = 0.0;
        for (AbstractCTMCTransition t : transitions) {
            if (t == this) continue;
            probLower += t.minProb;
            probUpper += t.maxProb;
        }
        this.minProb = Math.max(this.minProb, 1.0 - probUpper);
        this.maxProb = Math.min(this.maxProb, 1.0 - probLower);
        if (this.maxProb < this.minProb) {
            double temp = this.minProb;
            this.minProb = this.maxProb;
            this.maxProb = temp;
        }
    }

    public static ArrayList<AbstractCTMCTransition> noLoopsDelimit(ArrayList<AbstractCTMCTransition> transitions) {
        ArrayList<AbstractCTMCTransition> newTransitions = new ArrayList<AbstractCTMCTransition>(transitions);
        AbstractCTMCTransition self_loop = null;
        for (AbstractCTMCTransition t : newTransitions) {
            if (!t.getToState().equals(t.getFromState())) continue;
            self_loop = t;
        }
        if (self_loop != null) {
            newTransitions.remove(self_loop);
            double minProbabilityFactor = self_loop.getMaxProb();
            double maxProbabilityFactor = self_loop.getMinProb();
            for (AbstractCTMCTransition t : newTransitions) {
                if (minProbabilityFactor < 1.0) {
                    t.minProb += t.minProb * minProbabilityFactor / (1.0 - minProbabilityFactor);
                }
                if (!(maxProbabilityFactor < 1.0)) continue;
                t.maxProb += t.maxProb * maxProbabilityFactor / (1.0 - maxProbabilityFactor);
            }
        }
        return newTransitions;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractCTMCTransition) {
            AbstractCTMCTransition t = (AbstractCTMCTransition)o;
            return this.fromState.equals(t.fromState) && this.toState.equals(t.toState) && this.maxProb == t.maxProb && this.minProb == t.minProb;
        }
        return false;
    }

    public String toString() {
        return this.fromState + "==(" + this.minProb + "," + this.maxProb + ")==>" + this.toState;
    }

    public String toStringPartial() {
        return "==(" + this.minProb + "," + this.maxProb + ")==>" + this.toState;
    }
}

