/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.internal.KroneckerStateSpace;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProbability;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAndNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAtomicNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLBooleanNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLImpliesNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLNextNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLNotNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLOrNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLPathPlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLPathPropertyNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLProbabilityComparator;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLProbabilityTest;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLStatePlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLSteadyStateNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLTimeInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLUntilNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ICSLModelChecker;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ILogListener;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ProbabilityInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMC;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLCompositionalModelChecker;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLPropertyManager;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalPropertyList;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ICSLVisitor;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.ModelCheckingLog;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.SteadyStateAnalyser;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.TransientAnalyser;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;

public class CSLModelChecker
implements ICSLVisitor,
ICSLModelChecker {
    private double boundAccuracy;
    private OptionMap optionMap;
    private IProgressMonitor monitor;
    private KroneckerStateSpace stateSpace;
    private CSLPropertyManager propertyManager;
    private AbstractCTMC abstractCTMC;
    private SequentialAbstraction[] abstraction;
    private ProbabilityInterval testAnswer;
    private ModelCheckingLog eventLog;

    public CSLModelChecker(KroneckerStateSpace stateSpace, AbstractCTMC abstractCTMC, SequentialAbstraction[] abstraction, OptionMap optionMap, IProgressMonitor monitor, double boundAccuracy, ModelCheckingLog eventLog) {
        this.stateSpace = stateSpace;
        this.abstractCTMC = abstractCTMC;
        this.propertyManager = abstractCTMC.getPropertyManager();
        this.abstraction = abstraction;
        this.optionMap = optionMap;
        this.boundAccuracy = boundAccuracy;
        this.eventLog = eventLog;
    }

    @Override
    public void visit(CSLPathPropertyNode node) throws ModelCheckingException {
        CSLAbstractProbability abstractProb = node.getComparator();
        if (abstractProb instanceof CSLProbabilityTest) {
            double lowerProbability = 1.0;
            double upperProbability = 0.0;
            AbstractCTMCState state = this.abstractCTMC.getInitialState();
            lowerProbability = Math.min(lowerProbability, state.getMinProbability());
            upperProbability = Math.max(upperProbability, state.getMaxProbability());
            this.testAnswer = new ProbabilityInterval(lowerProbability, upperProbability);
        } else if (abstractProb instanceof CSLProbabilityComparator) {
            CSLProbabilityComparator comparator = (CSLProbabilityComparator)abstractProb;
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean isOK = comparator.checkProbability(state.getMinProbability(), state.getMaxProbability());
                this.propertyManager.set(node, state, isOK);
            }
        }
    }

    @Override
    public void visit(CSLSteadyStateNode node) throws ModelCheckingException {
        ProbabilityInterval answer;
        CSLAbstractStateProperty property = node.getProperty();
        CSLAbstractProbability comparator = node.getComparator();
        SteadyStateAnalyser analyser = new SteadyStateAnalyser(this.stateSpace, this.abstractCTMC, this.propertyManager, this.abstraction, this.eventLog);
        if (property.isCompositional()) {
            CSLCompositionalModelChecker compositionalChecker = new CSLCompositionalModelChecker(this.propertyManager, this.abstraction);
            CompositionalPropertyList compositionalProperty = compositionalChecker.getProperty(property);
            answer = analyser.checkSteadyState(compositionalProperty, this.optionMap, this.monitor);
        } else {
            answer = analyser.checkSteadyState(property, this.optionMap, this.monitor);
        }
        if (comparator instanceof CSLProbabilityComparator) {
            CSLProbabilityComparator probabilityComparator = (CSLProbabilityComparator)comparator;
            boolean upperOK = probabilityComparator.checkProbability(answer.getUpper());
            boolean lowerOK = probabilityComparator.checkProbability(answer.getLower());
            AbstractBoolean isOK = upperOK && lowerOK ? AbstractBoolean.TRUE : (!upperOK && !lowerOK ? AbstractBoolean.FALSE : AbstractBoolean.MAYBE);
            this.propertyManager.setConstantProperty(node, isOK);
        } else if (comparator instanceof CSLProbabilityTest) {
            this.testAnswer = answer;
        } else assert (false);
    }

    @Override
    public void visit(CSLUntilNode node) throws ModelCheckingException {
        CSLAbstractStateProperty property1 = node.getProperty1();
        CSLAbstractStateProperty property2 = node.getProperty2();
        CSLTimeInterval timeInterval = node.getTimeInterval();
        TransientAnalyser analyser = new TransientAnalyser(this.abstractCTMC, this.propertyManager, this.boundAccuracy);
        analyser.checkUntil(property1, property2, timeInterval);
    }

    @Override
    public void visit(CSLNextNode node) throws ModelCheckingException {
        CSLAbstractStateProperty property = node.getProperty();
        CSLTimeInterval timeInterval = node.getTimeInterval();
        TransientAnalyser analyser = new TransientAnalyser(this.abstractCTMC, this.propertyManager, this.boundAccuracy);
        analyser.checkNext(property, timeInterval);
    }

    @Override
    public void visit(CSLBooleanNode node) throws ModelCheckingException {
    }

    @Override
    public void visit(CSLAtomicNode node) throws ModelCheckingException {
    }

    @Override
    public void visit(CSLPathPlaceHolder node) throws ModelCheckingException {
        throw new ModelCheckingException("This is not a valid CSL formula.");
    }

    @Override
    public void visit(CSLStatePlaceHolder node) throws ModelCheckingException {
        throw new ModelCheckingException("This is not a valid CSL formula.");
    }

    @Override
    public void visit(CSLNotNode node) throws ModelCheckingException {
        CSLAbstractStateProperty property = node.getProperty();
        AbstractBoolean value = this.propertyManager.getConstantProperty(property);
        if (value != null) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.not(value));
        } else if (property.isCompositional()) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.NOT_SET);
        } else {
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean v = this.propertyManager.test(property, state);
                AbstractBoolean isOK = AbstractBoolean.not(v);
                this.propertyManager.set(node, state, isOK);
            }
        }
    }

    @Override
    public void visit(CSLAndNode node) throws ModelCheckingException {
        CSLAbstractStateProperty property1 = node.getProperty1();
        CSLAbstractStateProperty property2 = node.getProperty2();
        AbstractBoolean value1 = this.propertyManager.getConstantProperty(property1);
        AbstractBoolean value2 = this.propertyManager.getConstantProperty(property2);
        if (value1 != null && value2 != null) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.and(value1, value2));
        } else if (property1.isCompositional() && property2.isCompositional()) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.NOT_SET);
        } else {
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean v1 = this.propertyManager.test(node.getProperty1(), state);
                AbstractBoolean v2 = this.propertyManager.test(node.getProperty2(), state);
                AbstractBoolean isOK = AbstractBoolean.and(v1, v2);
                this.propertyManager.set(node, state, isOK);
            }
        }
    }

    @Override
    public void visit(CSLOrNode node) throws ModelCheckingException {
        CSLAbstractStateProperty property1 = node.getProperty1();
        CSLAbstractStateProperty property2 = node.getProperty2();
        AbstractBoolean value1 = this.propertyManager.getConstantProperty(property1);
        AbstractBoolean value2 = this.propertyManager.getConstantProperty(property2);
        if (value1 != null && value2 != null) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.or(value1, value2));
        } else if (property1.isCompositional() && property2.isCompositional()) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.NOT_SET);
        } else {
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean v1 = this.propertyManager.test(node.getProperty1(), state);
                AbstractBoolean v2 = this.propertyManager.test(node.getProperty2(), state);
                AbstractBoolean isOK = AbstractBoolean.or(v1, v2);
                this.propertyManager.set(node, state, isOK);
            }
        }
    }

    @Override
    public void visit(CSLImpliesNode node) throws ModelCheckingException {
        CSLAbstractStateProperty property1 = node.getProperty1();
        CSLAbstractStateProperty property2 = node.getProperty2();
        AbstractBoolean value1 = this.propertyManager.getConstantProperty(property1);
        AbstractBoolean value2 = this.propertyManager.getConstantProperty(property2);
        if (value1 != null && value2 != null) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.implies(value1, value2));
        } else if (property1.isCompositional() && property2.isCompositional()) {
            this.propertyManager.setConstantProperty(node, AbstractBoolean.NOT_SET);
        } else {
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean v1 = this.propertyManager.test(node.getProperty1(), state);
                AbstractBoolean v2 = this.propertyManager.test(node.getProperty2(), state);
                AbstractBoolean isOK = AbstractBoolean.implies(v1, v2);
                this.propertyManager.set(node, state, isOK);
            }
        }
    }

    private ProbabilityInterval getTestAnswer() {
        return this.testAnswer;
    }

    private AbstractBoolean getTestOK(CSLAbstractStateProperty property) {
        AbstractBoolean isOK = this.propertyManager.getConstantProperty(property);
        if (isOK == null) {
            isOK = AbstractBoolean.TRUE;
            for (AbstractCTMCState state : this.abstractCTMC) {
                AbstractBoolean isStateOK = this.propertyManager.test(property, state);
                isOK = AbstractBoolean.and(isOK, isStateOK);
            }
        }
        return isOK;
    }

    private void modelCheck(CSLAbstractStateProperty property) throws ModelCheckingException {
        property.setCompositionality();
        this.propertyManager.addProperty(property);
        property.accept(this);
        int i = 0;
        while (i < this.abstraction.length) {
            this.abstraction[i].unregisterAllProperties();
            ++i;
        }
    }

    @Override
    public AbstractBoolean checkProperty(CSLAbstractStateProperty property) throws ModelCheckingException {
        if (property.isProbabilityTest()) {
            throw new ModelCheckingException("The property is not boolean: use testProperty() instead.");
        }
        this.modelCheck(property);
        return this.getTestOK(property);
    }

    @Override
    public ProbabilityInterval testProperty(CSLAbstractStateProperty property) throws ModelCheckingException {
        if (!property.isProbabilityTest()) {
            throw new ModelCheckingException("The property is not testable: use checkProperty() instead.");
        }
        this.modelCheck(property);
        return this.getTestAnswer();
    }

    @Override
    public void addLogListener(ILogListener listener) {
        if (this.eventLog != null) {
            this.eventLog.addListener(listener);
        }
    }
}

