/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import java.util.Iterator;
import uk.ac.ed.inf.pepa.ctmc.abstraction.SequentialAbstraction;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CompositionalProperty;

public class CompositionalPropertyList
implements Iterable<CompositionalProperty> {
    private ArrayList<CompositionalProperty> properties;
    private SequentialAbstraction[] abstraction;

    public CompositionalPropertyList(CompositionalProperty property) {
        this.properties = new ArrayList(10);
        this.properties.add(property);
        this.abstraction = property.getAbstraction();
    }

    public CompositionalPropertyList(ArrayList<CompositionalProperty> properties, SequentialAbstraction[] abstraction) {
        this.properties = properties;
        this.abstraction = abstraction;
    }

    public CompositionalPropertyList complement() {
        if (this.properties.size() == 0) {
            return new CompositionalPropertyList(new CompositionalProperty(this.abstraction, true));
        }
        ArrayList<CompositionalProperty> oldProperties = this.split().properties;
        ArrayList<CompositionalProperty> newProperties = new ArrayList<CompositionalProperty>(10);
        for (CompositionalProperty property : this.properties) {
            CompositionalPropertyList complement = property.complement().split();
            for (CompositionalProperty newProperty : complement) {
                if (oldProperties.contains(newProperty) || newProperties.contains(newProperty)) continue;
                newProperties.add(newProperty);
            }
        }
        return new CompositionalPropertyList(newProperties, this.abstraction);
    }

    public CompositionalPropertyList intersection(CompositionalPropertyList propertyList) {
        ArrayList<CompositionalProperty> newProperties = new ArrayList<CompositionalProperty>(10);
        for (CompositionalProperty property1 : this.properties) {
            for (CompositionalProperty property2 : propertyList) {
                CompositionalProperty newProperty = property1.intersection(property2);
                if (newProperty.isTrue()) {
                    return new CompositionalPropertyList(new CompositionalProperty(property1.getAbstraction(), true));
                }
                if (newProperty.isFalse() || newProperties.contains(newProperty)) continue;
                newProperties.add(newProperty);
            }
        }
        return new CompositionalPropertyList(newProperties, this.abstraction);
    }

    public CompositionalPropertyList union(CompositionalPropertyList propertyList) {
        boolean isDisjoint = true;
        block0: for (CompositionalProperty property1 : this.properties) {
            for (CompositionalProperty property2 : propertyList) {
                CompositionalProperty intersection;
                if (property1.equals(property2) || (intersection = property1.intersection(property2)).isFalse()) continue;
                isDisjoint = false;
                continue block0;
            }
        }
        if (isDisjoint) {
            ArrayList<CompositionalProperty> newProperties = new ArrayList<CompositionalProperty>(10);
            newProperties.addAll(this.properties);
            for (CompositionalProperty property : propertyList) {
                if (newProperties.contains(property)) continue;
                newProperties.add(property);
            }
            return new CompositionalPropertyList(newProperties, this.abstraction);
        }
        CompositionalPropertyList notProperty1 = this.complement();
        CompositionalPropertyList notProperty2 = propertyList.complement();
        return notProperty1.intersection(notProperty2).complement();
    }

    public boolean isFalse() {
        boolean isFalse = true;
        for (CompositionalProperty property : this.properties) {
            boolean bl = isFalse = isFalse && property.isFalse();
        }
        return isFalse;
    }

    public boolean isTrue() {
        if (this.properties.size() == 0) {
            return false;
        }
        boolean isTrue = true;
        for (CompositionalProperty property : this.properties) {
            boolean bl = isTrue = isTrue && property.isTrue();
        }
        return isTrue;
    }

    public CompositionalPropertyList split() {
        ArrayList<CompositionalProperty> newProperties = new ArrayList<CompositionalProperty>(10);
        for (CompositionalProperty property : this.properties) {
            newProperties.addAll(property.split().properties);
        }
        return new CompositionalPropertyList(newProperties, this.abstraction);
    }

    public boolean isSingleComponent() {
        if (this.properties.size() == 1) {
            return this.properties.get(0).isSingleComponent();
        }
        return false;
    }

    public void unregister() {
        for (CompositionalProperty property : this.properties) {
            property.unregister();
        }
    }

    @Override
    public Iterator<CompositionalProperty> iterator() {
        return this.properties.iterator();
    }

    public String toString() {
        String s = "";
        int i = 0;
        for (CompositionalProperty property : this.properties) {
            s = String.valueOf(s) + "Property " + i + ":\n" + property + "\n";
            ++i;
        }
        return s;
    }
}

