/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;

public class PoissonDistribution {
    private double lambda;
    private double t;
    private double epsilon;
    private int truncation;
    private ArrayList<Double> cache;

    public PoissonDistribution(double lambda, double t, double epsilon) {
        this.lambda = lambda;
        this.t = t;
        this.epsilon = epsilon;
        this.initialise();
    }

    public int getTruncationPoint() {
        return this.truncation;
    }

    private void initialise() {
        double psi;
        this.cache = new ArrayList(100);
        double sum = psi = Math.exp(-this.lambda * this.t);
        this.cache.add(psi);
        this.truncation = 0;
        while (sum < 1.0 - this.epsilon || this.truncation % 2 == 1) {
            ++this.truncation;
            psi *= this.lambda * this.t;
            sum += (psi /= (double)this.truncation);
            this.cache.add(psi);
        }
    }

    public double psi(int n) {
        assert (n >= 0);
        if (n > this.truncation) {
            return 0.0;
        }
        return this.cache.get(n);
    }
}

