/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.modelchecking.internal;

import java.util.ArrayList;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLTimeInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMC;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCProbabilities;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.AbstractCTMCTransition;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.CSLPropertyManager;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.internal.PoissonDistribution;

public class TransientAnalyser {
    private AbstractCTMC abstractCTMC;
    private CSLPropertyManager propertyManager;
    private double boundAccuracy;

    public TransientAnalyser(AbstractCTMC abstractCTMC, CSLPropertyManager propertyManager, double boundAccuracy) {
        this.abstractCTMC = abstractCTMC;
        this.propertyManager = propertyManager;
        this.boundAccuracy = boundAccuracy;
    }

    public void checkUntil(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2, CSLTimeInterval timeInterval) {
        if (timeInterval.isStartBounded() && timeInterval.isEndBounded()) {
            this.boundedUntil(property1, property2, timeInterval.getStartTime().getValue(), timeInterval.getEndTime().getValue());
        } else if (timeInterval.isStartBounded() && !timeInterval.isEndBounded()) {
            this.startBoundedUntil(property1, property2, timeInterval.getStartTime().getValue());
        } else if (!timeInterval.isStartBounded() && timeInterval.isEndBounded()) {
            this.endBoundedUntil(property1, property2, timeInterval.getEndTime().getValue());
        } else {
            this.unboundedUntil(property1, property2);
        }
    }

    public void checkNext(CSLAbstractStateProperty property, CSLTimeInterval timeInterval) throws ModelCheckingException {
        if (timeInterval.isStartBounded() || timeInterval.isEndBounded()) {
            throw new ModelCheckingException("Unable to model check the timed Next operator on an abstract model.");
        }
        this.unboundedNext(property);
    }

    private void boundedUntil(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2, double startTime, double endTime) {
        if (startTime == 0.0) {
            this.endBoundedUntil(property1, property2, endTime);
        } else {
            this.endBoundedUntil(property1, property2, endTime - startTime);
            this.reachabilitySatisfying(property1, startTime);
        }
    }

    private void startBoundedUntil(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2, double startTime) {
        if (startTime == 0.0) {
            this.unboundedUntil(property1, property2);
        } else {
            this.unboundedUntil(property1, property2);
            this.reachabilitySatisfying(property1, startTime);
        }
    }

    private void reachabilitySatisfying(CSLAbstractStateProperty property, double time) {
        PoissonDistribution poisson = new PoissonDistribution(this.abstractCTMC.getUniformisationConstant(), time, this.boundAccuracy);
        AbstractCTMCProbabilities probabilities = new AbstractCTMCProbabilities(this.abstractCTMC);
        AbstractCTMCProperty min_false_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty max_false_states = new AbstractCTMCProperty(this.abstractCTMC);
        for (AbstractCTMCState state : this.abstractCTMC) {
            AbstractBoolean v1 = this.propertyManager.test(property, state);
            if (v1 == AbstractBoolean.FALSE) {
                min_false_states.addState(state);
                max_false_states.addState(state);
            } else if (v1 == AbstractBoolean.MAYBE) {
                min_false_states.addState(state);
                probabilities.setProbability(state, 0.0, state.getMaxProbability());
            } else {
                probabilities.setProbability(state, state.getMinProbability(), state.getMaxProbability());
            }
            state.setMinProbability(0.0);
            state.setMaxProbability(0.0);
            state.setCache(0.0);
        }
        this.boundedReachabilityMin(min_false_states, probabilities, poisson);
        this.boundedReachabilityMax(max_false_states, probabilities, poisson);
        for (AbstractCTMCState state : this.abstractCTMC) {
            double newMinProb = state.getMinProbability() + poisson.psi(0) * probabilities.getProbability(state, true);
            double newMaxProb = state.getMaxProbability() + poisson.psi(0) * probabilities.getProbability(state, false);
            state.setMinProbability(newMinProb);
            state.setMaxProbability(Math.min(1.0, newMaxProb + this.boundAccuracy));
        }
    }

    private void endBoundedUntil(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2, double endTime) {
        AbstractCTMCProperty min_true_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty min_false_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty max_true_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty max_false_states = new AbstractCTMCProperty(this.abstractCTMC);
        for (AbstractCTMCState state : this.abstractCTMC) {
            AbstractBoolean v2;
            AbstractBoolean v1 = this.propertyManager.test(property1, state);
            AbstractBoolean isOK = v2 = this.propertyManager.test(property2, state);
            AbstractBoolean isPossiblyOK = AbstractBoolean.or(v1, v2);
            if (isOK == AbstractBoolean.TRUE) {
                min_true_states.addState(state);
                max_true_states.addState(state);
            } else if (isOK == AbstractBoolean.MAYBE) {
                max_true_states.addState(state);
            }
            if (isPossiblyOK == AbstractBoolean.FALSE) {
                min_false_states.addState(state);
                max_false_states.addState(state);
            } else if (isPossiblyOK == AbstractBoolean.MAYBE) {
                min_false_states.addState(state);
            }
            state.setMinProbability(0.0);
            state.setMaxProbability(0.0);
            state.setCache(0.0);
        }
        PoissonDistribution poisson = new PoissonDistribution(this.abstractCTMC.getUniformisationConstant(), endTime, this.boundAccuracy);
        this.boundedReachabilityMin(min_false_states, min_true_states, poisson);
        this.boundedReachabilityMax(max_false_states, max_true_states, poisson);
        for (AbstractCTMCState state : this.abstractCTMC) {
            if (min_true_states.containsState(state)) {
                state.setMinProbability(1.0);
                state.setMaxProbability(1.0);
                continue;
            }
            state.setMaxProbability(Math.min(1.0, state.getMaxProbability() + this.boundAccuracy));
        }
    }

    private void boundedReachabilityMin(AbstractCTMCProperty false_states, AbstractCTMCProperty true_states, PoissonDistribution poisson) {
        this.boundedReachability(false_states, true_states, poisson, true, null);
    }

    private void boundedReachabilityMax(AbstractCTMCProperty false_states, AbstractCTMCProperty true_states, PoissonDistribution poisson) {
        this.boundedReachability(false_states, true_states, poisson, false, null);
    }

    private void boundedReachabilityMin(AbstractCTMCProperty false_states, AbstractCTMCProbabilities probabilities, PoissonDistribution poisson) {
        AbstractCTMCProperty true_states = new AbstractCTMCProperty(this.abstractCTMC);
        this.boundedReachability(false_states, true_states, poisson, true, probabilities);
    }

    private void boundedReachabilityMax(AbstractCTMCProperty false_states, AbstractCTMCProbabilities probabilities, PoissonDistribution poisson) {
        AbstractCTMCProperty true_states = new AbstractCTMCProperty(this.abstractCTMC);
        this.boundedReachability(false_states, true_states, poisson, false, probabilities);
    }

    private void boundedReachability(AbstractCTMCProperty false_states, AbstractCTMCProperty true_states, PoissonDistribution poisson, boolean is_minimum, AbstractCTMCProbabilities probabilities) {
        int k = poisson.getTruncationPoint();
        assert (k % 2 == 0);
        boolean write_cache = false;
        int i = k;
        while (i > 0) {
            write_cache = !write_cache;
            double psi = poisson.psi(i);
            for (AbstractCTMCState state : this.abstractCTMC) {
                if (false_states.containsState(state)) continue;
                double newProb = 0.0;
                if (true_states.containsState(state)) {
                    newProb = psi + this.getProbability(state, is_minimum, !write_cache);
                } else {
                    ArrayList<AbstractCTMCTransition> transitions = state.getSortedTransitions(is_minimum, !write_cache);
                    double probabilityRemaining = 1.0;
                    double minimumRemaining = 0.0;
                    for (AbstractCTMCTransition t : transitions) {
                        minimumRemaining += t.getMinProb();
                    }
                    for (AbstractCTMCTransition t : transitions) {
                        AbstractCTMCState toState = t.getToState();
                        double transitionProbability = Math.min(t.getMaxProb(), probabilityRemaining - (minimumRemaining -= t.getMinProb()));
                        probabilityRemaining -= transitionProbability;
                        if (probabilities != null) {
                            newProb += psi * transitionProbability * probabilities.getProbability(toState, is_minimum);
                        } else if (true_states.containsState(toState)) {
                            newProb += psi * transitionProbability;
                        }
                        newProb += transitionProbability * this.getProbability(toState, is_minimum, !write_cache);
                    }
                }
                this.setProbability(state, newProb, is_minimum, write_cache);
            }
            --i;
        }
        assert (!write_cache);
    }

    private void unboundedUntil(CSLAbstractStateProperty property1, CSLAbstractStateProperty property2) {
        AbstractCTMCProperty min_true_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty min_false_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty max_true_states = new AbstractCTMCProperty(this.abstractCTMC);
        AbstractCTMCProperty max_false_states = new AbstractCTMCProperty(this.abstractCTMC);
        for (AbstractCTMCState state : this.abstractCTMC) {
            AbstractBoolean v2;
            state.resetProbabilities();
            AbstractBoolean v1 = this.propertyManager.test(property1, state);
            AbstractBoolean isOK = v2 = this.propertyManager.test(property2, state);
            AbstractBoolean isPossiblyOK = AbstractBoolean.or(v1, v2);
            if (isOK == AbstractBoolean.TRUE) {
                min_true_states.addState(state);
                max_true_states.addState(state);
            } else if (isOK == AbstractBoolean.MAYBE) {
                max_true_states.addState(state);
            }
            if (isPossiblyOK == AbstractBoolean.FALSE) {
                min_false_states.addState(state);
                max_false_states.addState(state);
                continue;
            }
            if (isPossiblyOK != AbstractBoolean.MAYBE) continue;
            min_false_states.addState(state);
        }
        this.unboundedReachability(min_true_states, min_false_states, property1, true);
        this.unboundedUntil(min_true_states, min_false_states, true);
        this.unboundedReachability(max_true_states, max_false_states, property1, false);
        this.unboundedUntil(max_true_states, max_false_states, false);
    }

    private void unboundedReachability(AbstractCTMCProperty true_states, AbstractCTMCProperty false_states, CSLAbstractStateProperty property, boolean is_minimum) {
        while (true_states.hasChanged() || false_states.hasChanged()) {
            true_states.resetChanged();
            false_states.resetChanged();
            for (AbstractCTMCState state : this.abstractCTMC) {
                if (true_states.containsState(state) || false_states.containsState(state)) continue;
                ArrayList<AbstractCTMCTransition> transitions = state.getTransitions();
                AbstractBoolean satisfiesProperty = this.propertyManager.test(property, state);
                boolean definitelyOK = is_minimum ? satisfiesProperty == AbstractBoolean.TRUE : satisfiesProperty != AbstractBoolean.FALSE;
                boolean definitelyNotOK = true;
                for (AbstractCTMCTransition t : transitions) {
                    AbstractCTMCState nextState = t.getToState();
                    if (nextState.equals(state)) continue;
                    if (!false_states.containsState(nextState)) {
                        definitelyNotOK = false;
                    }
                    if (true_states.containsState(nextState)) continue;
                    definitelyOK = false;
                }
                if (definitelyNotOK) {
                    false_states.addState(state);
                    continue;
                }
                if (!definitelyOK) continue;
                true_states.addState(state);
            }
        }
    }

    private void unboundedUntil(AbstractCTMCProperty true_states, AbstractCTMCProperty false_states, boolean is_minimum) {
        if (is_minimum) {
            for (AbstractCTMCState state : this.abstractCTMC) {
                if (true_states.containsState(state)) {
                    this.setProbability(state, 1.0, is_minimum, false);
                    this.setProbability(state, 1.0, is_minimum, true);
                    continue;
                }
                this.setProbability(state, 0.0, is_minimum, false);
                this.setProbability(state, 0.0, is_minimum, true);
            }
        } else {
            for (AbstractCTMCState state : this.abstractCTMC) {
                if (false_states.containsState(state)) {
                    this.setProbability(state, 0.0, is_minimum, false);
                    this.setProbability(state, 0.0, is_minimum, true);
                    continue;
                }
                this.setProbability(state, 1.0, is_minimum, false);
                this.setProbability(state, 1.0, is_minimum, true);
            }
        }
        boolean probabilities_changed = true;
        boolean write_cache = false;
        while (probabilities_changed || write_cache) {
            probabilities_changed = false;
            write_cache = !write_cache;
            for (AbstractCTMCState state : this.abstractCTMC) {
                if (true_states.containsState(state) || false_states.containsState(state)) continue;
                double prob = 0.0;
                double probabilityRemaining = 1.0;
                ArrayList<AbstractCTMCTransition> transitions = state.getSortedTransitions(is_minimum, !write_cache);
                double minimumRemaining = 0.0;
                for (AbstractCTMCTransition t : transitions) {
                    minimumRemaining += t.getMinProb();
                }
                for (AbstractCTMCTransition t : transitions) {
                    AbstractCTMCState nextState = t.getToState();
                    double nextProb = this.getProbability(nextState, is_minimum, !write_cache);
                    double transitionProbability = Math.min(t.getMaxProb(), probabilityRemaining - (minimumRemaining -= t.getMinProb()));
                    probabilityRemaining -= transitionProbability;
                    prob += transitionProbability * nextProb;
                }
                double currentProb = this.getProbability(state, is_minimum, !write_cache);
                if (Math.abs(currentProb - prob) > this.boundAccuracy) {
                    probabilities_changed = true;
                }
                this.setProbability(state, prob, is_minimum, write_cache);
            }
        }
        assert (!write_cache);
    }

    private void unboundedNext(CSLAbstractStateProperty property) {
        for (AbstractCTMCState state : this.abstractCTMC) {
            state.resetProbabilities();
            ArrayList<AbstractCTMCTransition> transitions = AbstractCTMCTransition.noLoopsDelimit(state.getTransitions());
            double minProbability = 0.0;
            double maxProbability = 0.0;
            double minProbabilityRemaining = 1.0;
            double maxProbabilityRemaining = 1.0;
            double minimumRemaining = 0.0;
            double maximumRemaining = 0.0;
            for (AbstractCTMCTransition t : transitions) {
                minimumRemaining += t.getMinProb();
                maximumRemaining += t.getMaxProb();
            }
            for (AbstractCTMCTransition t : transitions) {
                double transitionProbability;
                minimumRemaining -= t.getMinProb();
                maximumRemaining -= t.getMaxProb();
                AbstractCTMCState nextState = t.getToState();
                AbstractBoolean isOK = this.propertyManager.test(property, nextState);
                if (isOK == AbstractBoolean.TRUE) {
                    transitionProbability = Math.max(t.getMinProb(), minProbabilityRemaining - maximumRemaining);
                    minProbabilityRemaining -= transitionProbability;
                    minProbability += transitionProbability;
                } else {
                    minProbabilityRemaining -= Math.min(t.getMaxProb(), minProbabilityRemaining - minimumRemaining);
                }
                if (isOK != AbstractBoolean.FALSE) {
                    transitionProbability = Math.min(t.getMaxProb(), maxProbabilityRemaining - minimumRemaining);
                    maxProbabilityRemaining -= transitionProbability;
                    maxProbability += transitionProbability;
                    continue;
                }
                maxProbabilityRemaining -= Math.max(t.getMinProb(), maxProbabilityRemaining - maximumRemaining);
            }
            state.setMinProbability(minProbability);
            state.setMaxProbability(maxProbability);
        }
    }

    private double getProbability(AbstractCTMCState state, boolean is_minimum, boolean read_cache) {
        if (read_cache) {
            return state.getCache();
        }
        if (is_minimum) {
            return state.getMinProbability();
        }
        return state.getMaxProbability();
    }

    private void setProbability(AbstractCTMCState state, double probability, boolean is_minimum, boolean write_cache) {
        if (probability < 0.0) {
            probability = 0.0;
        }
        if (probability > 1.0) {
            probability = 1.0;
        }
        if (write_cache) {
            state.setCache(probability);
        } else if (is_minimum) {
            state.setMinProbability(probability);
        } else {
            state.setMaxProbability(probability);
        }
    }
}

