/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution.internal.mtj;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AMG;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.BiCG;
import no.uib.cipr.matrix.sparse.BiCGstab;
import no.uib.cipr.matrix.sparse.CG;
import no.uib.cipr.matrix.sparse.CGS;
import no.uib.cipr.matrix.sparse.Chebyshev;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.DiagonalPreconditioner;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.GMRES;
import no.uib.cipr.matrix.sparse.ICC;
import no.uib.cipr.matrix.sparse.ILU;
import no.uib.cipr.matrix.sparse.ILUT;
import no.uib.cipr.matrix.sparse.IR;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.QMR;
import no.uib.cipr.matrix.sparse.SSOR;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;

public class MTJFactory {
    public static AbstractIterativeSolver createSolver(int solverId, DenseVector x, OptionMap options) {
        switch (solverId) {
            case 0: {
                return new BiCG((Vector)x);
            }
            case 1: {
                return new BiCGstab((Vector)x);
            }
            case 2: {
                return new CG((Vector)x);
            }
            case 3: {
                return new CGS((Vector)x);
            }
            case 4: {
                return MTJFactory.handleGMRES(x, options);
            }
            case 5: {
                return new IR((Vector)x);
            }
            case 6: {
                return new QMR((Vector)x);
            }
            case 8: {
                return MTJFactory.handleCheb(x, options);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Preconditioner createPreconditioner(int id, Matrix template, OptionMap options) {
        switch (id) {
            case 1: {
                return MTJFactory.handleAMG(true, template, options);
            }
            case 2: {
                return MTJFactory.handleAMG(false, template, options);
            }
            case 3: {
                return new ICC(new CompRowMatrix(template));
            }
            case 6: {
                return new ILU(new CompRowMatrix(template));
            }
            case 7: {
                return MTJFactory.handleILUT(new FlexCompRowMatrix(template), options);
            }
            case 4: {
                return MTJFactory.handleSSOR(new CompRowMatrix(template), options);
            }
            case 5: {
                return new DiagonalPreconditioner(template.numRows());
            }
        }
        throw new IllegalArgumentException();
    }

    private static Preconditioner handleSSOR(CompRowMatrix matrix, OptionMap options) {
        return new SSOR(matrix, ((Boolean)options.get("ssor.reverse")).booleanValue(), ((Double)options.get("ssor.omega.f")).doubleValue(), ((Double)options.get("ssor.omega.r")).doubleValue());
    }

    private static Preconditioner handleILUT(FlexCompRowMatrix matrix, OptionMap options) {
        return new ILUT(matrix, ((Double)options.get("ilut.tau")).doubleValue(), ((Integer)options.get("ilut.p")).intValue());
    }

    private static Preconditioner handleAMG(boolean withSSOR, Matrix template, OptionMap options) {
        int nu1 = (Integer)options.get("amg.nu1");
        int nu2 = (Integer)options.get("amg.nu2");
        int min = (Integer)options.get("amg.min");
        int gamma = (Integer)options.get("amg.gamma");
        double omega = (Double)options.get("amg.omega");
        if (withSSOR) {
            double pref = (Double)options.get("amg.omega.pre.f");
            double prer = (Double)options.get("amg.omega.pre.r");
            double postf = (Double)options.get("amg.omega.post.f");
            double postr = (Double)options.get("amg.omega.post.r");
            return new AMG(pref, prer, postf, postr, nu1, nu2, gamma, min, omega);
        }
        double pre = (Double)options.get("amg.omega.pre");
        double post = (Double)options.get("amg.omega.post");
        return new AMG(pre, post, nu1, nu2, gamma, min, omega);
    }

    private static Chebyshev handleCheb(DenseVector x, OptionMap options) {
        double min = (Double)options.get("cheb.min");
        double max = (Double)options.get("cheb.max");
        return new Chebyshev((Vector)x, min, max);
    }

    private static GMRES handleGMRES(DenseVector x, OptionMap options) {
        int restart = (Integer)options.get("gmres.restart");
        return new GMRES((Vector)x, restart);
    }
}

