/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution.internal.mtj;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterationReporter;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import no.uib.cipr.matrix.sparse.MatrixIterationMonitor;
import no.uib.cipr.matrix.sparse.Preconditioner;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.mtj.MTJFactory;

public class MTJSolver
implements ISolver {
    private IProgressMonitor monitor;
    private Matrix A;
    private DenseVector b;
    private DenseVector x;
    private OptionMap options;
    private AbstractIterativeSolver solver;

    public MTJSolver(AbstractIterativeSolver solver, Matrix A, DenseVector b, DenseVector x, OptionMap options) {
        this.A = A;
        this.b = b;
        this.x = x;
        this.options = options;
        this.solver = solver;
    }

    @Override
    public double[] solve(IProgressMonitor monitor) throws SolverException {
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        this.monitor = monitor;
        try {
            try {
                int total = (Integer)this.options.get("iteration.monitor.max_iter");
                this.monitor.beginTask(total);
                this.solve();
            }
            catch (IterativeSolverNotConvergedException e) {
                String message = null;
                switch (e.getReason()) {
                    case Breakdown: {
                        message = "The iterative process detected a breakdown";
                        break;
                    }
                    case Divergence: {
                        message = "Divergence detected. Residual " + e.getResidual() + ", " + " at " + e.getIterations() + " iteration.";
                        break;
                    }
                    case Iterations: {
                        message = "Maximum number of iterations reached";
                        break;
                    }
                    default: {
                        message = "";
                    }
                }
                throw new SolverException(message, 0);
            }
        }
        finally {
            monitor.done();
        }
        return this.x.getData();
    }

    private Vector solve() throws IterativeSolverNotConvergedException {
        if ((Integer)this.options.get("ctmc.solver.preconditioner") != 0) {
            int precondId = (Integer)this.options.get("ctmc.solver.preconditioner");
            Preconditioner M = MTJFactory.createPreconditioner(precondId, this.A.copy(), this.options);
            M.setMatrix(this.A);
            this.solver.setPreconditioner(M);
        }
        this.handleIterationMonitor();
        this.handleIterationReporter();
        return this.solver.solve(this.A, (Vector)this.b, (Vector)this.x);
    }

    private void handleIterationMonitor() {
        if (this.options.get("iteration.monitor.type").equals("iteration.monitor.default")) {
            this.solver.setIterationMonitor((IterationMonitor)new DefaultIterationMonitor(((Integer)this.options.get("iteration.monitor.max_iter")).intValue(), ((Double)this.options.get("iteration.monitor.rtol")).doubleValue(), ((Double)this.options.get("iteration.monitor.atol")).doubleValue(), ((Double)this.options.get("iteration.monitor.dtol")).doubleValue()));
        } else if (this.options.get("iteration.monitor.type").equals("iteration.monitor.matrix")) {
            this.solver.setIterationMonitor((IterationMonitor)new MatrixIterationMonitor(((Double)this.options.get("iteration.monitor.norm.a")).doubleValue(), ((Double)this.options.get("iteration.monitor.norm.b")).doubleValue(), ((Integer)this.options.get("iteration.monitor.max_iter")).intValue(), ((Double)this.options.get("iteration.monitor.rtol")).doubleValue(), ((Double)this.options.get("iteration.monitor.atol")).doubleValue(), ((Double)this.options.get("iteration.monitor.dtol")).doubleValue()));
        }
    }

    private void handleIterationReporter() {
        IterationMonitor monitor = this.solver.getIterationMonitor();
        if (this.monitor != null) {
            monitor.setIterationReporter(new IterationReporter(){

                public void monitor(double residualNorm, Vector stateVector, int iterationNumber) {
                    MTJSolver.this.monitor.worked(1);
                }

                public void monitor(double residualNorm, int iterationNumber) {
                    MTJSolver.this.monitor.worked(1);
                }
            });
        }
    }
}

