/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution.internal.simple;

import java.util.Arrays;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.AbstractSolver;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;

public class CGS
extends AbstractSolver {
    public CGS(Generator generator, OptionMap options) {
        super(generator, options);
    }

    @Override
    protected double[] doSolve(int[] rows, int[] columns, double[] values, double[] diagonal, IProgressMonitor monitor) throws SolverException {
        double[] u_i = new double[rows.length];
        double[] p_i = new double[rows.length];
        double[] q_tilde = new double[rows.length];
        double[] q_i = new double[rows.length];
        double[] r_0 = new double[rows.length];
        double[] r_i = new double[rows.length];
        double[] v = new double[rows.length];
        double[] x = new double[rows.length];
        double rho_i_1 = 0.0;
        double rho_i_2 = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        Arrays.fill(x, 1.0 / (double)x.length);
        CGS.mvp(rows, columns, values, diagonal, x, r_0);
        int i = 0;
        while (i < r_0.length) {
            r_0[i] = i == r_0.length - 1 ? 1.0 - r_0[i] : -r_0[i];
            ++i;
        }
        System.arraycopy(r_0, 0, r_i, 0, r_0.length);
        i = 0;
        while (true) {
            ++i;
            rho_i_1 = CGS.vvp(r_0, r_i);
            if (rho_i_1 == 0.0) {
                return x;
            }
            if (i == 1) {
                System.arraycopy(r_0, 0, u_i, 0, r_0.length);
                System.arraycopy(u_i, 0, p_i, 0, u_i.length);
            } else {
                beta = rho_i_1 / rho_i_2;
                double current_u_i = 0.0;
                int j = 0;
                while (j < u_i.length) {
                    u_i[j] = current_u_i = r_i[j] + beta * q_i[j];
                    p_i[j] = current_u_i + beta * (q_i[j] + beta * p_i[j]);
                    ++j;
                }
            }
            CGS.mvp(rows, columns, values, diagonal, p_i, v);
            alpha = rho_i_1 / CGS.vvp(r_0, v);
            int j = 0;
            while (j < q_i.length) {
                q_i[j] = u_i[j] - alpha * v[j];
                u_i[j] = u_i[j] + q_i[j];
                ++j;
            }
            j = 0;
            while (j < x.length) {
                int n = j;
                x[n] = x[n] + alpha * u_i[j];
                ++j;
            }
            CGS.mvp(rows, columns, values, diagonal, u_i, q_tilde);
            double norm = 0.0;
            double diff = 0.0;
            int j2 = 0;
            while (j2 < r_i.length) {
                diff = alpha * q_tilde[j2];
                r_i[j2] = r_i[j2] - diff;
                norm += Math.abs(diff);
                ++j2;
            }
            double absoluteNorm = 0.0;
            double[] result = new double[x.length];
            CGS.mvp(rows, columns, values, diagonal, x, result);
            int j3 = 0;
            while (j3 < result.length) {
                absoluteNorm += Math.pow(j3 == result.length - 1 ? 1.0 - result[j3] : result[j3], 2.0);
                ++j3;
            }
            double absNorm = Math.sqrt(absoluteNorm);
            System.err.println("Absolute norm:" + absNorm);
            if (absNorm < 1.0E-8) break;
            if (i == 5000) {
                throw new SolverException("CGS did not converge after " + i + " iterations", 0);
            }
            rho_i_2 = rho_i_1;
        }
        return x;
    }

    private static final void debug(String message, double[] vector) {
    }

    private static final void mvp(int[] rows, int[] columns, double[] values, double[] diagonal, double[] vector, double[] solution) {
        double sum = 0.0;
        int i = 0;
        while (i < rows.length) {
            sum = diagonal[i] * vector[i];
            int j = rows[i];
            int range = i == rows.length - 1 ? values.length : rows[i + 1];
            while (j < range) {
                int j_index = columns[j];
                if (j_index != i) {
                    sum += values[j] * vector[j_index];
                }
                ++j;
            }
            solution[i] = sum;
            ++i;
        }
    }

    private static final double vvp(double[] v1, double[] v2) {
        double sum = 0.0;
        int i = 0;
        while (i < v1.length) {
            sum += v1[i] * v2[i];
            ++i;
        }
        return sum;
    }
}

