/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ctmc.solution.internal.simple;

import java.util.Arrays;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.AbstractSolver;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.simple.Generator;

public class GaussSeidel
extends AbstractSolver {
    public GaussSeidel(Generator generator, OptionMap options) {
        super(generator, options);
    }

    @Override
    protected final double[] doSolve(int[] rows, int[] columns, double[] values, double[] diagonal, IProgressMonitor monitor) throws SolverException {
        double[] x_k = new double[rows.length];
        Arrays.fill(x_k, 1.0 / (double)x_k.length);
        int iteration = 0;
        double b = 0.0;
        double max_norm = (Double)this.options.get("ctmc.solver.simple.tol");
        double norm = Double.MAX_VALUE;
        double last_norm = Double.MAX_VALUE;
        double sum = 0.0;
        double bMinusSum = 0.0;
        double w = (Double)this.options.get("ctmc.solver.simple.w");
        while (max_norm < norm) {
            if (iteration++ == this.maxIteration) {
                throw new SolverException(GaussSeidel.createMaximumIterationsMessage(this.maxIteration, norm), 0);
            }
            if (iteration % 20 == 0 && iteration != 0) {
                monitor.worked(20);
            }
            norm = 0.0;
            int i = 0;
            while (i < rows.length) {
                sum = 0.0;
                int j = rows[i];
                int range = i == rows.length - 1 ? values.length : rows[i + 1];
                while (j < range) {
                    int j_index = columns[j];
                    if (j_index != i) {
                        sum += values[j] * x_k[j_index];
                    }
                    ++j;
                }
                b = i == rows.length - 1 ? 1.0 : 0.0;
                bMinusSum = b - sum;
                x_k[i] = (1.0 - w) * x_k[i] + w * bMinusSum / diagonal[i];
                norm += Math.pow(b - (sum + diagonal[i] * x_k[i]), 2.0);
                ++i;
            }
            if ((norm = Math.sqrt(norm)) > last_norm) {
                throw new SolverException(GaussSeidel.createDivergenceDetected(iteration, norm), 0);
            }
            last_norm = norm;
        }
        return x_k;
    }
}

