/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver;

import java.io.FileWriter;
import java.io.IOException;

public class PassageTimeResults {
    private double[] timePoints;
    private double[] cdfPoints;
    private double[] pdfPoints;
    private String cdfName = "cdf";
    private String pdfName = "pdf";

    public PassageTimeResults(int numberTimePoints) {
        this.timePoints = new double[numberTimePoints];
        this.cdfPoints = new double[numberTimePoints];
        this.pdfPoints = new double[numberTimePoints];
    }

    public PassageTimeResults(int numberTimePoints, String cdfName, String pdfName) {
        this.timePoints = new double[numberTimePoints];
        this.cdfPoints = new double[numberTimePoints];
        this.pdfPoints = new double[numberTimePoints];
        this.cdfName = cdfName;
        this.pdfName = pdfName;
    }

    public double[] getTimePoints() {
        return this.timePoints;
    }

    public double[] getCdfPoints() {
        return this.cdfPoints;
    }

    public double[] getPdfPoints() {
        return this.pdfPoints;
    }

    public String getCdfName() {
        return this.cdfName;
    }

    public String getPdfName() {
        return this.pdfName;
    }

    public void updateTimePoint(int i, double t, double cdf, double pdf) {
        this.timePoints[i] = t;
        this.cdfPoints[i] = cdf;
        this.pdfPoints[i] = pdf;
    }

    public int printOutResults(String basename) {
        basename = basename.replace(".mod", "");
        String pdfResultsFileName = basename.concat(".PDF_RESULTS");
        String cdfResultsFileName = basename.concat(".CDF_RESULTS");
        try {
            FileWriter pdf_result_output = new FileWriter(pdfResultsFileName);
            FileWriter cdf_result_output = new FileWriter(cdfResultsFileName);
            int i = 0;
            while (i < this.timePoints.length) {
                pdf_result_output.write(String.valueOf(this.timePoints[i]) + "    " + this.pdfPoints[i] + "\n");
                cdf_result_output.write(String.valueOf(this.timePoints[i]) + "    " + this.cdfPoints[i] + "\n");
                System.out.println(String.valueOf(this.timePoints[i]) + "    " + this.pdfPoints[i] + "    PDF_DATA0");
                System.out.println(String.valueOf(this.timePoints[i]) + "    " + this.cdfPoints[i] + "    CDF_DATA0");
                ++i;
            }
            pdf_result_output.close();
            cdf_result_output.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return -1;
        }
        return 0;
    }
}

