/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver;

import java.util.BitSet;
import java.util.Vector;
import uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver.PassageTimeResults;
import uk.ac.ed.inf.pepa.jhydra.matrix.Matrix;

public class PassageTimeSolver {
    private Matrix myMatrix;
    private boolean doPassage = true;
    private boolean doTransient = false;
    private long trans;
    private long tangible;
    private long MAX_N;
    private double _q;
    private double t_bottom;
    private double t_top;
    private double t_step;
    private BitSet target_states;
    private Vector<Double> diagonal;
    private Vector<Double> rhs;
    private Vector<Double> sum;
    private double[] weight;

    public PassageTimeSolver(Matrix m, double[] s, BitSet t, double start, double stop, double step) {
        System.out.println("Starting construction of PassageTimeSolver...");
        this.myMatrix = m;
        this.trans = 0L;
        this.MAX_N = -1L;
        this.t_bottom = start;
        this.t_top = stop;
        this.t_step = step;
        this.tangible = this.myMatrix.getTangible();
        this.target_states = t;
        this.weight = s;
        System.out.println("Finished construction of PassageTimeSolver...");
    }

    public PassageTimeResults uniformise(String basename, String cdfName, String pdfName) {
        this._q = this.myMatrix.uniformiseMatrix(this.target_states, this.doPassage);
        System.out.println("_q = " + this._q);
        double[] pi = new double[(int)this.tangible];
        double[] result = new double[(int)this.tangible];
        long pdf_max_hops = -1L;
        long cdf_max_hops = -1L;
        long max_hops = -1L;
        System.out.println("Preparing to calculate a value for max_hops...");
        if (this.MAX_N == -1L) {
            int temp_max = 10000000L / this.tangible > 10000L ? 10000000 / (int)this.tangible : 10000;
            pdf_max_hops = this.calc_left_terms(temp_max, this.t_top, false);
            if (this.doPassage) {
                cdf_max_hops = this.calc_left_terms(temp_max, this.t_top, true);
            }
            max_hops = pdf_max_hops > cdf_max_hops ? pdf_max_hops : cdf_max_hops;
        } else {
            max_hops = this.MAX_N;
        }
        System.out.println("max_hops has been set to " + max_hops + "...");
        double[] sum_pi_target = new double[(int)max_hops + 1];
        int n = 0;
        while ((long)n < this.tangible) {
            pi[n] = this.weight[n];
            ++n;
        }
        boolean converged = false;
        int hop = 1;
        while ((long)hop <= max_hops) {
            if (!converged) {
                this.myMatrix.transMultiply(pi, result);
            }
            sum_pi_target[hop] = 0.0;
            converged = true;
            int n2 = 0;
            while ((long)n2 < this.tangible) {
                if (Math.abs(pi[n2] - result[n2]) > 1.0E-10) {
                    converged = false;
                }
                pi[n2] = result[n2];
                if (this.target_states.get(n2)) {
                    int n3 = hop;
                    sum_pi_target[n3] = sum_pi_target[n3] + pi[n2];
                }
                ++n2;
            }
            if (hop % 100 == 0) {
                System.out.println("done matrix multiplication " + hop + " of " + max_hops + " ...");
            }
            ++hop;
        }
        double timePoint = this.t_bottom;
        int numberTimePoints = 0;
        numberTimePoints = 0;
        while (timePoint <= this.t_top) {
            ++numberTimePoints;
            timePoint += this.t_step;
        }
        timePoint = this.t_bottom;
        PassageTimeResults ptResults = new PassageTimeResults(numberTimePoints, cdfName, pdfName);
        int count = 0;
        while (timePoint <= this.t_top) {
            double pdf_answer = 0.0;
            double cdf_answer = 0.0;
            boolean had_non_zero = false;
            int hop2 = 1;
            while ((long)hop2 <= max_hops) {
                double term = this.log_erlang(hop2, this._q, timePoint) * sum_pi_target[hop2];
                if (term > 1.0E-20) {
                    had_non_zero = true;
                }
                pdf_answer += term;
                if (this.doPassage) {
                    cdf_answer += this.log_erlang_cdf(hop2, this._q, timePoint) * sum_pi_target[hop2];
                }
                if (this.MAX_N != -1L && hop2 > 5 && had_non_zero && term < 1.0E-30) break;
                ++hop2;
            }
            if (cdf_answer > 1.00001) {
                System.out.println("Serious error, cdf value much larger than 1, it is: " + cdf_answer);
                System.exit(1);
            }
            cdf_answer = Math.min(1.0, cdf_answer);
            if (timePoint == 0.0) {
                ptResults.updateTimePoint(count, 0.0, 0.0, pdf_answer);
            } else {
                ptResults.updateTimePoint(count, timePoint, cdf_answer, pdf_answer);
            }
            ++count;
            timePoint += this.t_step;
        }
        return ptResults;
    }

    private double log_erlang(int n, double q, double t) {
        if (this.doPassage) {
            double logn = 0.0;
            int k = 2;
            while (k < n) {
                logn += Math.log(k);
                ++k;
            }
            double logp = (double)n * Math.log(q) + (double)(n - 1) * Math.log(t) - (logn += q * t);
            return Math.exp(logp);
        }
        double logn = 0.0;
        int k = 2;
        while (k <= n) {
            logn += Math.log(k);
            ++k;
        }
        double logp = (double)n * Math.log(q) + (double)n * Math.log(t) - (logn += q * t);
        return Math.exp(logp);
    }

    private double log_erlang_cdf(int n, double q, double t) {
        double sum = 0.0;
        double logn = 0.0;
        int i = 0;
        while (i < n) {
            if (i >= 2) {
                logn += Math.log(i);
            }
            double logc = (double)i * (Math.log(q) + Math.log(t)) - (logn + q * t);
            sum += Math.exp(logc);
            ++i;
        }
        if (sum > 1.0) {
            sum = 1.0;
        }
        return 1.0 - sum;
    }

    private int calc_left_terms(int max, double t, boolean doCDF) {
        boolean had_non_zero = false;
        int n = 1;
        while (n < max + 2) {
            double term = this.log_erlang(n, this._q, t);
            if (term > 1.0E-20) {
                had_non_zero = true;
            }
            if (n > 5 && had_non_zero && term < 1.0E-30) break;
            if (n % 100 == 0) {
                System.out.println("term t = " + t + " n = " + n);
            }
            if (n == max) {
                System.out.println("Erlang terms have not decayed to 0 by n=" + n + "...");
                System.out.println("Suggest lowering the t-range or reducing rates...");
                System.exit(-1);
            }
            ++n;
        }
        return n;
    }
}

