/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.matrix;

import java.util.BitSet;
import java.util.Vector;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixElement;
import uk.ac.ed.inf.pepa.jhydra.matrix.MatrixRow;

public class Matrix {
    private Vector<MatrixRow> rows = new Vector(0, 1);
    private Vector<MatrixRow> cols = new Vector(0, 1);
    private Vector<Double> rowSums = new Vector(0, 1);

    public void addRow(MatrixRow r, int rowNumber) {
        Double rowSum = new Double(r.getRowSum());
        MatrixElement diag = new MatrixElement(rowNumber, -rowSum.doubleValue());
        r.add(diag);
        this.rows.add(r);
        this.rowSums.add(rowSum);
    }

    public void columnify() {
        int i = 0;
        while ((long)i < this.getTangible()) {
            MatrixRow newCol = new MatrixRow(i);
            this.cols.add(newCol);
            ++i;
        }
        int i2 = 0;
        while ((long)i2 < this.getTangible()) {
            MatrixRow mR = this.rows.get(i2);
            int j = 0;
            while (j < mR.size()) {
                MatrixElement mE = mR.getElement(j);
                MatrixElement newME = new MatrixElement(i2, mE.getValue());
                this.cols.get((int)mE.getOffset()).add(newME);
                ++j;
            }
            ++i2;
        }
    }

    public void pify() {
        Double[] factor = new Double[this.rowSums.size()];
        this.rowSums.toArray(factor);
        int i = 0;
        while ((long)i < this.getTangible()) {
            MatrixRow col = this.cols.get(i);
            int j = 0;
            while (j < col.size()) {
                MatrixElement mE = col.getElement(j);
                mE.setValue(mE.getValue() / factor[(int)mE.getOffset()]);
                ++j;
            }
            ++i;
        }
    }

    public void unpify() {
        Double[] factor = new Double[this.rowSums.size()];
        this.rowSums.toArray(factor);
        int i = 0;
        while ((long)i < this.getTangible()) {
            MatrixRow col = this.cols.get(i);
            int j = 0;
            while (j < col.size()) {
                MatrixElement mE = col.getElement(j);
                mE.setValue(mE.getValue() * factor[(int)mE.getOffset()]);
                ++j;
            }
            ++i;
        }
    }

    public void transMultiply(double[] input, double[] output) {
        int n = 0;
        while (n < this.cols.size()) {
            MatrixRow _col = this.cols.get(n);
            double sum = 0.0;
            int t = 0;
            while (t < _col.size()) {
                sum += _col.getElement(t).getValue() * input[(int)_col.getElement(t).getOffset()];
                ++t;
            }
            output[n] = sum;
            ++n;
        }
    }

    public MatrixRow getRow(int i) {
        return this.rows.get(i);
    }

    public MatrixRow getCol(int i) {
        return this.cols.get(i);
    }

    public long getTangible() {
        return this.rows.size();
    }

    public void print() {
        int i = 0;
        while (i < this.rows.size()) {
            MatrixRow mR = this.rows.get(i);
            System.out.print("[" + i + "]  ");
            mR.print();
            System.out.print("  sum=" + this.rowSums.get(i).toString());
            System.out.println("");
            ++i;
        }
    }

    public double getLargestNonZero() {
        double value = 0.0;
        int n = 0;
        while (n < this.cols.size()) {
            MatrixRow _col = this.cols.get(n);
            double sum = 0.0;
            int t = 0;
            while (t < _col.size()) {
                if (_col.getElement(t).getOffset() != (long)n) {
                    sum += _col.getElement(t).getValue();
                }
                ++t;
            }
            if (sum > value) {
                value = sum;
            }
            ++n;
        }
        return value;
    }

    public double uniformiseMatrix(BitSet target_states, boolean doPassage) {
        double _q = this.getLargestNonZero();
        _q *= 1.01;
        int i = 0;
        while (i < this.rows.size()) {
            if (i % 1000 == 0) {
                System.out.println("Uniformising matrix row " + i + "...");
            }
            MatrixRow _row = this.rows.get(i);
            double rowSum = _row.getRowSum();
            int j = 0;
            while (j < _row.size()) {
                MatrixElement mE = _row.getElement(j);
                if (doPassage) {
                    if (target_states.get(i)) {
                        mE.setValue(0.0);
                    } else if (!target_states.get(i) && mE.getOffset() != (long)i) {
                        mE.setValue(mE.getValue() / _q);
                    } else {
                        mE.setValue(1.0 - rowSum / _q);
                    }
                } else if (mE.getOffset() != (long)i) {
                    mE.setValue(mE.getValue() / _q);
                } else if (mE.getOffset() == (long)i) {
                    mE.setValue(1.0 - rowSum / _q);
                }
                ++j;
            }
            ++i;
        }
        this.cols = new Vector(0, 1);
        this.cols.setSize(0);
        this.columnify();
        return _q;
    }
}

