/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.petrinet;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Element;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Node;

public class Arc
extends Element
implements Serializable {
    private Node start;
    private Node end;
    private Integer weight;
    private int boxX;
    private int boxY;
    private static int number = 1;
    private static final char character = 'a';

    public Arc(Node s, Node e) {
        this.start = s;
        this.end = e;
        this.comment = null;
        this.weight = new Integer(1);
        this.setName('a', number++);
        this.boxX = (this.start.getX() + this.end.getX()) / 2 - 3;
        this.boxY = (this.start.getY() + this.end.getY()) / 2 - 3;
        System.out.println("Created a new arc between " + s.getName() + " and " + e.getName() + " with weight " + this.weight.toString());
    }

    public Arc(Node s, Node e, Integer i) {
        this.start = s;
        this.end = e;
        this.comment = null;
        this.weight = i;
        this.setName('a', number++);
        this.boxX = (this.start.getX() + this.end.getX()) / 2 - 3;
        this.boxY = (this.start.getY() + this.end.getY()) / 2 - 3;
        System.out.println("Created a new arc between " + s.getName() + " and " + e.getName() + " with weight " + this.weight.toString());
    }

    public boolean boxContains(int m, int n) {
        int xmin = this.boxX;
        int xmax = this.boxX + 7;
        int ymin = this.boxY;
        int ymax = this.boxY + 7;
        return xmin < m && xmax > m && ymin < n && ymax > n;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.setColor(Color.black);
        g2.drawLine(this.start.getX(), this.start.getY(), this.boxX + 3, this.boxY + 3);
        g2.drawLine(this.boxX + 3, this.boxY + 3, this.end.getX(), this.end.getY());
        g2.fillRect(this.boxX, this.boxY, 7, 7);
        double xLength = this.end.getX() - (this.boxX + 3);
        double yLength = this.end.getY() - (this.boxY + 3);
        double theta = Math.atan2(yLength, xLength);
        theta = Math.toDegrees(theta);
        double angleMinusTheta = 45.0 - theta;
        double alpha = 45.0 - theta;
        alpha = Math.toRadians(alpha);
        theta = Math.toRadians(theta);
        angleMinusTheta = Math.toRadians(angleMinusTheta);
        double tipX = (double)this.end.getX() - 17.0 * xLength / Math.sqrt(yLength * yLength + xLength * xLength);
        double tipY = (double)this.end.getY() - 17.0 * yLength / Math.sqrt(yLength * yLength + xLength * xLength);
        double endX1 = tipX - 7.0 * Math.sin(alpha);
        double endY1 = tipY - 7.0 * Math.cos(alpha);
        double endX2 = tipX - 7.0 * Math.cos(angleMinusTheta);
        double endY2 = tipY + 7.0 * Math.sin(angleMinusTheta);
        g2.drawLine((int)tipX, (int)tipY, (int)endX1, (int)endY1);
        g2.drawLine((int)tipX, (int)tipY, (int)endX2, (int)endY2);
        if (this.weight > 1) {
            g2.drawString(this.weight.toString(), this.boxX - 15, this.boxY + 20);
        }
    }

    public void setStart(Node n) {
        this.start = n;
    }

    public void setEnd(Node n) {
        this.end = n;
    }

    public void setBoxX(int x) {
        this.boxX = x;
    }

    public void setBoxY(int y) {
        this.boxY = y;
    }

    public void setWeight(Integer i) {
        this.weight = i;
    }

    public void setNumber(int i) {
        number = i;
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public int getBoxX() {
        return this.boxX;
    }

    public int getBoxY() {
        return this.boxY;
    }

    private int getArrowX() {
        return (this.boxX + this.end.getX()) / 2;
    }

    private int getArrowY() {
        return (this.boxY + this.end.getY()) / 2;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public int calcBoxX() {
        return (this.start.getX() + this.end.getX()) / 2 - 3;
    }

    public int calcBoxY() {
        return (this.start.getY() + this.end.getY()) / 2 - 3;
    }
}

