/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.petrinet;

import java.awt.Graphics2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.ed.inf.pepa.jhydra.evaluator.ExpressionEvaluator;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Arc;
import uk.ac.ed.inf.pepa.jhydra.petrinet.ImmediateTransition;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Marking;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Node;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Place;
import uk.ac.ed.inf.pepa.jhydra.petrinet.TimedTransition;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Transition;

public class PetriNet
implements Serializable {
    private Vector<Place> places = new Vector(0, 1);
    private Vector<ImmediateTransition> immediateTransitions = new Vector(0, 1);
    private Vector<TimedTransition> timedTransitions = new Vector(0, 1);
    private Vector<Arc> arcs = new Vector(0, 1);
    private ExpressionEvaluator expressEval;
    private Hashtable<String, Double> constants;
    private Vector marking = new Vector(0, 1);
    private static Stack trace;

    public PetriNet() {
        this.expressEval = new ExpressionEvaluator();
    }

    public String openXML(String fileName) {
        return "Opened " + fileName;
    }

    public String saveAsXML(String fileName) {
        this.saveMarking();
        try {
            FileWriter out = new FileWriter(fileName);
            out.write("<?xml version=\"1.0\"?>");
            this.format(out, 1);
            out.write("<net id=\"n1\" type=\"null\">");
            this.format(out, 2);
            out.write("<name>");
            this.format(out, 3);
            out.write("<value>" + fileName + "</value>");
            this.format(out, 2);
            out.write("</name>");
            out.write(13);
            this.format(out, 2);
            int count = 0;
            while (count < this.places.size()) {
                Place p = this.places.get(count);
                out.write("<place id=\"" + p.getName() + "\">");
                this.format(out, 3);
                out.write("<graphics>");
                this.format(out, 4);
                out.write("<position x=\"" + p.getX() + "\" y=\"" + p.getY() + "\" />");
                this.format(out, 3);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("<name>");
                this.format(out, 4);
                out.write("<value>" + p.getComment() + "</value>");
                this.format(out, 4);
                out.write("<graphics>");
                this.format(out, 5);
                out.write("<offset x=\"-15\" y=\"-15\" />");
                this.format(out, 4);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("</name>");
                this.format(out, 3);
                out.write("<initialMarking>");
                this.format(out, 4);
                out.write("<value>" + p.getNOT() + "</value>");
                this.format(out, 4);
                out.write("<graphics>");
                this.format(out, 5);
                out.write("<offset x=\"0\" y=\"0\" />");
                this.format(out, 4);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("</initialMarking>");
                this.format(out, 2);
                out.write("</place>");
                out.write(13);
                this.format(out, 2);
                ++count;
            }
            count = 0;
            while (count < this.immediateTransitions.size()) {
                ImmediateTransition iT = this.immediateTransitions.get(count);
                out.write("<transition id=\"" + iT.getName() + "\" type=\"immediate\" weight=\"" + iT.getWeight() + "\">");
                this.format(out, 3);
                out.write("<graphics>");
                this.format(out, 4);
                out.write("<position x=\"" + iT.getX() + "\" y=\"" + iT.getY() + "\" />");
                this.format(out, 3);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("<name>");
                this.format(out, 4);
                out.write("<value>" + iT.getComment() + "</value>");
                this.format(out, 4);
                out.write("<graphics>");
                this.format(out, 5);
                out.write("<offset x=\"-15\" y=\"-15\" />");
                this.format(out, 4);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("</name>");
                this.format(out, 2);
                out.write("</transition>");
                out.write(13);
                this.format(out, 2);
                ++count;
            }
            count = 0;
            while (count < this.timedTransitions.size()) {
                TimedTransition tT = this.timedTransitions.get(count);
                out.write("<transition id=\"" + tT.getName() + "\" type=\"timed\" distribution=\"exponential\" rate=\"" + tT.getRate() + "\">");
                this.format(out, 3);
                out.write("<graphics>");
                this.format(out, 4);
                out.write("<position x=\"" + tT.getX() + "\" y=\"" + tT.getY() + "\" />");
                this.format(out, 3);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("<name>");
                this.format(out, 4);
                out.write("<value>" + tT.getComment() + "</value>");
                this.format(out, 4);
                out.write("<graphics>");
                this.format(out, 5);
                out.write("<offset x=\"-15\" y=\"-15\" />");
                this.format(out, 4);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("</name>");
                this.format(out, 2);
                out.write("</transition>");
                out.write(13);
                this.format(out, 2);
                ++count;
            }
            count = 0;
            while (count < this.arcs.size()) {
                Arc a = this.arcs.get(count);
                Node s = a.getStart();
                Node e = a.getEnd();
                out.write("<arc id=\"" + a.getName() + "\" source=\"" + s.getName() + "\" target=\"" + e.getName() + "\">");
                this.format(out, 3);
                out.write("<graphics>");
                this.format(out, 4);
                out.write("<position x=\"" + a.getBoxX() + "\" y=\"" + a.getBoxY() + "\"/>");
                this.format(out, 3);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("<inscription>");
                this.format(out, 4);
                out.write("<value>" + a.getWeight() + "</value>");
                this.format(out, 4);
                out.write("<graphics>");
                this.format(out, 5);
                out.write("<offset x=\"-15\" y=\"+20\"/>");
                this.format(out, 4);
                out.write("</graphics>");
                this.format(out, 3);
                out.write("</inscription>");
                this.format(out, 2);
                out.write("</arc>");
                out.write(13);
                this.format(out, 2);
                ++count;
            }
            this.format(out, 1);
            out.write("</net>");
            out.close();
        }
        catch (IOException iOException) {
            return "Error saving " + fileName;
        }
        return "Saved " + fileName;
    }

    public void addPlace(int x, int y, int factor) {
        Place place = new Place(this.round(x, factor), this.round(y, factor), this);
        this.places.addElement(place);
    }

    public void addPlace(String s) {
        Place place = new Place(s);
        this.places.add(place);
    }

    public void addImmediateTransition(int x, int y, int factor) {
        ImmediateTransition iT = new ImmediateTransition(this.round(x, factor), this.round(y, factor), this);
        this.immediateTransitions.addElement(iT);
    }

    public ImmediateTransition addImmediateTransition(String name, String weight, String condition) {
        ImmediateTransition iT = new ImmediateTransition(name, weight, this, condition);
        this.immediateTransitions.addElement(iT);
        return iT;
    }

    public void addTimedTransition(int x, int y, int factor) {
        TimedTransition tT = new TimedTransition(this.round(x, factor), this.round(y, factor), this);
        this.timedTransitions.addElement(tT);
    }

    public TimedTransition addTimedTransition(String name, String rate, String condition) {
        TimedTransition tT = new TimedTransition(name, rate, this, condition);
        this.timedTransitions.addElement(tT);
        return tT;
    }

    public void addArc(Node s, Node e) {
        Arc a = new Arc(s, e);
        this.arcs.addElement(a);
    }

    public void addArc(Node s, Node e, Integer i) {
        Arc a = new Arc(s, e, i);
        this.arcs.addElement(a);
    }

    public void addArc(int sx, int sy, int ex, int ey, int which) {
        switch (which) {
            case 1: {
                Place p = this.getPlace(sx, sy);
                Transition t = this.getTransition(ex, ey);
                Arc arc = new Arc(p, t);
                this.arcs.addElement(arc);
                break;
            }
            case 2: {
                Transition t = this.getTransition(sx, sy);
                Place p = this.getPlace(ex, ey);
                Arc arc = new Arc(t, p);
                this.arcs.addElement(arc);
            }
        }
    }

    public boolean isEnabled(Marking currentMarking, Transition t) {
        this.setMarking(currentMarking);
        return t.isEnabled();
    }

    public Marking fire(Marking currentMarking, Transition t) {
        this.setMarking(currentMarking);
        t.fire();
        return this.getMarking();
    }

    public void setConstants(Hashtable<String, Double> c) {
        this.constants = c;
    }

    public String conditionValue(String cond, Marking m) {
        this.expressEval.addSpace(cond);
        StringTokenizer s = new StringTokenizer(cond);
        String symbol = "";
        while (s.hasMoreTokens()) {
            symbol = s.nextToken();
            if (this.constants.containsKey(symbol)) {
                Double value = this.constants.get(symbol);
                cond = cond.replace(" " + symbol + " ", " " + value.toString() + " ");
                continue;
            }
            Place p = null;
            int count = 0;
            while (count < this.places.size()) {
                p = this.places.get(count);
                if (p.getName().equals(symbol)) break;
                p = null;
                ++count;
            }
            if (p == null) continue;
            Double value = m.getElement(count).doubleValue();
            cond = cond.replace(" " + symbol + " ", " " + value.toString() + " ");
        }
        String evalResult = this.expressEval.evaluate(cond).toLowerCase();
        return evalResult;
    }

    public boolean conditionHolds(String cond, Marking m) {
        this.expressEval.addSpace(cond);
        StringTokenizer s = new StringTokenizer(cond);
        String symbol = "";
        while (s.hasMoreTokens()) {
            symbol = s.nextToken();
            if (this.constants.containsKey(symbol)) {
                Double value = this.constants.get(symbol);
                cond = cond.replace(" " + symbol, " " + value.toString());
                continue;
            }
            Place p = null;
            int count = 0;
            while (count < this.places.size()) {
                p = this.places.get(count);
                if (p.getName().equals(symbol)) break;
                p = null;
                ++count;
            }
            if (p == null) continue;
            Double value = m.getElement(count).doubleValue();
            cond = cond.replace(" " + symbol + " ", " " + value.toString() + " ");
        }
        String evalResult = this.expressEval.evaluate(cond).toLowerCase();
        if (evalResult.equals("true")) {
            return true;
        }
        if (evalResult.equals("false")) {
            return false;
        }
        System.out.println("ERROR: Condition evaluates to <" + evalResult + "> which is neither true nor false...");
        System.exit(-1);
        return false;
    }

    public boolean manualAnimate(int x, int y) {
        Transition t = this.getTransition(x, y);
        if (t != null) {
            return t.fire();
        }
        return false;
    }

    public boolean undoFiring() {
        if (trace != null && !trace.empty()) {
            String name = (String)trace.pop();
            Transition t = this.getTransition(name);
            if (t != null) {
                return t.unFire();
            }
            return false;
        }
        return false;
    }

    public void changeTokens(int x, int y, int amount) {
        Place p = this.getPlace(x, y);
        if (p != null) {
            p.alterMyTokens(amount);
        }
    }

    public void setTokens(String pName, int amount) {
        Place p = this.getPlace(pName);
        if (p != null) {
            p.setTokens(amount);
        }
    }

    public void deleteElement(int x, int y) {
        Place p = this.getPlace(x, y);
        ImmediateTransition iT = this.getImmediateTransition(x, y);
        TimedTransition tT = this.getTimedTransition(x, y);
        Arc a = this.getArc(x, y);
        boolean check = false;
        int m = -1;
        int n = -1;
        if (p != null) {
            m = p.getX();
            n = p.getY();
            check = this.places.remove(p);
        } else if (iT != null) {
            m = iT.getX();
            n = iT.getY();
            check = this.immediateTransitions.remove(iT);
        } else if (tT != null) {
            m = tT.getX();
            n = tT.getY();
            check = this.timedTransitions.remove(tT);
        } else if (a != null) {
            this.arcs.remove(a);
        }
        if (check) {
            this.deleteArcs(m, n);
        }
    }

    public void saveMarking() {
        this.marking = new Vector(0, 1);
        trace = new Stack();
        int count = 0;
        while (count < this.places.size()) {
            Place place = this.places.get(count);
            Integer x = new Integer(place.getNOT());
            this.marking.addElement(x);
            ++count;
        }
    }

    public void restoreMarking() {
        int count = 0;
        while (count < this.marking.size()) {
            Place place = this.places.get(count);
            Integer x = (Integer)this.marking.get(count);
            place.alterMyTokens(x - place.getNOT());
            ++count;
        }
        trace = null;
    }

    public void setMarking(Marking m) {
        int count = 0;
        while (count < this.getNumberOfPlaces()) {
            Place p = this.places.get(count);
            Integer x = m.getElement(count);
            p.setTokens(x);
            ++count;
        }
    }

    public Marking getMarking() {
        Integer[] m = new Integer[this.getNumberOfPlaces()];
        int count = 0;
        while (count < this.getNumberOfPlaces()) {
            Integer x;
            Place p = this.places.get(count);
            m[count] = x = new Integer(p.getNOT());
            ++count;
        }
        Marking marking = new Marking(m);
        return marking;
    }

    public void moveElementsOntoGrid(int gS) {
        int y;
        int x;
        int count = 0;
        while (count < this.places.size()) {
            Place p = this.getPlace(count);
            x = this.round(p.getX(), gS);
            y = this.round(p.getY(), gS);
            p.moveNode(x, y);
            ++count;
        }
        int count2 = 0;
        while (count2 < this.immediateTransitions.size()) {
            ImmediateTransition iT = this.getImmediateTransition(count2);
            x = this.round(iT.getX(), gS);
            y = this.round(iT.getY(), gS);
            iT.moveNode(x, y);
            ++count2;
        }
        int count3 = 0;
        while (count3 < this.timedTransitions.size()) {
            TimedTransition tT = this.getTimedTransition(count3);
            x = this.round(tT.getX(), gS);
            y = this.round(tT.getY(), gS);
            tT.moveNode(x, y);
            ++count3;
        }
        int count4 = 0;
        while (count4 < this.arcs.size()) {
            Arc a = this.getArc(count4);
            x = a.calcBoxX();
            y = a.calcBoxY();
            a.setBoxX(x);
            a.setBoxY(y);
            ++count4;
        }
    }

    public Marking getCurrentMarking() {
        Integer[] currMarkingVector = new Integer[this.getNumberOfPlaces()];
        int i = 0;
        while (i < this.getNumberOfPlaces()) {
            currMarkingVector[i] = new Integer(this.getPlace(i).getNOT());
            ++i;
        }
        Marking currMarking = new Marking(currMarkingVector);
        return currMarking;
    }

    public Place getPlace(int x, int y) {
        int count = 0;
        while (count < this.places.size()) {
            Place place = this.places.get(count);
            if (place.contains(x, y)) {
                return place;
            }
            ++count;
        }
        return null;
    }

    public Place getPlace(int n) {
        return this.places.get(n);
    }

    public Place getPlace(String name) {
        int count = 0;
        while (count < this.places.size()) {
            Place p = this.places.get(count);
            if (p.getName().equals(name)) {
                return p;
            }
            ++count;
        }
        return null;
    }

    public Transition getTransition(int x, int y) {
        int count = 0;
        while (count < this.immediateTransitions.size()) {
            Transition T1 = this.immediateTransitions.get(count);
            if (T1.contains(x, y)) {
                return T1;
            }
            ++count;
        }
        int count2 = 0;
        while (count2 < this.timedTransitions.size()) {
            Transition T2 = this.timedTransitions.get(count2);
            if (T2.contains(x, y)) {
                return T2;
            }
            ++count2;
        }
        return null;
    }

    public Transition getTransition(String name) {
        int count = 0;
        while (count < this.immediateTransitions.size()) {
            Transition T1 = this.immediateTransitions.get(count);
            if (T1.getName().equals(name)) {
                return T1;
            }
            ++count;
        }
        int count2 = 0;
        while (count2 < this.timedTransitions.size()) {
            Transition T2 = this.timedTransitions.get(count2);
            if (T2.getName().equals(name)) {
                return T2;
            }
            ++count2;
        }
        return null;
    }

    public ImmediateTransition getImmediateTransition(int x, int y) {
        int count = 0;
        while (count < this.immediateTransitions.size()) {
            ImmediateTransition iT = this.immediateTransitions.get(count);
            if (iT.contains(x, y)) {
                return iT;
            }
            ++count;
        }
        return null;
    }

    public ImmediateTransition getImmediateTransition(int n) {
        return this.immediateTransitions.get(n);
    }

    public TimedTransition getTimedTransition(int x, int y) {
        int count = 0;
        while (count < this.timedTransitions.size()) {
            TimedTransition tT = this.timedTransitions.get(count);
            if (tT.contains(x, y)) {
                return tT;
            }
            ++count;
        }
        return null;
    }

    public TimedTransition getTimedTransition(int n) {
        return this.timedTransitions.get(n);
    }

    public Arc getArc(int x, int y) {
        int count = 0;
        while (count < this.arcs.size()) {
            Arc arc = this.arcs.get(count);
            if (arc.boxContains(x, y)) {
                return arc;
            }
            ++count;
        }
        return null;
    }

    public Arc getArc(int n) {
        return this.arcs.get(n);
    }

    public Node getNode(String name) {
        int count = 0;
        while (count < this.places.size()) {
            Node p = this.places.get(count);
            if (p.getName().equals(name)) {
                return p;
            }
            ++count;
        }
        int count2 = 0;
        while (count2 < this.immediateTransitions.size()) {
            Node iT = this.immediateTransitions.get(count2);
            if (iT.getName().equals(name)) {
                return iT;
            }
            ++count2;
        }
        int count3 = 0;
        while (count3 < this.timedTransitions.size()) {
            Node tT = this.timedTransitions.get(count3);
            if (tT.getName().equals(name)) {
                return tT;
            }
            ++count3;
        }
        return null;
    }

    public Stack getTrace() {
        return trace;
    }

    public void rotateTransition(int x, int y) {
        Transition t = this.getTransition(x, y);
        if (t != null) {
            t.rotate();
        }
    }

    private void deleteArcs(int x, int y) {
        int count = 0;
        while (count < this.arcs.size()) {
            Arc arc = this.arcs.get(count);
            if (arc.getStart().getX() == x && arc.getStart().getY() == y || arc.getEnd().getX() == x && arc.getEnd().getY() == y) {
                this.arcs.remove(arc);
                this.deleteArcs(x, y);
            }
            ++count;
        }
    }

    public void addToTrace(String transName) {
        trace.push(transName);
    }

    public void drawArcs(Graphics2D g2) {
        int count = 0;
        while (count < this.arcs.size()) {
            Arc arc = this.arcs.get(count);
            arc.draw(g2);
            ++count;
        }
    }

    public void drawPlaces(Graphics2D g2) {
        int count = 0;
        while (count < this.places.size()) {
            Place place = this.places.get(count);
            place.draw(g2);
            ++count;
        }
    }

    public void drawTransitions(Graphics2D g2) {
        int count = 0;
        while (count < this.immediateTransitions.size()) {
            ImmediateTransition iT = this.immediateTransitions.get(count);
            iT.draw(g2);
            ++count;
        }
        count = 0;
        while (count < this.timedTransitions.size()) {
            TimedTransition tT = this.timedTransitions.get(count);
            tT.draw(g2);
            ++count;
        }
    }

    private String convertToFileURL(String fileName) {
        try {
            String path = new File(fileName).toURL().toString();
            return path;
        }
        catch (MalformedURLException mue) {
            System.out.println(mue);
            return null;
        }
    }

    private int round(int value, int toWhat) {
        if (value % toWhat == 0) {
            return value;
        }
        if (value % toWhat < 10) {
            value -= value % toWhat;
            return value;
        }
        value += toWhat - value % toWhat;
        return value;
    }

    private void format(FileWriter fW, int numberOfTabs) {
        try {
            fW.write(13);
            int count = 0;
            while (count < numberOfTabs) {
                fW.write(9);
                ++count;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public boolean emptyTrace() {
        if (trace != null) {
            return trace.empty();
        }
        return true;
    }

    public int getNumberOfPlaces() {
        return this.places.size();
    }

    public int getNumberOfTransitions() {
        return this.immediateTransitions.size() + this.timedTransitions.size();
    }

    public int getNumberOfImmTransitions() {
        return this.immediateTransitions.size();
    }

    public int getNumberOfTimedTransitions() {
        return this.timedTransitions.size();
    }

    public int getNumberOfArcs() {
        return this.arcs.size();
    }

    public boolean isAnimating() {
        return false;
    }
}

