/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.jhydra.petrinet;

import java.awt.Color;
import java.awt.Graphics2D;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Arc;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Node;
import uk.ac.ed.inf.pepa.jhydra.petrinet.PetriNet;
import uk.ac.ed.inf.pepa.jhydra.petrinet.Place;

public abstract class Transition
extends Node {
    private static int number = 1;
    private static final char character = 't';
    protected double priority = 1.0;
    protected String enablingCondition;

    public Transition(int x, int y, PetriNet pn) {
        super(x, y, 27, 13, pn);
        this.setName('t', number++);
    }

    public Transition(String n, PetriNet pn, String c) {
        super(n, pn);
        this.enablingCondition = c;
    }

    public boolean fire() {
        if (this.isEnabled()) {
            int count = 0;
            while (count < this.myPN.getNumberOfArcs()) {
                Place p;
                Arc arc = this.myPN.getArc(count);
                if (arc != null && arc.getEnd() == this && (p = (Place)arc.getStart()) != null) {
                    p.alterMyTokens(-arc.getWeight().intValue());
                }
                ++count;
            }
            int count2 = 0;
            while (count2 < this.myPN.getNumberOfArcs()) {
                Place p2;
                Arc arc2 = this.myPN.getArc(count2);
                if (arc2 != null && arc2.getStart() == this && (p2 = (Place)arc2.getEnd()) != null) {
                    p2.alterMyTokens(arc2.getWeight());
                }
                ++count2;
            }
            if (this.myPN.getTrace() != null) {
                this.myPN.addToTrace(this.name);
                return true;
            }
        }
        return false;
    }

    public boolean unFire() {
        int count = 0;
        while (count < this.myPN.getNumberOfArcs()) {
            Place p;
            Arc arc = this.myPN.getArc(count);
            if (arc != null && arc.getEnd().getX() == this.centreX && arc.getEnd().getY() == this.centreY && (p = this.myPN.getPlace(arc.getStart().getX(), arc.getStart().getY())) != null) {
                p.alterMyTokens(arc.getWeight());
            }
            ++count;
        }
        int count2 = 0;
        while (count2 < this.myPN.getNumberOfArcs()) {
            Place p2;
            Arc arc2 = this.myPN.getArc(count2);
            if (arc2 != null && arc2.getStart().getX() == this.getX() && arc2.getStart().getY() == this.getY() && (p2 = this.myPN.getPlace(arc2.getEnd().getX(), arc2.getEnd().getY())) != null) {
                p2.alterMyTokens(-arc2.getWeight().intValue());
            }
            ++count2;
        }
        return true;
    }

    public abstract boolean isEnabled();

    protected boolean checkInputArcs() {
        int count = 0;
        while (count < this.myPN.getNumberOfArcs()) {
            Place p;
            Arc arc = this.myPN.getArc(count);
            if (arc != null && arc.getEnd() == this && (p = (Place)arc.getStart()) != null && p.getNOT() < arc.getWeight()) {
                return false;
            }
            ++count;
        }
        return true;
    }

    public void rotate() {
        System.out.println("Rotating transition");
        int temp = this.width;
        this.width = this.height;
        this.height = temp;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.setColor(Color.black);
        g2.fillRect(this.centreX - this.width / 2, this.centreY - this.height / 2, this.width, this.height);
        g2.drawString(this.name, this.centreX - 15, this.centreY - 15);
        if (this.myPN.isAnimating() && this.isEnabled()) {
            g2.setColor(Color.red);
            g2.fillRect(this.centreX - this.width / 2 + 1, this.centreY - this.height / 2 + 1, this.width - 2, this.height - 2);
        }
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int n) {
        number = n;
    }
}

