/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale;

import com.sun.org.apache.xalan.internal.xsltc.util.IntegerArray;
import java.util.Arrays;
import java.util.Map;
import uk.ac.ed.inf.pepa.largescale.CapacityUtilisationCalculation;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.EvaluatorVisitor;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class AverageResponseTimeCalculation {
    private IParametricDerivationGraph derivationGraph;
    private int[] inSystemIndices;
    private int[] outSystemIndices;

    public AverageResponseTimeCalculation(int componentIndex, int[] inSystemIndices, IParametricDerivationGraph derivationGraph) {
        if (derivationGraph == null) {
            throw new NullPointerException("Null pointer to derivation graph");
        }
        if (componentIndex < 0 || componentIndex > derivationGraph.getSequentialComponents().length - 1) {
            throw new IllegalArgumentException("Illegal component index");
        }
        if (inSystemIndices.length <= 0) {
            throw new IllegalArgumentException("At least one component must be in the system");
        }
        System.err.println("comp index: " + componentIndex);
        System.err.print("in index:");
        int[] nArray = inSystemIndices;
        int n = inSystemIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            System.err.println(" " + k + " ");
            ++n2;
        }
        this.derivationGraph = derivationGraph;
        this.inSystemIndices = inSystemIndices;
        boolean[] foundInIndex = new boolean[inSystemIndices.length];
        Arrays.fill(foundInIndex, false);
        IntegerArray out = new IntegerArray(10);
        ISequentialComponent c = derivationGraph.getSequentialComponents()[componentIndex];
        for (Map.Entry<Short, Coordinate> entry : c.getComponentMapping()) {
            int coordinate = entry.getValue().getCoordinate();
            boolean coordinateFound = false;
            int i = 0;
            while (i < inSystemIndices.length) {
                if (inSystemIndices[i] == coordinate) {
                    if (foundInIndex[i]) {
                        throw new IllegalArgumentException("Replicated indices in the insystem array");
                    }
                    foundInIndex[i] = true;
                    coordinateFound = true;
                    break;
                }
                ++i;
            }
            if (coordinateFound) continue;
            out.add(coordinate);
        }
        Object[] objectArray = foundInIndex;
        int n3 = foundInIndex.length;
        int n4 = 0;
        while (n4 < n3) {
            boolean b = objectArray[n4];
            if (!b) {
                throw new IllegalArgumentException("Index not found");
            }
            ++n4;
        }
        this.outSystemIndices = out.toIntArray();
        AverageResponseTimeCalculation.debug("InSystem:");
        objectArray = inSystemIndices;
        n3 = inSystemIndices.length;
        n4 = 0;
        while (n4 < n3) {
            int i = objectArray[n4];
            AverageResponseTimeCalculation.debug("" + i);
            ++n4;
        }
        AverageResponseTimeCalculation.debug("OutSystem:");
        objectArray = this.outSystemIndices;
        n3 = this.outSystemIndices.length;
        n4 = 0;
        while (n4 < n3) {
            int i = objectArray[n4];
            AverageResponseTimeCalculation.debug("" + i);
            ++n4;
        }
    }

    public IPointEstimator getUsersInSystemEstimator() {
        return new IPointEstimator(){

            @Override
            public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
                double usersInSystem = 0.0;
                int i = 0;
                while (i < AverageResponseTimeCalculation.this.inSystemIndices.length) {
                    usersInSystem += solution[AverageResponseTimeCalculation.this.inSystemIndices[i]];
                    ++i;
                }
                return usersInSystem;
            }
        };
    }

    public IPointEstimator getIncomingThroughputEstimator() {
        return new IPointEstimator(){

            @Override
            public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
                double inletThroughput = 0.0;
                IGeneratingFunction[] iGeneratingFunctionArray = AverageResponseTimeCalculation.this.derivationGraph.getGeneratingFunctions();
                int n = iGeneratingFunctionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGeneratingFunction f = iGeneratingFunctionArray[n2];
                    if (CapacityUtilisationCalculation.isLocalJump(AverageResponseTimeCalculation.this.outSystemIndices, f.getJump()) && CapacityUtilisationCalculation.isIncompingJump(AverageResponseTimeCalculation.this.inSystemIndices, f.getJump())) {
                        inletThroughput += new EvaluatorVisitor(f.getRate(), solution).getResult();
                    }
                    ++n2;
                }
                return inletThroughput;
            }
        };
    }

    private static void debug(String message) {
    }
}

