/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale;

import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.IntegerArray;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.EvaluatorVisitor;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class CapacityUtilisationCalculation
implements IPointEstimator {
    private ISequentialComponent component;
    private IParametricDerivationGraph graph;
    private int[] indices;

    public CapacityUtilisationCalculation(int componentIndex, IParametricDerivationGraph graph) {
        int maxIndex = graph.getSequentialComponents().length - 1;
        if (componentIndex > maxIndex) {
            throw new IllegalArgumentException("Bad component index. Maximum is " + maxIndex);
        }
        this.component = graph.getSequentialComponents()[componentIndex];
        this.graph = graph;
        IntegerArray involvedIndices = new IntegerArray(graph.getInitialState().length);
        for (Map.Entry<Short, Coordinate> entry : this.component.getComponentMapping()) {
            involvedIndices.add(entry.getValue().getCoordinate());
        }
        this.indices = involvedIndices.toArray();
    }

    @Override
    public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
        double currentUtilisation = 0.0;
        IGeneratingFunction[] iGeneratingFunctionArray = this.graph.getGeneratingFunctions();
        int n = iGeneratingFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGeneratingFunction f = iGeneratingFunctionArray[n2];
            if (CapacityUtilisationCalculation.isLocalJump(this.indices, f.getJump())) {
                currentUtilisation += new EvaluatorVisitor(f.getRate(), solution).getResult();
            }
            ++n2;
        }
        double denominator = 0.0;
        short[] sArray = this.component.getActionAlphabet();
        int n3 = sArray.length;
        int n4 = 0;
        while (n4 < n3) {
            short s = sArray[n4];
            denominator += new EvaluatorVisitor(this.component.getApparentRate(s), solution).getResult();
            ++n4;
        }
        return currentUtilisation / denominator;
    }

    static boolean isLocalJump(int[] indices, short[] jump) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (jump[i] == -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean isIncompingJump(int[] indices, short[] jump) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (jump[i] == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

