/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.expressions;

import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.DivisionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.Expression;
import uk.ac.ed.inf.pepa.largescale.expressions.ExpressionVisitor;
import uk.ac.ed.inf.pepa.largescale.expressions.MinimumExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.MultiplicationExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.RateExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SubtractionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SummationExpression;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class CopyOfEvaluatorVisitor
implements ExpressionVisitor {
    private double[] state;
    private double result = 0.0;

    public CopyOfEvaluatorVisitor(Expression expression, double[] currentState) throws DifferentialAnalysisException {
        if (expression == null) {
            throw new NullPointerException("Exception cannot be null");
        }
        if (currentState == null) {
            throw new NullPointerException("State cannot be null");
        }
        if (currentState.length == 0) {
            throw new IllegalArgumentException("State must have at least one coordinate");
        }
        this.state = currentState;
        expression.accept(this);
    }

    public double getResult() {
        return this.result;
    }

    @Override
    public void visitCoordinate(Coordinate coordinate) throws DifferentialAnalysisException {
        int index = coordinate.getCoordinate();
        if (this.state.length < index + 1) {
            throw new DifferentialAnalysisException("Cannot accept state to evaluate. Too short.");
        }
        this.result = this.state[index];
    }

    @Override
    public void visitDivisionExpression(DivisionExpression div) throws DifferentialAnalysisException {
        CopyOfEvaluatorVisitor lhs = new CopyOfEvaluatorVisitor(div.getLhs(), this.state);
        CopyOfEvaluatorVisitor rhs = new CopyOfEvaluatorVisitor(div.getRhs(), this.state);
        this.result = lhs.getResult() == 0.0 && rhs.getResult() == 0.0 ? 1.0 : lhs.getResult() / rhs.getResult();
    }

    @Override
    public void visitMinimumExpression(MinimumExpression min) throws DifferentialAnalysisException {
        CopyOfEvaluatorVisitor lhs = new CopyOfEvaluatorVisitor(min.getLhs(), this.state);
        CopyOfEvaluatorVisitor rhs = new CopyOfEvaluatorVisitor(min.getRhs(), this.state);
        this.result = Math.min(lhs.getResult(), rhs.getResult());
    }

    @Override
    public void visitMultiplicationExpression(MultiplicationExpression mult) throws DifferentialAnalysisException {
        CopyOfEvaluatorVisitor lhs = new CopyOfEvaluatorVisitor(mult.getLhs(), this.state);
        CopyOfEvaluatorVisitor rhs = new CopyOfEvaluatorVisitor(mult.getRhs(), this.state);
        this.result = lhs.getResult() * rhs.getResult();
    }

    @Override
    public void visitRateExpression(RateExpression rate) throws DifferentialAnalysisException {
        this.result = rate.getRate();
    }

    @Override
    public void visitSummationExpression(SummationExpression sum) throws DifferentialAnalysisException {
        CopyOfEvaluatorVisitor lhs = new CopyOfEvaluatorVisitor(sum.getLhs(), this.state);
        CopyOfEvaluatorVisitor rhs = new CopyOfEvaluatorVisitor(sum.getRhs(), this.state);
        this.result = lhs.getResult() + rhs.getResult();
    }

    @Override
    public void visitSubtractionExpression(SubtractionExpression subtractionExpression) {
        throw new IllegalStateException();
    }
}

