/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.internal;

import java.util.Map;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.SequentialComponentData;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricComponent;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricOperator;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricStructuralElement;
import uk.ac.ed.inf.pepa.largescale.internal.ParametricTransition;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class ParametricStateExplorer {
    ParametricComponent[] sequentialComponents;
    ParametricOperator[] operators;
    SequentialComponentData[] sequentialComponentInfo;
    short[] initialVector;
    short[] processMappings;
    int problemSize;

    ParametricStateExplorer() {
    }

    public int getProblemSize() {
        return this.problemSize;
    }

    public short[] getProcessMappings() {
        return this.processMappings;
    }

    public ParametricComponent[] getSequentialComponents() {
        return this.sequentialComponents;
    }

    public void init() {
        ParametricStructuralElement c;
        int coordinateIndex = 0;
        ParametricStructuralElement[] parametricStructuralElementArray = this.sequentialComponents;
        int n = this.sequentialComponents.length;
        int n2 = 0;
        while (n2 < n) {
            c = parametricStructuralElementArray[n2];
            ((ParametricComponent)c).init(this);
            coordinateIndex = ((ParametricComponent)c).setupCoordinateIndexes(coordinateIndex);
            ++n2;
        }
        parametricStructuralElementArray = this.operators;
        n = this.operators.length;
        n2 = 0;
        while (n2 < n) {
            ParametricStructuralElement o = parametricStructuralElementArray[n2];
            o.init(this);
            ++n2;
        }
        this.problemSize = coordinateIndex;
        this.processMappings = new short[this.problemSize];
        parametricStructuralElementArray = this.sequentialComponents;
        n = this.sequentialComponents.length;
        n2 = 0;
        while (n2 < n) {
            c = parametricStructuralElementArray[n2];
            for (Map.Entry<Short, Coordinate> entry : ((ParametricComponent)c).getComponentMapping()) {
                this.processMappings[entry.getValue().getCoordinate()] = entry.getKey();
            }
            ++n2;
        }
    }

    public void dispose() {
    }

    public void debug() {
        System.out.println("List of components:");
        ParametricStructuralElement[] parametricStructuralElementArray = this.sequentialComponents;
        int n = this.sequentialComponents.length;
        int n2 = 0;
        while (n2 < n) {
            ParametricComponent c = parametricStructuralElementArray[n2];
            System.out.println(c.toString());
            ++n2;
        }
        System.out.println("List of operators:");
        parametricStructuralElementArray = this.operators;
        n = this.operators.length;
        n2 = 0;
        while (n2 < n) {
            ParametricStructuralElement o = parametricStructuralElementArray[n2];
            System.out.println(((ParametricOperator)o).toString());
            ++n2;
        }
    }

    public ParametricTransition[] exploreState(short[] state) throws DifferentialAnalysisException {
        ParametricComponent[] parametricComponentArray = this.sequentialComponents;
        int n = this.sequentialComponents.length;
        int n2 = 0;
        while (n2 < n) {
            ParametricComponent c = parametricComponentArray[n2];
            c.compose(state);
            ++n2;
        }
        int i = this.operators.length - 1;
        while (i >= 0) {
            this.operators[i].compose(state);
            --i;
        }
        if (this.operators.length == 0) {
            return this.sequentialComponents[0].getDerivatives();
        }
        return this.operators[0].getDerivatives();
    }

    public SequentialComponentData getData(short processId) {
        return this.sequentialComponentInfo[processId];
    }
}

