/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.simulation;

import uk.ac.ed.inf.pepa.largescale.simulation.AbstractStochasticSimulation;
import uk.ac.ed.inf.pepa.largescale.simulation.IConvergenceChecker;

class DefaultConvergenceChecker
implements IConvergenceChecker {
    DefaultConvergenceChecker() {
    }

    @Override
    public double computeConvergenceError(AbstractStochasticSimulation simulation) {
        double maximumConfidenceInterval = Double.MIN_VALUE;
        double[] ci = new double[2];
        int i = 0;
        while (i < simulation.getNumberOfObservers()) {
            int j = 0;
            while (j < simulation.getNumberOfTimePoints()) {
                simulation.confidenceInterval(i, j, ci);
                double error = ci[1] / ci[0] * 100.0;
                if (ci[1] == 0.0 && ci[0] == 0.0) {
                    error = 0.0;
                }
                maximumConfidenceInterval = Math.max(maximumConfidenceInterval, error);
                ++j;
            }
            ++i;
        }
        return maximumConfidenceInterval;
    }
}

