/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.simulation;

import fern.network.AmountManager;
import fern.network.AnnotationManager;
import fern.network.AnnotationManagerImpl;
import fern.network.Network;
import fern.network.PropensityCalculator;
import fern.simulation.Simulator;
import fern.simulation.algorithm.GillespieEnhanced;
import fern.simulation.observer.Observer;
import java.io.IOException;
import java.util.ArrayList;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.ParametricDerivationGraphBuilder;
import uk.ac.ed.inf.pepa.largescale.expressions.EvaluatorVisitor;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;
import umontreal.iro.lecuyer.stat.Tally;

public class PEPANetwork
implements Network {
    private IParametricDerivationGraph derivationGraph;
    private double[] initialState;
    private PropensityCalculator propensityCalculator;
    private AmountManager amountManager;
    private AnnotationManager annotationManager;
    private ArrayList<int[]> reactants;
    private ArrayList<int[]> products;

    public static void main(String[] args) throws IOException, DifferentialAnalysisException, InterruptedException {
        ModelNode model = (ModelNode)PepaTools.parse(PepaTools.readText(args[0]));
        IParametricDerivationGraph derivationGraph = ParametricDerivationGraphBuilder.createDerivationGraph(model, null);
        PEPANetwork net = new PEPANetwork(derivationGraph);
        GillespieEnhanced sim = new GillespieEnhanced((Network)net);
        final Tally tally1 = new Tally();
        Tally tally2 = new Tally();
        Observer observer = new Observer((Simulator)sim, (Simulator)sim, derivationGraph, tally2){
            private final /* synthetic */ Simulator val$sim;
            private final /* synthetic */ IParametricDerivationGraph val$derivationGraph;
            private final /* synthetic */ Tally val$tally2;
            {
                this.val$sim = simulator;
                this.val$derivationGraph = iParametricDerivationGraph;
                this.val$tally2 = tally2;
                super($anonymous0);
            }

            public void activateReaction(int mu, double tau, Simulator.FireType fireType, int times) {
            }

            public void finished() {
                tally1.add(this.val$sim.getAmount(this.val$derivationGraph.getInitialState().length - 1));
                this.val$tally2.add(this.val$sim.getAmount(this.val$derivationGraph.getInitialState().length - 3));
            }

            public void started() {
            }

            public void step() {
            }

            public void theta(double theta) {
            }
        };
        sim.addObserver(observer);
        long tic = System.currentTimeMillis();
        int i = 0;
        while (i < 100) {
            System.out.println("Sample " + i);
            sim.initialize();
            sim.start(10.0);
            ++i;
        }
        long toc = System.currentTimeMillis() - tic;
        System.out.println(String.valueOf(toc) + ": Average: " + tally1.average());
        System.out.println(String.valueOf(toc) + ": Average: " + tally2.average());
    }

    public PEPANetwork(final IParametricDerivationGraph derivationGraph) {
        this.derivationGraph = derivationGraph;
        this.initialState = derivationGraph.getInitialState();
        this.propensityCalculator = new PropensityCalculator(){
            private final double[] state;
            {
                this.state = new double[PEPANetwork.this.initialState.length];
            }

            public double calculatePropensity(int reaction, AmountManager amount, Simulator sim) {
                double result;
                IGeneratingFunction f = derivationGraph.getGeneratingFunctions()[reaction];
                int i = 0;
                while (i < this.state.length) {
                    this.state[i] = amount.getAmount(i);
                    ++i;
                }
                try {
                    result = new EvaluatorVisitor(f.getRate(), this.state).getResult();
                }
                catch (DifferentialAnalysisException e) {
                    throw new IllegalStateException(e);
                }
                return result;
            }
        };
        this.annotationManager = new AnnotationManagerImpl();
        this.reactants = new ArrayList();
        this.products = new ArrayList();
        int i = 0;
        while (i < derivationGraph.getGeneratingFunctions().length) {
            this.reactants.add(this.getElements(i, -1));
            this.products.add(this.getElements(i, 1));
            ++i;
        }
    }

    public AmountManager getAmountManager() {
        if (this.amountManager == null) {
            this.amountManager = new AmountManager((Network)this);
        }
        return this.amountManager;
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public long getInitialAmount(int species) {
        return (long)this.initialState[species];
    }

    public String getName() {
        return "Pepa Model";
    }

    public int getNumReactions() {
        return this.derivationGraph.getGeneratingFunctions().length;
    }

    public int getNumSpecies() {
        return this.derivationGraph.getInitialState().length;
    }

    public int[] getProducts(int reaction) {
        return this.products.get(reaction);
    }

    public PropensityCalculator getPropensityCalculator() {
        return this.propensityCalculator;
    }

    public int[] getReactants(int reaction) {
        return this.reactants.get(reaction);
    }

    private int[] getElements(int reaction, int k) {
        short[] jump = this.derivationGraph.getGeneratingFunctions()[reaction].getJump();
        int[] products = new int[jump.length];
        int j = 0;
        int i = 0;
        while (i < jump.length) {
            if (jump[i] == k) {
                products[j++] = i;
            }
            ++i;
        }
        int[] result = new int[j];
        System.arraycopy(products, 0, result, 0, j);
        return result;
    }

    public String getReactionName(int index) {
        return "Reac" + index;
    }

    public int getSpeciesByName(String name) {
        return 0;
    }

    public String getSpeciesName(int index) {
        return null;
    }

    public void setInitialAmount(int species, long value) {
        if (species < this.initialState.length) {
            this.initialState[species] = value;
        }
    }
}

