/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.largescale.simulation;

import fern.simulation.Simulator;
import fern.simulation.observer.Observer;
import fern.tools.Stochastics;
import java.io.IOException;
import java.util.Formatter;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.DoubleArray;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ParametricDerivationGraphBuilder;
import uk.ac.ed.inf.pepa.largescale.simulation.AbstractStochasticSimulation;
import uk.ac.ed.inf.pepa.largescale.simulation.DefaultCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.DefaultConvergenceChecker;
import uk.ac.ed.inf.pepa.largescale.simulation.IConvergenceChecker;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.SimulationException;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class TransientSimulation
extends AbstractStochasticSimulation {
    private DoubleArray time = new DoubleArray(100);
    private int replications = 0;
    private IConvergenceChecker convergenceChecker;

    public static void main(String[] args) throws IOException, DifferentialAnalysisException, InterruptedException, SimulationException {
        ModelNode model = (ModelNode)PepaTools.parse(PepaTools.readText(args[0]));
        IParametricDerivationGraph derivationGraph = ParametricDerivationGraphBuilder.createDerivationGraph(model, null);
        OptionMap map = new OptionMap();
        IPointEstimator[] estimators = new IPointEstimator[]{new IPointEstimator(){

            @Override
            public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
                return solution[solution.length - 1];
            }
        }};
        IStatisticsCollector[] collectors = new IStatisticsCollector[]{new DefaultCollector(0)};
        TransientSimulation simulation = new TransientSimulation(map, derivationGraph, estimators, collectors);
        simulation.doSimulation(new IProgressMonitor(){
            private int r = 0;
            private double[] times = null;

            @Override
            public void beginTask(int amount) {
                System.out.println("Simulation started: " + amount);
            }

            @Override
            public void done() {
                System.out.println("Simulation completed");
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void setCanceled(boolean state) {
            }

            @Override
            public void worked(int worked) {
                ++this.r;
                if (this.r == 1) {
                    this.times = TransientSimulation.this.getTimes();
                    System.out.print("  n  ");
                    double[] dArray = this.times;
                    int n = this.times.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double t = dArray[n2];
                        System.out.printf("       %6.2f       ", t);
                        ++n2;
                    }
                    System.out.println();
                }
            }
        });
    }

    public TransientSimulation(OptionMap map, IParametricDerivationGraph derivationGraph, IPointEstimator[] estimators, IStatisticsCollector[] collectors) {
        super(map, derivationGraph, estimators, collectors);
        if (this.startTime >= this.stopTime) {
            throw new IllegalArgumentException();
        }
        this.convergenceChecker = new DefaultConvergenceChecker();
    }

    public TransientSimulation(OptionMap map, IParametricDerivationGraph derivationGraph, IPointEstimator[] estimators) {
        this(map, derivationGraph, estimators, DefaultCollector.create(estimators));
    }

    public double[] getTimes() {
        if (this.replications == 0) {
            return new double[0];
        }
        return this.time.toArray();
    }

    @Override
    public void doSimulation(IProgressMonitor monitor) throws SimulationException, InterruptedException {
        boolean converged;
        block10: {
            if (monitor == null) {
                monitor = new DoNothingMonitor();
            }
            if (this.convergenceCriterion == 0) {
                monitor.beginTask(this.maxIterations);
            } else {
                monitor.beginTask(-1);
            }
            this.simulator.addObserver(this.getObserver());
            this.replications = 0;
            converged = false;
            do {
                ++this.replications;
                Stochastics.getInstance().resetSeed();
                try {
                    this.simulator.start(this.stopTime);
                }
                catch (IllegalStateException e) {
                    monitor.done();
                    throw new SimulationException(e.getCause());
                }
                if (monitor.isCanceled()) {
                    monitor.done();
                    throw new InterruptedException("Simulation was cancelled");
                }
                if (this.replications >= 3) {
                    this.currentConfidenceError = this.convergenceChecker.computeConvergenceError(this);
                    if (this.convergenceCriterion == 1 && this.currentConfidenceError < this.requiredConfidenceError) {
                        converged = true;
                        break block10;
                    }
                }
                monitor.worked(1);
            } while (this.replications != this.maxIterations);
            converged = this.convergenceCriterion == 0;
        }
        monitor.done();
        if (!converged) {
            String message = "" + new Formatter().format("Simulation has not converged after %d replications. Confidence interval: %6f", this.replications, this.currentConfidenceError);
            throw new SimulationException(message);
        }
    }

    private Observer getObserver() {
        Observer transientObserver = new Observer(this.simulator){
            private boolean firstReplication;
            private int timeIndex;
            {
                this.firstReplication = true;
                this.timeIndex = 0;
            }

            public void activateReaction(int mu, double tau, Simulator.FireType fireType, int times) {
            }

            public void finished() {
                this.firstReplication = false;
                this.timeIndex = 0;
            }

            public void started() {
                this.setTheta(TransientSimulation.this.startTime);
            }

            public void step() {
            }

            public void theta(double theta) {
                if (this.firstReplication) {
                    TransientSimulation.this.time.add(theta);
                }
                double[] currentSolution = new double[TransientSimulation.this.derivationGraph.getInitialState().length];
                int i = 0;
                while (i < currentSolution.length) {
                    currentSolution[i] = TransientSimulation.this.simulator.getAmount(i);
                    ++i;
                }
                double[] estimates = new double[TransientSimulation.this.estimators.length];
                int i2 = 0;
                while (i2 < TransientSimulation.this.estimators.length) {
                    try {
                        estimates[i2] = TransientSimulation.this.estimators[i2].computeEstimate(theta, currentSolution);
                    }
                    catch (DifferentialAnalysisException e) {
                        throw new IllegalStateException(e);
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < TransientSimulation.this.collectors.length) {
                    double currentResult = TransientSimulation.this.collectors[i2].computeObservation(estimates);
                    TransientSimulation.this.tallies[i2][this.timeIndex].add(currentResult);
                    ++i2;
                }
                if (++this.timeIndex == TransientSimulation.this.getNumberOfTimePoints()) {
                    return;
                }
                this.setTheta(theta + TransientSimulation.this.timeInterval);
            }
        };
        return transientObserver;
    }

    @Override
    public int getNumberOfTimePoints() {
        return this.timeStep;
    }
}

