/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode.internal.odetojava;

import Jama.Matrix;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Btableau;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.IWriterCallback;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODE;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODEFileWriter;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Span;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.StdMet;

public class Imex {
    private IWriterCallback writer;
    private ODE f;
    private double t0;
    private double tf;
    private double[] u0;
    private double h;
    private double told;
    private double[] uold;
    private double[] unew;
    private int n;
    private int s;
    private double[][] a;
    private double[] b;
    private double[][] ahat;
    private double[] bhat;
    private int steps;
    private int count;
    private String fileName;
    private boolean stats_on;
    private boolean stats_intermediate;
    private double[][] jacobian;
    private double[][] I;
    private double[][] k;
    private double[][] khat;
    private final double deltaMin = 1.0E-4;
    private final double deltaY = Math.sqrt(1.0E-4);
    private int nPoints;

    public static void imex(ODE function, Span tspan, double[] u0, double h, Btableau butcher, String fileName, String stats, IWriterCallback callback) throws DifferentialAnalysisException {
        Imex.imex(function, tspan, u0, h, butcher, fileName, stats, 1000, callback);
    }

    public static void imex(ODE function, Span tspan, double[] u0, double h, Btableau butcher, String fileName, String stats, int nPoints, IWriterCallback callback) throws DifferentialAnalysisException {
        Imex imex = new Imex(function, tspan, u0, h, butcher, fileName, stats, callback);
        imex.setNPoints(nPoints);
        imex.routine();
    }

    public void setNPoints(int nPoints) {
        this.nPoints = nPoints;
    }

    public Imex(ODE function, Span tspan, double[] u0, double h, Btableau butcher, String fileName, String stats, IWriterCallback callback) {
        this.writer = this.writer == null ? new ODEFileWriter() : callback;
        if (!tspan.get_property()) {
            throw new IllegalArgumentException("Improper span: times are out of order");
        }
        this.f = function;
        this.t0 = tspan.get_t0();
        this.tf = tspan.get_tf();
        this.h = h;
        this.s = butcher.getbl();
        if (h <= 0.0) {
            System.out.println("Stepsize must be greater than zero");
            System.exit(0);
        }
        if (this.tf - this.t0 < h) {
            System.out.println("Stepsize is larger than tspan");
            System.exit(0);
        }
        this.u0 = new double[u0.length];
        StdMet.arraycpy(this.u0, u0);
        this.n = u0.length;
        this.a = new double[butcher.getah()][butcher.getal()];
        this.b = new double[butcher.getbl()];
        this.ahat = new double[butcher.getahath()][butcher.getahatl()];
        this.bhat = new double[butcher.getbhatl()];
        StdMet.matrixcpy(this.a, butcher.get_a());
        StdMet.arraycpy(this.b, butcher.get_b());
        StdMet.matrixcpy(this.ahat, butcher.get_ahat());
        StdMet.arraycpy(this.bhat, butcher.get_bhat());
        this.steps = (int)Math.floor((this.tf - this.t0) / h);
        this.count = 0;
        if (stats.equals("Stats_On")) {
            this.stats_on = true;
            this.stats_intermediate = false;
        } else if (stats.equals("Stats_Intermediate")) {
            this.stats_on = true;
            this.stats_intermediate = true;
        } else if (stats.equals("Stats_Off")) {
            this.stats_on = false;
            this.stats_intermediate = false;
        } else {
            System.out.println("String parameter must be either: 1) \"Stats_On\" 2) \"Stats_Intermediate\" or 3) \"Stats_Off\"");
            System.exit(0);
        }
        this.fileName = fileName;
        if (tspan.get_timesLength() > 0) {
            System.out.println();
            System.out.println("note that this solver does not do interpolation . . .");
            System.out.println();
        }
    }

    public void routine() throws DifferentialAnalysisException {
        System.out.println();
        System.out.println("Begin Implicit-Explicit Runge-Kutta Routine . . .");
        System.out.println();
        this.told = this.t0;
        this.uold = new double[this.n];
        this.unew = new double[this.n];
        StdMet.arraycpy(this.uold, this.u0);
        this.jacobian = new double[this.n][this.n];
        this.I = new double[this.n][this.n];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i == j) {
                    this.I[i][j] = 1.0;
                }
                ++j;
            }
            ++i;
        }
        double[] f1 = new double[this.n];
        double[] f2 = new double[this.n];
        double[] yTemp = new double[this.n];
        double[] ad1 = new double[this.n];
        double[] stam1 = new double[this.n];
        double[] stam2 = new double[this.n];
        double[] as1 = new double[this.n];
        double[] mtam1 = new double[this.n];
        double[] fn = new double[this.n];
        double[] g = new double[this.n];
        double[] temp = new double[this.n];
        double[] a1 = new double[this.n];
        double[][] m1 = new double[this.n][this.n];
        double[][] m2 = new double[this.n][1];
        boolean done = false;
        this.writer.openFile(this.fileName);
        while (!done) {
            if (this.told + this.h > this.tf) {
                this.h = this.tf - this.told;
                done = true;
            }
            f1 = this.f.f(this.told, this.uold);
            int i2 = 0;
            while (i2 < this.n) {
                double deltaX = this.deltaY * Math.abs(this.uold[i2]);
                if (deltaX < 1.0E-4) {
                    deltaX = 1.0E-4;
                }
                StdMet.arraycpy(yTemp, this.uold);
                int n = i2;
                yTemp[n] = yTemp[n] + deltaX;
                f2 = this.f.f(this.told, yTemp);
                StdMet.arraydiff(ad1, f2, f1);
                StdMet.stam(stam1, 1.0 / deltaX, ad1);
                int j = 0;
                while (j < this.n) {
                    this.jacobian[j][i2] = stam1[j];
                    ++j;
                }
                ++i2;
            }
            this.k = new double[this.s][this.n];
            this.khat = new double[this.s + 1][this.n];
            f1 = this.f.f(this.told, this.uold);
            StdMet.mtam(g, this.jacobian, this.uold);
            StdMet.arraydiff(fn, f1, g);
            StdMet.arraycpy(this.khat[0], fn);
            i2 = 0;
            while (i2 < this.s) {
                StdMet.zero_out(temp);
                int j = 0;
                while (j < i2) {
                    StdMet.stam(stam1, this.a[i2][j], this.k[j]);
                    StdMet.stam(stam2, this.ahat[i2 + 1][j], this.khat[j]);
                    StdMet.arraysum(as1, stam1, stam2);
                    StdMet.arraysum(temp, temp, as1);
                    ++j;
                }
                StdMet.stam(stam1, this.ahat[i2 + 1][i2], this.khat[i2]);
                StdMet.arraysum(temp, temp, stam1);
                StdMet.stam(temp, this.h, temp);
                StdMet.arraysum(temp, temp, this.uold);
                j = 0;
                while (j < this.n) {
                    StdMet.stam(stam1, this.h * this.a[i2][i2], this.jacobian[j]);
                    StdMet.arraycpy(m1[j], stam1);
                    ++j;
                }
                j = 0;
                while (j < this.n) {
                    StdMet.arraydiff(m1[j], this.I[j], m1[j]);
                    ++j;
                }
                StdMet.mtam(mtam1, this.jacobian, temp);
                Matrix A = new Matrix(m1);
                int j2 = 0;
                while (j2 < this.n) {
                    m2[j2][0] = mtam1[j2];
                    ++j2;
                }
                Matrix B = new Matrix(m2);
                Matrix X = A.solve(B);
                a1 = X.getColumnPackedCopy();
                StdMet.arraycpy(this.k[i2], a1);
                StdMet.stam(stam1, this.h * this.a[i2][i2], this.k[i2]);
                StdMet.arraysum(temp, temp, stam1);
                f1 = this.f.f(this.told, temp);
                StdMet.mtam(g, this.jacobian, temp);
                StdMet.arraydiff(fn, f1, g);
                StdMet.arraycpy(this.khat[i2 + 1], fn);
                ++i2;
            }
            StdMet.zero_out(temp);
            i2 = 0;
            while (i2 < this.s) {
                StdMet.stam(stam1, this.b[i2], this.k[i2]);
                StdMet.stam(stam2, this.bhat[i2], this.khat[i2]);
                StdMet.arraysum(as1, stam1, stam2);
                StdMet.arraysum(temp, temp, as1);
                ++i2;
            }
            StdMet.stam(stam1, this.bhat[this.s], this.khat[this.s]);
            StdMet.arraysum(temp, temp, stam1);
            StdMet.stam(temp, this.h, temp);
            StdMet.arraysum(this.uold, this.uold, temp);
            this.told += this.h;
            double norm = StdMet.rmsNorm(this.uold);
            if (norm != norm) {
                System.out.println("unstable . . . aborting");
                this.writer.closeFile();
                return;
            }
            if (this.steps <= this.nPoints) {
                this.writer.writeToFile(this.told, this.uold);
            } else if (this.count % (this.steps / this.nPoints) == 0) {
                this.writer.writeToFile(this.told, this.uold);
            }
            if (this.stats_on) {
                System.out.println("t = " + this.told);
                if (!this.stats_intermediate) {
                    System.out.println("soln = ");
                    StdMet.arrayprt(this.uold);
                }
                System.out.println();
            }
            ++this.count;
        }
        System.out.println("done");
        System.out.println("final t = " + this.told);
        System.out.println("final soln  =");
        StdMet.arrayprt(this.uold);
        this.writer.writeToFile(this.told, this.uold);
        this.writer.closeFile();
    }
}

