/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode.internal.odetojava;

import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Btableau;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.IWriterCallback;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODE;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODEFileWriter;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Span;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.StdMet;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.ssCtrlModules.ErrorEstimator;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.ssCtrlModules.Imex1S;

public class ImexSD {
    private IWriterCallback writer;
    private ODE f;
    private Btableau butcher;
    private double t0;
    private double tf;
    private int n;
    private double[] unew;
    private double atol;
    private double rtol;
    private double h;
    private double hopt;
    private double told;
    private double[] uold_e1;
    private double[] uold_e2;
    private String fileName;
    private boolean stats_on;
    private boolean stats_intermediate;
    private final double alpha = 0.9;
    private final double amax = 5.0;
    private double p;
    private int nreject;
    private int naccept;
    private boolean done;
    private boolean lastStep;
    private double[] eta1;
    private double[] eta2;

    public static void imex_sd(ODE function, Span tspan, double[] u0, double h0, Btableau butcher, double atol, double rtol, String fileName, String stats, IWriterCallback writer) throws DifferentialAnalysisException, InterruptedException {
        ImexSD imexsd = new ImexSD(function, tspan, u0, h0, butcher, atol, rtol, fileName, stats, writer);
        imexsd.routine();
    }

    public ImexSD(ODE function, Span tspan, double[] u0, double h0, Btableau butcher, double atol, double rtol, String fileName, String stats, IWriterCallback writer) {
        this.writer = writer == null ? new ODEFileWriter() : writer;
        if (!tspan.get_property()) {
            System.out.println("Improper span: times are out of order");
            System.exit(0);
        }
        this.f = function;
        this.butcher = butcher;
        this.t0 = tspan.get_t0();
        this.tf = tspan.get_tf();
        this.atol = atol;
        this.rtol = rtol;
        this.h = h0;
        this.n = u0.length;
        this.eta1 = new double[this.n];
        this.eta2 = new double[this.n];
        if (h0 <= 0.0) {
            throw new IllegalArgumentException("Initial stepsize must be greater than zero");
        }
        if (atol <= 0.0) {
            throw new IllegalArgumentException("Abolute tolerance must be greater than zero");
        }
        if (rtol <= 0.0) {
            throw new IllegalArgumentException("Relative tolerance must be greater than zero");
        }
        this.p = 3.0;
        this.nreject = 0;
        this.naccept = 0;
        this.told = this.t0;
        this.uold_e1 = new double[this.n];
        StdMet.arraycpy(this.uold_e1, u0);
        this.uold_e2 = new double[this.n];
        StdMet.arraycpy(this.uold_e2, u0);
        this.lastStep = false;
        this.done = false;
        if (stats.equals("Stats_On")) {
            this.stats_on = true;
            this.stats_intermediate = false;
        } else if (stats.equals("Stats_Intermediate")) {
            this.stats_on = true;
            this.stats_intermediate = true;
        } else if (stats.equals("Stats_Off")) {
            this.stats_on = false;
            this.stats_intermediate = false;
        } else {
            throw new IllegalArgumentException("String parameter must be either: 1) \"Stats_On\" 2) \"Stats_Intermediate\" or 3) \"Stats_Off\"");
        }
        this.fileName = fileName;
        if (tspan.get_timesLength() > 0) {
            System.out.println();
            System.out.println("note that this solver does not do interpolation . . .");
            System.out.println();
        }
    }

    public void routine() throws DifferentialAnalysisException, InterruptedException {
        Imex1S imex1s = new Imex1S(this.butcher);
        double[] utemp = new double[this.n];
        double[] eta2temp = new double[this.n];
        double[] cfr_ignored_0 = new double[this.n];
        this.writer.openFile(this.fileName);
        while (!this.done) {
            if (this.writer.isCanceled()) {
                this.writer.closeFile();
                throw new InterruptedException("ODE integration was canceled");
            }
            if (this.lastStep) {
                this.done = true;
            }
            this.eta1 = imex1s.doOneStep(this.f, this.told, this.uold_e1, this.h);
            StdMet.arraycpy(utemp, this.uold_e1);
            StdMet.arraycpy(this.uold_e1, this.eta1);
            eta2temp = imex1s.doOneStep(this.f, this.told, this.uold_e2, this.h / 2.0);
            this.eta2 = imex1s.doOneStep(this.f, this.told + this.h / 2.0, eta2temp, this.h / 2.0);
            StdMet.arraycpy(this.uold_e2, this.eta2);
            this.told += this.h;
            double[] estimation = ErrorEstimator.stepdoubling_estimate(this.h, this.eta1, this.eta2, utemp, this.atol, this.rtol, this.p, 5.0, 0.9);
            double hNew = estimation[0];
            this.hopt = estimation[1];
            double norm = estimation[2];
            if (Double.isNaN(norm)) {
                throw new DifferentialAnalysisException("Solution unstable");
            }
            if (this.tf - this.told <= hNew) {
                hNew = this.tf - this.told;
                this.lastStep = true;
            }
            if (this.done) {
                if (this.h / this.hopt > 3.0) {
                    this.done = false;
                    this.lastStep = false;
                    ++this.nreject;
                    this.told -= this.h;
                    StdMet.arraycpy(this.uold_e1, utemp);
                    StdMet.arraycpy(this.uold_e2, utemp);
                    this.h /= 2.0;
                    if (!this.stats_on || this.stats_intermediate) continue;
                    System.out.println("rejected");
                    System.out.println("new h = " + this.h);
                    System.out.println();
                    continue;
                }
                ++this.naccept;
                System.out.println("done");
                System.out.println("final t = " + this.told);
                System.out.println("final u =");
                StdMet.arrayprt(this.uold_e2);
                System.out.println();
                System.out.println("# of rejections = " + this.nreject);
                System.out.println("# of accepted steps = " + this.naccept);
                this.writer.writeToFile(this.told, this.uold_e2);
                continue;
            }
            if (this.lastStep || this.h / this.hopt <= 3.0) {
                StdMet.arraycpy(this.uold_e1, this.uold_e2);
                this.h = hNew;
                ++this.naccept;
                this.writer.writeToFile(this.told, this.uold_e2);
                if (!this.stats_on) continue;
                if (!this.stats_intermediate) {
                    System.out.println("accepted");
                    System.out.println("new h = " + this.h);
                }
                System.out.println("t = " + this.told);
                if (!this.stats_intermediate) {
                    System.out.println("solution = ");
                    StdMet.arrayprt(this.uold_e2);
                }
                System.out.println();
                continue;
            }
            this.told -= this.h;
            StdMet.arraycpy(this.uold_e1, utemp);
            StdMet.arraycpy(this.uold_e2, utemp);
            this.h = hNew;
            ++this.nreject;
            if (!this.stats_on || this.stats_intermediate) continue;
            System.out.println("rejected");
            System.out.println("new h = " + this.h);
            System.out.println();
        }
        this.writer.closeFile();
    }
}

