/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.ode.internal.odetojava.ssCtrlModules;

import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.Btableau;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.ODE;
import uk.ac.ed.inf.pepa.ode.internal.odetojava.modules.StdMet;

public class Erk1S {
    private int s;
    private double[][] a;
    private double[] b;
    private double[] c;
    private boolean FSALenabled;
    private ODE f;
    private int n;
    private double t;
    private double h;
    private double[] xold;
    private double[] xnew;
    private double[][] K;

    public Erk1S(Btableau butcher, int n) {
        this.n = n;
        this.s = butcher.getbl();
        this.a = new double[butcher.getal()][butcher.getal()];
        this.b = new double[butcher.getbl()];
        this.c = new double[butcher.getcl()];
        StdMet.matrixcpy(this.a, butcher.get_a());
        StdMet.arraycpy(this.b, butcher.get_b());
        StdMet.arraycpy(this.c, butcher.get_c());
        this.FSALenabled = false;
        this.K = new double[this.s][n];
    }

    public double[] doOneStep(ODE function, double t, double[] x, double h, boolean firstStep, boolean justAccepted) throws DifferentialAnalysisException {
        this.t = t;
        this.h = h;
        if (x.length != this.n) {
            throw new IllegalArgumentException("length of vector disagrees with dimension of the problem");
        }
        this.f = function;
        this.xold = new double[this.n];
        this.xnew = new double[this.n];
        double[] sigma = new double[this.n];
        double[] sigma2 = new double[this.n];
        double[] as1 = new double[this.n];
        double[] stam1 = new double[this.n];
        double[] fp = new double[this.n];
        StdMet.arraycpy(this.xold, x);
        int i = 0;
        while (i < this.s) {
            int j = 0;
            while (j < i) {
                StdMet.stam(stam1, this.a[i][j], this.K[j]);
                StdMet.arraysum(sigma, sigma, stam1);
                ++j;
            }
            if (i != 0 || firstStep || !this.FSALenabled) {
                StdMet.stam(stam1, h, sigma);
                StdMet.arraysum(as1, this.xold, stam1);
                fp = this.f.f(t + h * this.c[i], as1);
                StdMet.arraycpy(this.K[i], fp);
                StdMet.zero_out(sigma);
            } else if (justAccepted) {
                StdMet.arraycpy(this.K[0], this.K[this.s - 1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.s) {
            StdMet.stam(stam1, h * this.b[i], this.K[i]);
            StdMet.arraysum(sigma2, sigma2, stam1);
            ++i;
        }
        StdMet.arraysum(this.xnew, this.xold, sigma2);
        return this.xnew;
    }
}

