/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.analysis.internal.AlphabetProvider;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Compiler;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionSuperNode;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.DefaultVisitor;
import uk.ac.ed.inf.pepa.parsing.ExpressionVisitor;
import uk.ac.ed.inf.pepa.parsing.FiniteRateNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitions;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitions;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class ASTSupport {
    private static ASTCopyVisitor astCV = new ASTCopyVisitor();
    private static ASTNamedFormVisitor astNFV = new ASTNamedFormVisitor();
    private static ASTAggregationVisitor astAV = new ASTAggregationVisitor();
    private static ASTStringVisitor astSV = new ASTStringVisitor();

    public static synchronized ASTNode copy(ASTNode abstractSyntaxTreeNode) {
        abstractSyntaxTreeNode.accept(astCV);
        return ASTSupport.astCV.copy;
    }

    public static synchronized HashMap<String, HashMap<String, String>> generateNamedForm(ModelNode model) {
        astSV.setMap(new HashMap<String, String>());
        model.accept(astNFV);
        return ASTSupport.astNFV.nameMap;
    }

    public static synchronized HashMap<String, HashMap<String, String>> generateNamedForm(ModelNode model, HashMap<String, String> alternateNames) {
        astSV.setMap(alternateNames);
        model.accept(astNFV);
        return ASTSupport.astNFV.nameMap;
    }

    public static synchronized ProcessNode enforceAggregation(ProcessNode systemEquation, ModelNode model) {
        astAV.start(systemEquation, model);
        return ASTSupport.astAV.newSystemEquation;
    }

    public static synchronized String toString(ASTNode node) {
        return astSV.toString(node, new HashMap<String, String>());
    }

    public static synchronized Map<String, Set<String>> getProcessAlphabets(ModelNode model) {
        AlphabetProvider iap = new AlphabetProvider(model);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Map.Entry<String, HashSet<String>> me : iap.getProcessAlphabets().entrySet()) {
            map.put(me.getKey(), (Set<String>)me.getValue());
        }
        return map;
    }

    public static synchronized ProcessNode suggestSystemEquation(ModelNode model) {
        return null;
    }

    private static class ASTAggregationVisitor
    extends DefaultVisitor {
        Actions lastActionSet;
        int numberOfInstances;
        int depth;
        String lastConstant;
        ProcessNode newSystemEquation;
        Model model;

        private ASTAggregationVisitor() {
        }

        public void start(ASTNode systemEquation, ModelNode model) {
            this.model = new Compiler(model).getModel();
            this.depth = 0;
            this.numberOfInstances = 0;
            this.lastConstant = "";
            this.lastActionSet = null;
            this.newSystemEquation = (ProcessNode)ASTSupport.copy(systemEquation);
            this.newSystemEquation.accept(this);
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            this.lastActionSet = new Actions();
            if (aggregation.getProcessNode() instanceof ConstantProcessNode) {
                this.lastConstant = ((ConstantProcessNode)aggregation.getProcessNode()).getName();
                this.numberOfInstances = this.getCopies(aggregation);
            } else {
                this.lastConstant = "";
            }
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            ++this.depth;
            choice.left.accept(this);
            choice.right.accept(this);
            this.lastActionSet = null;
            this.lastConstant = "";
            this.numberOfInstances = 0;
            --this.depth;
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.lastActionSet = new Actions();
            this.lastConstant = constant.getName();
            this.numberOfInstances = 1;
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            ++this.depth;
            cooperation.left.accept(this);
            String leftConstant = this.lastConstant;
            Actions leftActions = this.lastActionSet;
            int instancesSoFar = this.numberOfInstances;
            cooperation.right.accept(this);
            String rightConstant = this.lastConstant;
            Actions rightActions = this.lastActionSet;
            instancesSoFar += this.numberOfInstances;
            --this.depth;
            if (!leftConstant.equals("") && leftConstant.equals(rightConstant) && leftActions.size() == 0 && rightActions.size() == 0 && cooperation.getActionSet().size() == 0) {
                if (this.depth == 0) {
                    ConstantProcessNode constantNode = ASTFactory.createConstant();
                    constantNode.setName(rightConstant);
                    AggregationNode newNode = ASTFactory.createAggregation();
                    RateDoubleNode doubleNode = ASTFactory.createRate();
                    doubleNode.setValue(instancesSoFar);
                    newNode.setCopies(doubleNode);
                    newNode.setProcessNode(constantNode);
                    this.newSystemEquation = newNode;
                }
                this.numberOfInstances = instancesSoFar;
                this.lastActionSet = cooperation.getActionSet();
            } else {
                RateDoubleNode doubleNode;
                ConstantProcessNode constantNode;
                if (instancesSoFar - this.numberOfInstances > 1 && leftActions.size() == 0) {
                    constantNode = ASTFactory.createConstant();
                    constantNode.setName(leftConstant);
                    AggregationNode leftNode = ASTFactory.createAggregation();
                    doubleNode = ASTFactory.createRate();
                    doubleNode.setValue(instancesSoFar - this.numberOfInstances);
                    leftNode.setCopies(doubleNode);
                    leftNode.setProcessNode(constantNode);
                    cooperation.setLeft(leftNode);
                }
                if (this.numberOfInstances > 1 && rightActions.size() == 0) {
                    constantNode = ASTFactory.createConstant();
                    constantNode.setName(rightConstant);
                    AggregationNode rightNode = ASTFactory.createAggregation();
                    doubleNode = ASTFactory.createRate();
                    doubleNode.setValue(this.numberOfInstances);
                    rightNode.setCopies(doubleNode);
                    rightNode.setProcessNode(constantNode);
                    cooperation.setRight(rightNode);
                }
                this.lastActionSet = null;
                this.lastConstant = "";
                this.numberOfInstances = 0;
            }
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            this.lastActionSet = null;
            this.lastConstant = "";
            this.numberOfInstances = 0;
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            this.lastActionSet = null;
            this.lastConstant = "";
            this.numberOfInstances = 0;
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
        }

        private int getCopies(AggregationNode aggregation) {
            ExpressionVisitor v = new ExpressionVisitor(this.model);
            aggregation.getCopies().accept(v);
            return v.eval();
        }
    }

    private static class ASTCopyVisitor
    implements ASTVisitor {
        ASTNode copy;

        private ASTCopyVisitor() {
        }

        private void setLocations(ASTNode a) {
            this.copy.setLeftLocation(a.getLeftLocation());
            this.copy.setRightLocation(a.getRightLocation());
        }

        @Override
        public void visitActionTypeNode(ActionTypeNode actionType) {
            this.copy = new ActionTypeNode();
            ((ActionTypeNode)this.copy).setType(actionType.getType());
            this.setLocations(actionType);
        }

        @Override
        public void visitActivityNode(ActivityNode activity) {
            ActivityNode an = new ActivityNode();
            activity.getAction().accept0(this);
            an.setAction((ActionSuperNode)this.copy);
            activity.getRate().accept0(this);
            an.setRate((RateNode)this.copy);
            this.copy = an;
            this.setLocations(activity);
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            AggregationNode a = new AggregationNode();
            aggregation.getCopies().accept(this);
            a.setCopies((FiniteRateNode)this.copy);
            aggregation.getProcessNode().accept0(this);
            a.setProcessNode((ProcessNode)this.copy);
            this.copy = a;
            this.setLocations(aggregation);
        }

        @Override
        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            BinaryOperatorRateNode bORN = new BinaryOperatorRateNode();
            bORN.setOperator(rate.getOperator());
            rate.getLeft().accept0(this);
            bORN.setLeft((RateNode)this.copy);
            rate.getRight().accept0(this);
            bORN.setRight((RateNode)this.copy);
            this.copy = bORN;
            this.setLocations(rate);
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            ChoiceNode c = new ChoiceNode();
            choice.getLeft().accept0(this);
            c.setLeft((ProcessNode)this.copy);
            choice.getRight().accept0(this);
            c.setRight((ProcessNode)this.copy);
            this.copy = c;
            this.setLocations(choice);
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.copy = new ConstantProcessNode();
            ((ConstantProcessNode)this.copy).setName(constant.getName());
            this.setLocations(constant);
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            CooperationNode c = new CooperationNode();
            Actions a = new Actions();
            cooperation.getLeft().accept0(this);
            c.setLeft((ProcessNode)this.copy);
            cooperation.getRight().accept0(this);
            c.setRight((ProcessNode)this.copy);
            for (ActionTypeNode aTN : cooperation.getActionSet()) {
                aTN.accept0(this);
                a.add((ActionTypeNode)this.copy);
            }
            c.setActionSet(a);
            this.copy = c;
            this.setLocations(cooperation);
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            HidingNode h = new HidingNode();
            Actions a = new Actions();
            hiding.getProcess().accept0(this);
            h.setProcess((ProcessNode)this.copy);
            for (ActionTypeNode aTN : hiding.getActionSet()) {
                aTN.accept0(this);
                a.add((ActionTypeNode)this.copy);
            }
            h.setActionSet(a);
            this.copy = h;
            this.setLocations(hiding);
        }

        @Override
        public void visitModelNode(ModelNode model) {
            ModelNode m = new ModelNode();
            RateDefinitions r = m.rateDefinitions();
            for (RateDefinitionNode rDN : model.rateDefinitions()) {
                rDN.accept0(this);
                r.add((RateDefinitionNode)this.copy);
            }
            ProcessDefinitions p = m.processDefinitions();
            for (ProcessDefinitionNode pDN : model.processDefinitions()) {
                pDN.accept0(this);
                p.add((ProcessDefinitionNode)this.copy);
            }
            if (model.getSystemEquation() != null) {
                model.getSystemEquation().accept0(this);
                m.setSystemEquation((ProcessNode)this.copy);
            }
            IProblem[] i = model.getProblems();
            IProblem[] newi = new IProblem[i.length];
            int index = 0;
            while (index < i.length) {
                newi[index] = ProblemFactory.createProblem(i[index].getId(), i[index].getStartLine(), i[index].getStartColumn(), i[index].getEndLine(), i[index].getEndColumn(), i[index].getChar(), i[index].getLength(), i[index].getMessage());
                ++index;
            }
            this.copy = m;
            this.setLocations(model);
        }

        @Override
        public void visitPassiveRateNode(PassiveRateNode passive) {
            this.copy = new PassiveRateNode();
            ((PassiveRateNode)this.copy).setMultiplicity(passive.getMultiplicity());
            this.setLocations(passive);
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            PrefixNode p = new PrefixNode();
            prefix.getActivity().accept0(this);
            p.setActivity((ActivityNode)this.copy);
            prefix.getTarget().accept0(this);
            p.setTarget((ProcessNode)this.copy);
            this.copy = p;
            this.setLocations(prefix);
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            ProcessDefinitionNode p = new ProcessDefinitionNode();
            processDefinition.getName().accept0(this);
            p.setName((ConstantProcessNode)this.copy);
            processDefinition.getNode().accept0(this);
            p.setNode((ProcessNode)this.copy);
            this.copy = p;
            this.setLocations(processDefinition);
        }

        @Override
        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            RateDefinitionNode r = new RateDefinitionNode();
            rateDefinition.getName().accept0(this);
            r.setName((VariableRateNode)this.copy);
            rateDefinition.getRate().accept(this);
            r.setRate((RateNode)this.copy);
            this.copy = r;
            this.setLocations(rateDefinition);
        }

        @Override
        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            this.copy = new RateDoubleNode();
            ((RateDoubleNode)this.copy).setValue(doubleRate.getValue());
            this.setLocations(doubleRate);
        }

        @Override
        public void visitVariableRateNode(VariableRateNode variableRate) {
            this.copy = new VariableRateNode();
            ((VariableRateNode)this.copy).setName(variableRate.getName());
            this.setLocations(variableRate);
        }

        @Override
        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            this.copy = new UnknownActionTypeNode();
            this.setLocations(unknownActionTypeNode);
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            WildcardCooperationNode c = new WildcardCooperationNode();
            cooperation.getLeft().accept0(this);
            c.setLeft((ProcessNode)this.copy);
            cooperation.getRight().accept0(this);
            c.setRight((ProcessNode)this.copy);
            this.copy = c;
            this.setLocations(cooperation);
        }
    }

    private static class ASTNamedFormVisitor
    extends DefaultVisitor {
        ProcessDefinitions tProcessDefinitions;
        ProcessDefinitions newProcessDefinitions;
        ProcessNode lastNode;
        String currentDefinedName;
        String postfix;
        String s;
        int postfixCount;
        int currentDepth;
        HashMap<String, String> currentProcessMap;
        HashMap<String, HashMap<String, String>> nameMap;

        private ASTNamedFormVisitor() {
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            this.lastNode = (ProcessNode)ASTSupport.copy(aggregation);
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            int postfix = -1;
            if (this.currentDepth > 0) {
                postfix = ++this.postfixCount;
            }
            ChoiceNode newChoiceNode = new ChoiceNode();
            this.currentDepth = 0;
            choice.getLeft().accept(this);
            newChoiceNode.setLeft(this.lastNode);
            this.currentDepth = 0;
            ProcessDefinitions left = this.tProcessDefinitions;
            this.tProcessDefinitions = new ProcessDefinitions();
            choice.getRight().accept(this);
            newChoiceNode.setRight(this.lastNode);
            left.addAll(this.tProcessDefinitions);
            this.tProcessDefinitions = left;
            this.lastNode = newChoiceNode;
            if (postfix > 0) {
                this.s = this.createNewProcessDefinition(postfix);
                this.currentProcessMap.put(this.s, astSV.toString(choice));
            }
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            ConstantProcessNode newConstant = new ConstantProcessNode();
            newConstant.setName(constant.getName());
            this.lastNode = newConstant;
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            this.lastNode = (ProcessNode)ASTSupport.copy(cooperation);
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            this.lastNode = (ProcessNode)ASTSupport.copy(hiding);
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.nameMap = new HashMap();
            this.newProcessDefinitions = new ProcessDefinitions();
            LinkedList<String> definedNames = new LinkedList<String>();
            for (ProcessDefinitionNode pdn : model.processDefinitions()) {
                definedNames.add(pdn.getName().getName());
            }
            boolean postfixFound = false;
            int underscores = -1;
            block1: while (!postfixFound) {
                Pattern pattern = Pattern.compile("_{" + ++underscores + "}\\d+");
                postfixFound = true;
                LinkedList definedNamesCopy = new LinkedList(definedNames);
                while (!definedNamesCopy.isEmpty()) {
                    boolean quoted;
                    this.currentDefinedName = (String)definedNamesCopy.remove();
                    if (this.currentDefinedName.charAt(0) == '\"') {
                        quoted = true;
                        this.currentDefinedName = this.currentDefinedName.substring(0, this.currentDefinedName.length() - 1);
                    } else {
                        quoted = false;
                    }
                    for (String next : definedNamesCopy) {
                        if (!next.startsWith(this.currentDefinedName) || !pattern.matcher(next.substring(this.currentDefinedName.length(), next.length() - (quoted ? 1 : 0))).matches()) continue;
                        postfixFound = false;
                        continue block1;
                    }
                }
            }
            this.postfix = "";
            while (underscores-- > 0) {
                this.postfix = String.valueOf(this.postfix) + "_";
            }
            for (ProcessDefinitionNode pdn : model.processDefinitions()) {
                pdn.accept(this);
            }
            model.processDefinitions().clear();
            model.processDefinitions().addAll(this.newProcessDefinitions);
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            int depth = this.currentDepth++;
            int postfixInt = 0;
            if (depth > 0) {
                postfixInt = ++this.postfixCount;
            }
            prefix.getTarget().accept(this);
            PrefixNode newPrefixNode = new PrefixNode();
            newPrefixNode.setActivity((ActivityNode)ASTSupport.copy(prefix.getActivity()));
            newPrefixNode.setTarget(this.lastNode);
            this.lastNode = newPrefixNode;
            if (depth > 0) {
                this.s = this.createNewProcessDefinition(postfixInt);
                this.currentProcessMap.put(this.s, astSV.toString(prefix));
            }
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            this.currentDefinedName = processDefinition.getName().getName();
            this.currentProcessMap = new HashMap();
            this.currentDepth = 0;
            this.postfixCount = 0;
            this.tProcessDefinitions = new ProcessDefinitions();
            processDefinition.getNode().accept(this);
            ProcessDefinitionNode pdn = new ProcessDefinitionNode();
            ConstantProcessNode cpn = new ConstantProcessNode();
            cpn.setName(this.currentDefinedName);
            pdn.setName(cpn);
            pdn.setNode(this.lastNode);
            this.newProcessDefinitions.add(pdn);
            this.newProcessDefinitions.addAll(this.tProcessDefinitions);
            this.nameMap.put(this.currentDefinedName, this.currentProcessMap);
        }

        private String createNewProcessDefinition(int postfixInt) {
            ProcessDefinitionNode pdn = new ProcessDefinitionNode();
            ConstantProcessNode cpn = new ConstantProcessNode();
            boolean quoted = this.currentDefinedName.startsWith("\"");
            cpn.setName(String.valueOf(this.currentDefinedName.substring(0, this.currentDefinedName.length() - (quoted ? 1 : 0))) + this.postfix + postfixInt + (quoted ? "\"" : ""));
            pdn.setName(cpn);
            pdn.setNode(this.lastNode);
            this.tProcessDefinitions.addFirst(pdn);
            this.lastNode = cpn;
            return cpn.getName();
        }
    }

    private static class ASTStringVisitor
    implements ASTVisitor {
        BinaryOperatorRateNode.Operator currentOp;
        static final String INFTY = "infty";
        StringBuilder string;
        HashMap<String, String> alternateNames;

        private ASTStringVisitor() {
        }

        public String toString(ASTNode node, HashMap<String, String> alternateNames) {
            this.alternateNames = alternateNames;
            this.string = new StringBuilder();
            this.currentOp = null;
            node.accept(this);
            return this.string.toString();
        }

        public String toString(ASTNode node) {
            this.string = new StringBuilder();
            this.currentOp = null;
            node.accept(this);
            return this.string.toString();
        }

        void setMap(HashMap<String, String> alternateNames) {
            this.alternateNames = alternateNames;
        }

        @Override
        public void visitActionTypeNode(ActionTypeNode actionType) {
            this.string.append(actionType.getType());
        }

        @Override
        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            this.string.append("tau");
        }

        @Override
        public void visitActivityNode(ActivityNode activity) {
            activity.getAction().accept(this);
            this.string.append(",");
            StringBuilder sofar = this.string;
            this.string = new StringBuilder();
            activity.getRate().accept(this);
            this.string = sofar.append((CharSequence)this.string);
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            aggregation.getProcessNode().accept(this);
            StringBuilder sofar = this.string;
            this.string = new StringBuilder();
            aggregation.getCopies().accept(this);
            this.string = sofar.append("[").append((CharSequence)this.string).append("]");
        }

        @Override
        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            StringBuilder sofar = this.string;
            this.string = new StringBuilder();
            this.currentOp = null;
            rate.getLeft().accept(this);
            StringBuilder leftSB = this.string;
            BinaryOperatorRateNode.Operator leftOp = this.currentOp;
            this.currentOp = null;
            this.string = new StringBuilder();
            rate.getRight().accept(this);
            StringBuilder rightSB = this.string;
            BinaryOperatorRateNode.Operator rightOp = this.currentOp;
            this.currentOp = rate.getOperator();
            if (leftOp != null && leftOp.precedence() < this.currentOp.precedence()) {
                sofar.append("(").append((CharSequence)leftSB).append(")");
            } else {
                sofar.append((CharSequence)leftSB);
            }
            sofar.append((Object)this.currentOp);
            if (rightOp != null && rightOp.precedence() < this.currentOp.precedence()) {
                sofar.append("(").append((CharSequence)rightSB).append(")");
            } else {
                sofar.append((CharSequence)rightSB);
            }
            this.string = sofar;
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            choice.getLeft().accept(this);
            this.string.append(" + ");
            choice.getRight().accept(this);
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            if (this.alternateNames.containsKey(constant.getName())) {
                this.string.append(this.alternateNames.get(constant.getName()));
            } else {
                this.string.append(constant.getName());
            }
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            this.string.append("(");
            cooperation.getLeft().accept(this);
            this.string.append(" <");
            for (ActionTypeNode atn : cooperation.getActionSet()) {
                this.string.append(atn.getType()).append(",");
            }
            if (this.string.charAt(this.string.length() - 1) == ',') {
                this.string.deleteCharAt(this.string.length() - 1);
            }
            this.string.append("> ");
            cooperation.getRight().accept(this);
            this.string.append(")");
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            hiding.getProcess().accept(this);
            this.string.append("/<");
            for (ActionTypeNode atn : hiding.getActionSet()) {
                this.string.append(atn.getType()).append(",");
            }
            this.string.deleteCharAt(this.string.length() - 1);
            this.string.append(">");
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.string.append("//Rates\n");
            for (RateDefinitionNode rtn : model.rateDefinitions()) {
                rtn.accept(this);
                this.string.append(";\n");
            }
            this.string.append("\n//Definitions\n");
            for (ProcessDefinitionNode ptn : model.processDefinitions()) {
                ptn.accept(this);
                this.string.append(";\n");
            }
            this.string.append("\n//System Equation\n");
            int i = this.string.length();
            model.getSystemEquation().accept(this);
            if (model.getSystemEquation() instanceof CooperationNode) {
                this.string.deleteCharAt(i);
                this.string.deleteCharAt(this.string.length() - 1);
            }
        }

        @Override
        public void visitPassiveRateNode(PassiveRateNode passive) {
            int i = passive.getMultiplicity();
            if (i > 1) {
                this.string.append(i).append("*");
                this.currentOp = BinaryOperatorRateNode.Operator.MULT;
            }
            this.string.append(INFTY);
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            this.string.append("(");
            prefix.getActivity().accept(this);
            this.string.append(").");
            prefix.getTarget().accept(this);
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            processDefinition.getName().accept(this);
            this.string.append(" = ");
            processDefinition.getNode().accept(this);
        }

        @Override
        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            this.string.append(rateDefinition.getName().getName()).append(" = ");
            rateDefinition.getRate().accept(this);
        }

        @Override
        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            this.string.append(doubleRate.getValue());
        }

        @Override
        public void visitVariableRateNode(VariableRateNode variableRate) {
            this.string.append(variableRate.getName());
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            this.string.append("(");
            cooperation.getLeft().accept(this);
            this.string.append(" <*>");
            cooperation.getRight().accept(this);
            this.string.append(")");
        }
    }
}

