/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing;

import org.systemsbiology.math.Expression;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.FiniteRateNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;

public class BinaryOperatorRateNode
extends FiniteRateNode {
    private RateNode left;
    private RateNode right;
    private Operator operator;

    BinaryOperatorRateNode() {
    }

    public RateNode getLeft() {
        return this.left;
    }

    public void setLeft(RateNode left) {
        if (left == null) {
            throw new NullPointerException();
        }
        this.left = left;
    }

    public RateNode getRight() {
        return this.right;
    }

    public void setRight(RateNode right) {
        if (right == null) {
            throw new NullPointerException();
        }
        this.right = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new NullPointerException();
        }
        this.operator = operator;
    }

    @Override
    protected void accept0(ASTVisitor v) {
        v.visitBinaryOperatorRateNode(this);
    }

    public static enum Operator {
        PLUS("+", 10){

            @Override
            public double evaluate(double a, double b) {
                return a + b;
            }

            @Override
            public Expression.Element getElement() {
                return new Expression.Element(Expression.ElementCode.ADD);
            }
        }
        ,
        MINUS("-", 10){

            @Override
            public double evaluate(double a, double b) {
                return a - b;
            }

            @Override
            public Expression.Element getElement() {
                return new Expression.Element(Expression.ElementCode.SUBT);
            }
        }
        ,
        MULT("*", 20){

            @Override
            public double evaluate(double a, double b) {
                return a * b;
            }

            @Override
            public Expression.Element getElement() {
                return new Expression.Element(Expression.ElementCode.MULT);
            }
        }
        ,
        DIV("/", 20){

            @Override
            public double evaluate(double a, double b) {
                return a / b;
            }

            @Override
            public Expression.Element getElement() {
                return new Expression.Element(Expression.ElementCode.DIV);
            }
        };

        String name;
        int precedence;

        private Operator(String name, int precedence) {
            this.name = name;
            this.precedence = precedence;
        }

        public String toString() {
            return this.name;
        }

        public int precedence() {
            return this.precedence;
        }

        public abstract double evaluate(double var1, double var3);

        public abstract Expression.Element getElement();
    }
}

