/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing;

import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;

public class ConstantProcessNode
extends ProcessNode {
    private String name;

    ConstantProcessNode() {
    }

    public static boolean isValidConstantName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.charAt(0) == '\"') {
            return name.charAt(name.length() - 1) == '\"';
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!ConstantProcessNode.isValidConstantName(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + " not a valid PEPA Constant name");
        }
        this.name = name;
    }

    @Override
    protected void accept0(ASTVisitor v) {
        v.visitConstantProcessNode(this);
    }
}

