/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing;

import java.util.LinkedList;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ActionTypeVisitor;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.MoveOnVisitor;
import uk.ac.ed.inf.pepa.parsing.NodeResolver;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;

public class Resolver
implements NodeResolver {
    private ModelNode model;

    public Resolver(ModelNode node) {
        this.model = node;
    }

    @Override
    public ASTNode getProcessDefinition(String name) {
        for (ProcessDefinitionNode def : this.model.processDefinitions()) {
            if (!def.getName().getName().equals(name)) continue;
            return def;
        }
        return null;
    }

    @Override
    public ASTNode getRateDefinition(String name) {
        for (RateDefinitionNode def : this.model.rateDefinitions()) {
            if (!def.getName().getName().equals(name)) continue;
            return def;
        }
        return null;
    }

    @Override
    public ASTNode[] getConstantUsage(final String name) {
        final LinkedList usage = new LinkedList();
        this.model.accept(new MoveOnVisitor(){

            @Override
            public void visitModelNode(ModelNode model) {
                for (ProcessDefinitionNode def : model.processDefinitions()) {
                    def.accept(this);
                }
                model.getSystemEquation().accept(this);
            }

            @Override
            public void visitProcessDefinitionNode(ProcessDefinitionNode node) {
                node.getName().accept(this);
                node.getNode().accept(this);
            }

            @Override
            public void visitConstantProcessNode(ConstantProcessNode node) {
                if (node.getName().equals(name)) {
                    usage.add(node);
                }
            }

            @Override
            public void visitAggregationNode(AggregationNode node) {
                node.getProcessNode().accept(this);
            }
        });
        return usage.toArray(new ASTNode[usage.size()]);
    }

    @Override
    public ASTNode[] getRateUsage(final String name) {
        final LinkedList usage = new LinkedList();
        this.model.accept(new MoveOnVisitor(){

            @Override
            public void visitModelNode(ModelNode model) {
                for (ASTNode def : model.rateDefinitions()) {
                    def.accept(this);
                }
                for (ASTNode def : model.processDefinitions()) {
                    def.accept(this);
                }
                model.getSystemEquation().accept(this);
            }

            @Override
            public void visitRateDefinitionNode(RateDefinitionNode rateDef) {
                rateDef.getName().accept(this);
                rateDef.getRate().accept(this);
            }

            @Override
            public void visitProcessDefinitionNode(ProcessDefinitionNode node) {
                node.getNode().accept(this);
            }

            @Override
            public void visitPrefixNode(PrefixNode node) {
                node.getActivity().getRate().accept(this);
            }

            @Override
            public void visitVariableRateNode(VariableRateNode variableRate) {
                if (variableRate.getName().equals(name)) {
                    usage.add(variableRate);
                }
            }

            @Override
            public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
                rate.getLeft().accept(this);
                rate.getRight().accept(this);
            }
        });
        return usage.toArray(new ASTNode[usage.size()]);
    }

    @Override
    public ASTNode[] getActionUsage(String constantName, String actionName) {
        ASTNode processDefinition = this.getProcessDefinition(constantName);
        if (processDefinition == null || !(processDefinition instanceof ProcessDefinitionNode)) {
            return null;
        }
        ProcessDefinitionNode procDef = (ProcessDefinitionNode)processDefinition;
        ActionTypeVisitor v = new ActionTypeVisitor(actionName);
        procDef.getNode().accept(v);
        return v.getUsage();
    }
}

