/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing.internal;

import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ILocationInfo;

public class PepaSymbolFactory
extends ComplexSymbolFactory {
    private static Logger logger = Logger.getLogger(PepaSymbolFactory.class);
    private static final ComplexSymbolFactory.Location START_LOCATION = new ComplexSymbolFactory.Location(0, 0);

    public Symbol newSymbol(String name, int id, Symbol left, Symbol right, Object value) {
        logger.debug((Object)("Creating " + name + " l:" + left + " r:" + right + " v:" + value));
        ComplexSymbolFactory.ComplexSymbol sym = (ComplexSymbolFactory.ComplexSymbol)super.newSymbol(name, id, left, right, value);
        logger.debug((Object)("left: " + ((ComplexSymbolFactory.ComplexSymbol)left).getLeft()));
        logger.debug((Object)("right " + ((ComplexSymbolFactory.ComplexSymbol)right).getRight()));
        if (value != null && value instanceof ASTNode) {
            ASTNode node = (ASTNode)value;
            ComplexSymbolFactory.Location locationLeft = ((ComplexSymbolFactory.ComplexSymbol)left).getLeft();
            ComplexSymbolFactory.Location locationRight = ((ComplexSymbolFactory.ComplexSymbol)right).getRight();
            if (locationLeft == null) {
                locationLeft = START_LOCATION;
            }
            if (locationRight == null) {
                locationRight = START_LOCATION;
            }
            node.setLeftLocation(PepaSymbolFactory.getLocationInfo(locationLeft));
            node.setRightLocation(PepaSymbolFactory.getLocationInfo(locationRight));
        }
        return sym;
    }

    public Symbol newSymbol(String name, int id, ComplexSymbolFactory.Location left, ComplexSymbolFactory.Location right, Object value) {
        return super.newSymbol(name, id, left, right, value);
    }

    public Symbol newSymbol(String name, int id, ComplexSymbolFactory.Location left, ComplexSymbolFactory.Location right) {
        return super.newSymbol(name, id, left, right);
    }

    private static ILocationInfo getLocationInfo(final ComplexSymbolFactory.Location complexSymbolLocation) {
        return new ILocationInfo(){

            @Override
            public int getLine() {
                return complexSymbolLocation.getLine();
            }

            @Override
            public int getColumn() {
                return complexSymbolLocation.getColumn();
            }

            @Override
            public int getChar() {
                return -1;
            }

            public int getLength() {
                return -1;
            }
        };
    }
}

